/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.ConnectionType;
import software.amazon.awscdk.services.apigateway.ContentHandling;
import software.amazon.awscdk.services.apigateway.IntegrationResponse;
import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
import software.amazon.awscdk.services.apigateway.VpcLink;
import software.amazon.awscdk.services.iam.Role;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface IntegrationOptions
extends JsiiSerializable {
    public List<String> getCacheKeyParameters();

    public String getCacheNamespace();

    public ConnectionType getConnectionType();

    public ContentHandling getContentHandling();

    public Boolean getCredentialsPassthrough();

    public Role getCredentialsRole();

    public List<IntegrationResponse> getIntegrationResponses();

    public PassthroughBehavior getPassthroughBehavior();

    public Map<String, String> getRequestParameters();

    public Map<String, String> getRequestTemplates();

    public VpcLink getVpcLink();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        @Nullable
        private List<String> _cacheKeyParameters;
        @Nullable
        private String _cacheNamespace;
        @Nullable
        private ConnectionType _connectionType;
        @Nullable
        private ContentHandling _contentHandling;
        @Nullable
        private Boolean _credentialsPassthrough;
        @Nullable
        private Role _credentialsRole;
        @Nullable
        private List<IntegrationResponse> _integrationResponses;
        @Nullable
        private PassthroughBehavior _passthroughBehavior;
        @Nullable
        private Map<String, String> _requestParameters;
        @Nullable
        private Map<String, String> _requestTemplates;
        @Nullable
        private VpcLink _vpcLink;

        public Builder withCacheKeyParameters(@Nullable List<String> value) {
            this._cacheKeyParameters = value;
            return this;
        }

        public Builder withCacheNamespace(@Nullable String value) {
            this._cacheNamespace = value;
            return this;
        }

        public Builder withConnectionType(@Nullable ConnectionType value) {
            this._connectionType = value;
            return this;
        }

        public Builder withContentHandling(@Nullable ContentHandling value) {
            this._contentHandling = value;
            return this;
        }

        public Builder withCredentialsPassthrough(@Nullable Boolean value) {
            this._credentialsPassthrough = value;
            return this;
        }

        public Builder withCredentialsRole(@Nullable Role value) {
            this._credentialsRole = value;
            return this;
        }

        public Builder withIntegrationResponses(@Nullable List<IntegrationResponse> value) {
            this._integrationResponses = value;
            return this;
        }

        public Builder withPassthroughBehavior(@Nullable PassthroughBehavior value) {
            this._passthroughBehavior = value;
            return this;
        }

        public Builder withRequestParameters(@Nullable Map<String, String> value) {
            this._requestParameters = value;
            return this;
        }

        public Builder withRequestTemplates(@Nullable Map<String, String> value) {
            this._requestTemplates = value;
            return this;
        }

        public Builder withVpcLink(@Nullable VpcLink value) {
            this._vpcLink = value;
            return this;
        }

        public IntegrationOptions build() {
            return new IntegrationOptions(){
                @Nullable
                private final List<String> $cacheKeyParameters;
                @Nullable
                private final String $cacheNamespace;
                @Nullable
                private final ConnectionType $connectionType;
                @Nullable
                private final ContentHandling $contentHandling;
                @Nullable
                private final Boolean $credentialsPassthrough;
                @Nullable
                private final Role $credentialsRole;
                @Nullable
                private final List<IntegrationResponse> $integrationResponses;
                @Nullable
                private final PassthroughBehavior $passthroughBehavior;
                @Nullable
                private final Map<String, String> $requestParameters;
                @Nullable
                private final Map<String, String> $requestTemplates;
                @Nullable
                private final VpcLink $vpcLink;
                {
                    this.$cacheKeyParameters = _cacheKeyParameters;
                    this.$cacheNamespace = _cacheNamespace;
                    this.$connectionType = _connectionType;
                    this.$contentHandling = _contentHandling;
                    this.$credentialsPassthrough = _credentialsPassthrough;
                    this.$credentialsRole = _credentialsRole;
                    this.$integrationResponses = _integrationResponses;
                    this.$passthroughBehavior = _passthroughBehavior;
                    this.$requestParameters = _requestParameters;
                    this.$requestTemplates = _requestTemplates;
                    this.$vpcLink = _vpcLink;
                }

                @Override
                public List<String> getCacheKeyParameters() {
                    return this.$cacheKeyParameters;
                }

                @Override
                public String getCacheNamespace() {
                    return this.$cacheNamespace;
                }

                @Override
                public ConnectionType getConnectionType() {
                    return this.$connectionType;
                }

                @Override
                public ContentHandling getContentHandling() {
                    return this.$contentHandling;
                }

                @Override
                public Boolean getCredentialsPassthrough() {
                    return this.$credentialsPassthrough;
                }

                @Override
                public Role getCredentialsRole() {
                    return this.$credentialsRole;
                }

                @Override
                public List<IntegrationResponse> getIntegrationResponses() {
                    return this.$integrationResponses;
                }

                @Override
                public PassthroughBehavior getPassthroughBehavior() {
                    return this.$passthroughBehavior;
                }

                @Override
                public Map<String, String> getRequestParameters() {
                    return this.$requestParameters;
                }

                @Override
                public Map<String, String> getRequestTemplates() {
                    return this.$requestTemplates;
                }

                @Override
                public VpcLink getVpcLink() {
                    return this.$vpcLink;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                    obj.set("cacheNamespace", om.valueToTree((Object)this.getCacheNamespace()));
                    obj.set("connectionType", om.valueToTree((Object)this.getConnectionType()));
                    obj.set("contentHandling", om.valueToTree((Object)this.getContentHandling()));
                    obj.set("credentialsPassthrough", om.valueToTree((Object)this.getCredentialsPassthrough()));
                    obj.set("credentialsRole", om.valueToTree((Object)this.getCredentialsRole()));
                    obj.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                    obj.set("passthroughBehavior", om.valueToTree((Object)this.getPassthroughBehavior()));
                    obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                    obj.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                    obj.set("vpcLink", om.valueToTree((Object)this.getVpcLink()));
                    return obj;
                }
            };
        }
    }
}

