/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.Token;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnAuthorizerV2Props
extends JsiiSerializable {
    public String getApiId();

    public String getAuthorizerType();

    public String getAuthorizerUri();

    public List<String> getIdentitySource();

    public String getName();

    public String getAuthorizerCredentialsArn();

    public Object getAuthorizerResultTtlInSeconds();

    public String getIdentityValidationExpression();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _apiId;
        private String _authorizerType;
        private String _authorizerUri;
        private List<String> _identitySource;
        private String _name;
        @Nullable
        private String _authorizerCredentialsArn;
        @Nullable
        private Object _authorizerResultTtlInSeconds;
        @Nullable
        private String _identityValidationExpression;

        public Builder withApiId(String value) {
            this._apiId = Objects.requireNonNull(value, "apiId is required");
            return this;
        }

        public Builder withAuthorizerType(String value) {
            this._authorizerType = Objects.requireNonNull(value, "authorizerType is required");
            return this;
        }

        public Builder withAuthorizerUri(String value) {
            this._authorizerUri = Objects.requireNonNull(value, "authorizerUri is required");
            return this;
        }

        public Builder withIdentitySource(List<String> value) {
            this._identitySource = Objects.requireNonNull(value, "identitySource is required");
            return this;
        }

        public Builder withName(String value) {
            this._name = Objects.requireNonNull(value, "name is required");
            return this;
        }

        public Builder withAuthorizerCredentialsArn(@Nullable String value) {
            this._authorizerCredentialsArn = value;
            return this;
        }

        public Builder withAuthorizerResultTtlInSeconds(@Nullable Number value) {
            this._authorizerResultTtlInSeconds = value;
            return this;
        }

        public Builder withAuthorizerResultTtlInSeconds(@Nullable Token value) {
            this._authorizerResultTtlInSeconds = value;
            return this;
        }

        public Builder withIdentityValidationExpression(@Nullable String value) {
            this._identityValidationExpression = value;
            return this;
        }

        public CfnAuthorizerV2Props build() {
            return new CfnAuthorizerV2Props(){
                private final String $apiId;
                private final String $authorizerType;
                private final String $authorizerUri;
                private final List<String> $identitySource;
                private final String $name;
                @Nullable
                private final String $authorizerCredentialsArn;
                @Nullable
                private final Object $authorizerResultTtlInSeconds;
                @Nullable
                private final String $identityValidationExpression;
                {
                    this.$apiId = Objects.requireNonNull(_apiId, "apiId is required");
                    this.$authorizerType = Objects.requireNonNull(_authorizerType, "authorizerType is required");
                    this.$authorizerUri = Objects.requireNonNull(_authorizerUri, "authorizerUri is required");
                    this.$identitySource = Objects.requireNonNull(_identitySource, "identitySource is required");
                    this.$name = Objects.requireNonNull(_name, "name is required");
                    this.$authorizerCredentialsArn = _authorizerCredentialsArn;
                    this.$authorizerResultTtlInSeconds = _authorizerResultTtlInSeconds;
                    this.$identityValidationExpression = _identityValidationExpression;
                }

                @Override
                public String getApiId() {
                    return this.$apiId;
                }

                @Override
                public String getAuthorizerType() {
                    return this.$authorizerType;
                }

                @Override
                public String getAuthorizerUri() {
                    return this.$authorizerUri;
                }

                @Override
                public List<String> getIdentitySource() {
                    return this.$identitySource;
                }

                @Override
                public String getName() {
                    return this.$name;
                }

                @Override
                public String getAuthorizerCredentialsArn() {
                    return this.$authorizerCredentialsArn;
                }

                @Override
                public Object getAuthorizerResultTtlInSeconds() {
                    return this.$authorizerResultTtlInSeconds;
                }

                @Override
                public String getIdentityValidationExpression() {
                    return this.$identityValidationExpression;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("apiId", om.valueToTree((Object)this.getApiId()));
                    obj.set("authorizerType", om.valueToTree((Object)this.getAuthorizerType()));
                    obj.set("authorizerUri", om.valueToTree((Object)this.getAuthorizerUri()));
                    obj.set("identitySource", om.valueToTree(this.getIdentitySource()));
                    obj.set("name", om.valueToTree((Object)this.getName()));
                    if (this.getAuthorizerCredentialsArn() != null) {
                        obj.set("authorizerCredentialsArn", om.valueToTree((Object)this.getAuthorizerCredentialsArn()));
                    }
                    if (this.getAuthorizerResultTtlInSeconds() != null) {
                        obj.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
                    }
                    if (this.getIdentityValidationExpression() != null) {
                        obj.set("identityValidationExpression", om.valueToTree((Object)this.getIdentityValidationExpression()));
                    }
                    return obj;
                }
            };
        }
    }
}

