package software.amazon.awscdk.services.apigateway;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.11.3 (build 464b8c6)", date = "2019-06-19T15:16:54.648Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface IntegrationResponse extends software.amazon.jsii.JsiiSerializable {
    /**
     * The status code that API Gateway uses to map the integration response to a MethodResponse status code.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getStatusCode();
    /**
     * Specifies how to handle request payload content type conversions.
     * 
     * Default: none the request payload is passed through from the method
     * request to the integration request without modification.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling();
    /**
     * The response parameters from the backend response that API Gateway sends to the method response.
     * 
     * Use the destination as the key and the source as the value:
     * 
     * - The destination must be an existing response parameter in the
     *    MethodResponse property.
     * - The source must be an existing method request parameter or a static
     *    value. You must enclose static values in single quotation marks and
     *    pre-encode these values based on the destination specified in the
     *    request.
     * 
     * EXPERIMENTAL
     * 
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getResponseParameters();
    /**
     * The templates that are used to transform the integration response body. Specify templates as key-value pairs, with a content type as the key and a template as the value.
     * 
     * EXPERIMENTAL
     * 
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getResponseTemplates();
    /**
     * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
     * 
     * For example, if the success response returns nothing and the error response returns some string, you
     * could use the ``.+`` regex to match error response. However, make sure that the error response does not contain any
     * newline (``\n``) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error
     * header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-integration-settings-integration-response.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getSelectionPattern();

    /**
     * @return a {@link Builder} of {@link IntegrationResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        private java.lang.String _statusCode;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ContentHandling _contentHandling;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _responseParameters;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _responseTemplates;
        @javax.annotation.Nullable
        private java.lang.String _selectionPattern;

        /**
         * Sets the value of StatusCode
         * @param value The status code that API Gateway uses to map the integration response to a MethodResponse status code.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withStatusCode(final java.lang.String value) {
            this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
            return this;
        }
        /**
         * Sets the value of ContentHandling
         * @param value Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ContentHandling value) {
            this._contentHandling = value;
            return this;
        }
        /**
         * Sets the value of ResponseParameters
         * @param value The response parameters from the backend response that API Gateway sends to the method response.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._responseParameters = value;
            return this;
        }
        /**
         * Sets the value of ResponseTemplates
         * @param value The templates that are used to transform the integration response body. Specify templates as key-value pairs, with a content type as the key and a template as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._responseTemplates = value;
            return this;
        }
        /**
         * Sets the value of SelectionPattern
         * @param value Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
            this._selectionPattern = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public IntegrationResponse build() {
            return new IntegrationResponse() {
                private final java.lang.String $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.ContentHandling $contentHandling = _contentHandling;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $responseParameters = _responseParameters;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $responseTemplates = _responseTemplates;
                @javax.annotation.Nullable
                private final java.lang.String $selectionPattern = _selectionPattern;

                @Override
                public java.lang.String getStatusCode() {
                    return this.$statusCode;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
                    return this.$contentHandling;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
                    return this.$responseParameters;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
                    return this.$responseTemplates;
                }

                @Override
                public java.lang.String getSelectionPattern() {
                    return this.$selectionPattern;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                    if (this.getContentHandling() != null) {
                        obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                    }
                    if (this.getResponseParameters() != null) {
                        obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                    }
                    if (this.getResponseTemplates() != null) {
                        obj.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                    }
                    if (this.getSelectionPattern() != null) {
                        obj.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationResponse {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The status code that API Gateway uses to map the integration response to a MethodResponse status code.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public java.lang.String getStatusCode() {
            return this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * 
         * Default: none the request payload is passed through from the method
         * request to the integration request without modification.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.jsiiGet("contentHandling", software.amazon.awscdk.services.apigateway.ContentHandling.class);
        }

        /**
         * The response parameters from the backend response that API Gateway sends to the method response.
         * 
         * Use the destination as the key and the source as the value:
         * 
         * - The destination must be an existing response parameter in the
         *    MethodResponse property.
         * - The source must be an existing method request parameter or a static
         *    value. You must enclose static values in single quotation marks and
         *    pre-encode these values based on the destination specified in the
         *    request.
         * 
         * EXPERIMENTAL
         * 
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
            return this.jsiiGet("responseParameters", java.util.Map.class);
        }

        /**
         * The templates that are used to transform the integration response body. Specify templates as key-value pairs, with a content type as the key and a template as the value.
         * 
         * EXPERIMENTAL
         * 
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
            return this.jsiiGet("responseTemplates", java.util.Map.class);
        }

        /**
         * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
         * 
         * For example, if the success response returns nothing and the error response returns some string, you
         * could use the ``.+`` regex to match error response. However, make sure that the error response does not contain any
         * newline (``\n``) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error
         * header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-integration-settings-integration-response.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getSelectionPattern() {
            return this.jsiiGet("selectionPattern", java.lang.String.class);
        }
    }
}
