/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IntegrationOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface AwsIntegrationProps
extends JsiiSerializable {
    public String getService();

    public String getAction();

    public Map<String, String> getActionParameters();

    public String getIntegrationHttpMethod();

    public IntegrationOptions getOptions();

    public String getPath();

    public Boolean getProxy();

    public String getSubdomain();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _service;
        @Nullable
        private String _action;
        @Nullable
        private Map<String, String> _actionParameters;
        @Nullable
        private String _integrationHttpMethod;
        @Nullable
        private IntegrationOptions _options;
        @Nullable
        private String _path;
        @Nullable
        private Boolean _proxy;
        @Nullable
        private String _subdomain;

        public Builder withService(String value) {
            this._service = Objects.requireNonNull(value, "service is required");
            return this;
        }

        public Builder withAction(@Nullable String value) {
            this._action = value;
            return this;
        }

        public Builder withActionParameters(@Nullable Map<String, String> value) {
            this._actionParameters = value;
            return this;
        }

        public Builder withIntegrationHttpMethod(@Nullable String value) {
            this._integrationHttpMethod = value;
            return this;
        }

        public Builder withOptions(@Nullable IntegrationOptions value) {
            this._options = value;
            return this;
        }

        public Builder withPath(@Nullable String value) {
            this._path = value;
            return this;
        }

        public Builder withProxy(@Nullable Boolean value) {
            this._proxy = value;
            return this;
        }

        public Builder withSubdomain(@Nullable String value) {
            this._subdomain = value;
            return this;
        }

        public AwsIntegrationProps build() {
            return new AwsIntegrationProps(){
                private final String $service;
                @Nullable
                private final String $action;
                @Nullable
                private final Map<String, String> $actionParameters;
                @Nullable
                private final String $integrationHttpMethod;
                @Nullable
                private final IntegrationOptions $options;
                @Nullable
                private final String $path;
                @Nullable
                private final Boolean $proxy;
                @Nullable
                private final String $subdomain;
                {
                    this.$service = Objects.requireNonNull(_service, "service is required");
                    this.$action = _action;
                    this.$actionParameters = _actionParameters;
                    this.$integrationHttpMethod = _integrationHttpMethod;
                    this.$options = _options;
                    this.$path = _path;
                    this.$proxy = _proxy;
                    this.$subdomain = _subdomain;
                }

                @Override
                public String getService() {
                    return this.$service;
                }

                @Override
                public String getAction() {
                    return this.$action;
                }

                @Override
                public Map<String, String> getActionParameters() {
                    return this.$actionParameters;
                }

                @Override
                public String getIntegrationHttpMethod() {
                    return this.$integrationHttpMethod;
                }

                @Override
                public IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public String getPath() {
                    return this.$path;
                }

                @Override
                public Boolean getProxy() {
                    return this.$proxy;
                }

                @Override
                public String getSubdomain() {
                    return this.$subdomain;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("service", om.valueToTree((Object)this.getService()));
                    if (this.getAction() != null) {
                        obj.set("action", om.valueToTree((Object)this.getAction()));
                    }
                    if (this.getActionParameters() != null) {
                        obj.set("actionParameters", om.valueToTree(this.getActionParameters()));
                    }
                    if (this.getIntegrationHttpMethod() != null) {
                        obj.set("integrationHttpMethod", om.valueToTree((Object)this.getIntegrationHttpMethod()));
                    }
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree((Object)this.getOptions()));
                    }
                    if (this.getPath() != null) {
                        obj.set("path", om.valueToTree((Object)this.getPath()));
                    }
                    if (this.getProxy() != null) {
                        obj.set("proxy", om.valueToTree((Object)this.getProxy()));
                    }
                    if (this.getSubdomain() != null) {
                        obj.set("subdomain", om.valueToTree((Object)this.getSubdomain()));
                    }
                    return obj;
                }
            };
        }
    }
}

