/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.RestApiProps;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface LambdaRestApiProps
extends JsiiSerializable {
    public IFunction getHandler();

    public RestApiProps getOptions();

    public Boolean getProxy();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IFunction _handler;
        @Nullable
        private RestApiProps _options;
        @Nullable
        private Boolean _proxy;

        public Builder withHandler(IFunction value) {
            this._handler = Objects.requireNonNull(value, "handler is required");
            return this;
        }

        public Builder withOptions(@Nullable RestApiProps value) {
            this._options = value;
            return this;
        }

        public Builder withProxy(@Nullable Boolean value) {
            this._proxy = value;
            return this;
        }

        public LambdaRestApiProps build() {
            return new LambdaRestApiProps(){
                private final IFunction $handler;
                @Nullable
                private final RestApiProps $options;
                @Nullable
                private final Boolean $proxy;
                {
                    this.$handler = Objects.requireNonNull(_handler, "handler is required");
                    this.$options = _options;
                    this.$proxy = _proxy;
                }

                @Override
                public IFunction getHandler() {
                    return this.$handler;
                }

                @Override
                public RestApiProps getOptions() {
                    return this.$options;
                }

                @Override
                public Boolean getProxy() {
                    return this.$proxy;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("handler", om.valueToTree((Object)this.getHandler()));
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree((Object)this.getOptions()));
                    }
                    if (this.getProxy() != null) {
                        obj.set("proxy", om.valueToTree((Object)this.getProxy()));
                    }
                    return obj;
                }
            };
        }
    }
}

