package software.amazon.awscdk.services.apigateway;

/**
 * EXPERIMENTAL
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.12.1 (build 3ce4842)", date = "2019-06-25T14:13:04.413Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
public interface RestApiProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {
    /**
     * The source of the API key for metering requests according to a usage plan.
     * 
     * Default: - Metering is disabled.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType();
    /**
     * The list of binary media mine-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
     * 
     * Default: - RestApi supports only UTF-8-encoded text payloads.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<java.lang.String> getBinaryMediaTypes();
    /**
     * The ID of the API Gateway RestApi resource that you want to clone.
     * 
     * Default: - None.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom();
    /**
     * Automatically configure an AWS CloudWatch role for API Gateway.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getCloudWatchRole();
    /**
     * Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
     * 
     * Since API Gateway deployments are immutable, When this option is enabled
     * (by default), an AWS::ApiGateway::Deployment resource will automatically
     * created with a logical ID that hashes the API model (methods, resources
     * and options). This means that when the model changes, the logical ID of
     * this CloudFormation resource will change, and a new deployment will be
     * created.
     * 
     * If this is set, `latestDeployment` will refer to the `Deployment` object
     * and `deploymentStage` will refer to a `Stage` that points to this
     * deployment. To customize the stage options, use the `deployStageOptions`
     * property.
     * 
     * A CloudFormation Output will also be defined with the root URL endpoint
     * of this REST API.
     * 
     * Default: true
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getDeploy();
    /**
     * Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
     * 
     * If `deploy` is disabled,
     * this value cannot be set.
     * 
     * Default: - Based on defaults of `StageOptions`.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions();
    /**
     * A description of the purpose of this API Gateway RestApi resource.
     * 
     * Default: - No description.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getDescription();
    /**
     * A list of the endpoint types of the API.
     * 
     * Use this property when creating
     * an API.
     * 
     * Default: - No endpoint types.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes();
    /**
     * Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
     * 
     * Default: false
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getFailOnWarnings();
    /**
     * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
     * 
     * When compression is enabled, compression or
     * decompression is not applied on the payload if the payload size is
     * smaller than this value. Setting it to zero allows compression for any
     * payload size.
     * 
     * Default: - Compression is disabled.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Number getMinimumCompressionSize();
    /**
     * Custom header parameters for the request.
     * 
     * Default: - No parameters.
     * 
     * EXPERIMENTAL
     * 
     * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.util.Map<java.lang.String, java.lang.String> getParameters();
    /**
     * A policy document that contains the permissions for this RestApi.
     * 
     * Default: - No policy.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    software.amazon.awscdk.services.iam.PolicyDocument getPolicy();
    /**
     * A name for the API Gateway RestApi resource.
     * 
     * Default: - ID of the RestApi construct.
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.String getRestApiName();
    /**
     * Retains old deployment resources when the API changes.
     * 
     * This allows
     * manually reverting stages to point to old deployments via the AWS
     * Console.
     * 
     * Default: false
     * 
     * EXPERIMENTAL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    java.lang.Boolean getRetainDeployments();

    /**
     * @return a {@link Builder} of {@link RestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link RestApiProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.ApiKeySourceType _apiKeySourceType;
        @javax.annotation.Nullable
        private java.util.List<java.lang.String> _binaryMediaTypes;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IRestApi _cloneFrom;
        @javax.annotation.Nullable
        private java.lang.Boolean _cloudWatchRole;
        @javax.annotation.Nullable
        private java.lang.Boolean _deploy;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.StageOptions _deployOptions;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> _endpointTypes;
        @javax.annotation.Nullable
        private java.lang.Boolean _failOnWarnings;
        @javax.annotation.Nullable
        private java.lang.Number _minimumCompressionSize;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _parameters;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.iam.PolicyDocument _policy;
        @javax.annotation.Nullable
        private java.lang.String _restApiName;
        @javax.annotation.Nullable
        private java.lang.Boolean _retainDeployments;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.Integration _defaultIntegration;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodOptions _defaultMethodOptions;

        /**
         * Sets the value of ApiKeySourceType
         * @param value The source of the API key for metering requests according to a usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withApiKeySourceType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.ApiKeySourceType value) {
            this._apiKeySourceType = value;
            return this;
        }
        /**
         * Sets the value of BinaryMediaTypes
         * @param value The list of binary media mine-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withBinaryMediaTypes(@javax.annotation.Nullable final java.util.List<java.lang.String> value) {
            this._binaryMediaTypes = value;
            return this;
        }
        /**
         * Sets the value of CloneFrom
         * @param value The ID of the API Gateway RestApi resource that you want to clone.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCloneFrom(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IRestApi value) {
            this._cloneFrom = value;
            return this;
        }
        /**
         * Sets the value of CloudWatchRole
         * @param value Automatically configure an AWS CloudWatch role for API Gateway.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withCloudWatchRole(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cloudWatchRole = value;
            return this;
        }
        /**
         * Sets the value of Deploy
         * @param value Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeploy(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._deploy = value;
            return this;
        }
        /**
         * Sets the value of DeployOptions
         * @param value Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDeployOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.StageOptions value) {
            this._deployOptions = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of this API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of EndpointTypes
         * @param value A list of the endpoint types of the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withEndpointTypes(@javax.annotation.Nullable final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> value) {
            this._endpointTypes = value;
            return this;
        }
        /**
         * Sets the value of FailOnWarnings
         * @param value Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withFailOnWarnings(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._failOnWarnings = value;
            return this;
        }
        /**
         * Sets the value of MinimumCompressionSize
         * @param value A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withMinimumCompressionSize(@javax.annotation.Nullable final java.lang.Number value) {
            this._minimumCompressionSize = value;
            return this;
        }
        /**
         * Sets the value of Parameters
         * @param value Custom header parameters for the request.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._parameters = value;
            return this;
        }
        /**
         * Sets the value of Policy
         * @param value A policy document that contains the permissions for this RestApi.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withPolicy(@javax.annotation.Nullable final software.amazon.awscdk.services.iam.PolicyDocument value) {
            this._policy = value;
            return this;
        }
        /**
         * Sets the value of RestApiName
         * @param value A name for the API Gateway RestApi resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRestApiName(@javax.annotation.Nullable final java.lang.String value) {
            this._restApiName = value;
            return this;
        }
        /**
         * Sets the value of RetainDeployments
         * @param value Retains old deployment resources when the API changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withRetainDeployments(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._retainDeployments = value;
            return this;
        }
        /**
         * Sets the value of DefaultIntegration
         * @param value An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDefaultIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.Integration value) {
            this._defaultIntegration = value;
            return this;
        }
        /**
         * Sets the value of DefaultMethodOptions
         * @param value Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public Builder withDefaultMethodOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodOptions value) {
            this._defaultMethodOptions = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link RestApiProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        public RestApiProps build() {
            return new RestApiProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.ApiKeySourceType $apiKeySourceType = _apiKeySourceType;
                @javax.annotation.Nullable
                private final java.util.List<java.lang.String> $binaryMediaTypes = _binaryMediaTypes;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IRestApi $cloneFrom = _cloneFrom;
                @javax.annotation.Nullable
                private final java.lang.Boolean $cloudWatchRole = _cloudWatchRole;
                @javax.annotation.Nullable
                private final java.lang.Boolean $deploy = _deploy;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.StageOptions $deployOptions = _deployOptions;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> $endpointTypes = _endpointTypes;
                @javax.annotation.Nullable
                private final java.lang.Boolean $failOnWarnings = _failOnWarnings;
                @javax.annotation.Nullable
                private final java.lang.Number $minimumCompressionSize = _minimumCompressionSize;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $parameters = _parameters;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.iam.PolicyDocument $policy = _policy;
                @javax.annotation.Nullable
                private final java.lang.String $restApiName = _restApiName;
                @javax.annotation.Nullable
                private final java.lang.Boolean $retainDeployments = _retainDeployments;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.Integration $defaultIntegration = _defaultIntegration;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodOptions $defaultMethodOptions = _defaultMethodOptions;

                @Override
                public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
                    return this.$apiKeySourceType;
                }

                @Override
                public java.util.List<java.lang.String> getBinaryMediaTypes() {
                    return this.$binaryMediaTypes;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom() {
                    return this.$cloneFrom;
                }

                @Override
                public java.lang.Boolean getCloudWatchRole() {
                    return this.$cloudWatchRole;
                }

                @Override
                public java.lang.Boolean getDeploy() {
                    return this.$deploy;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
                    return this.$deployOptions;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
                    return this.$endpointTypes;
                }

                @Override
                public java.lang.Boolean getFailOnWarnings() {
                    return this.$failOnWarnings;
                }

                @Override
                public java.lang.Number getMinimumCompressionSize() {
                    return this.$minimumCompressionSize;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getParameters() {
                    return this.$parameters;
                }

                @Override
                public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
                    return this.$policy;
                }

                @Override
                public java.lang.String getRestApiName() {
                    return this.$restApiName;
                }

                @Override
                public java.lang.Boolean getRetainDeployments() {
                    return this.$retainDeployments;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
                    return this.$defaultIntegration;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
                    return this.$defaultMethodOptions;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getApiKeySourceType() != null) {
                        obj.set("apiKeySourceType", om.valueToTree(this.getApiKeySourceType()));
                    }
                    if (this.getBinaryMediaTypes() != null) {
                        obj.set("binaryMediaTypes", om.valueToTree(this.getBinaryMediaTypes()));
                    }
                    if (this.getCloneFrom() != null) {
                        obj.set("cloneFrom", om.valueToTree(this.getCloneFrom()));
                    }
                    if (this.getCloudWatchRole() != null) {
                        obj.set("cloudWatchRole", om.valueToTree(this.getCloudWatchRole()));
                    }
                    if (this.getDeploy() != null) {
                        obj.set("deploy", om.valueToTree(this.getDeploy()));
                    }
                    if (this.getDeployOptions() != null) {
                        obj.set("deployOptions", om.valueToTree(this.getDeployOptions()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getEndpointTypes() != null) {
                        obj.set("endpointTypes", om.valueToTree(this.getEndpointTypes()));
                    }
                    if (this.getFailOnWarnings() != null) {
                        obj.set("failOnWarnings", om.valueToTree(this.getFailOnWarnings()));
                    }
                    if (this.getMinimumCompressionSize() != null) {
                        obj.set("minimumCompressionSize", om.valueToTree(this.getMinimumCompressionSize()));
                    }
                    if (this.getParameters() != null) {
                        obj.set("parameters", om.valueToTree(this.getParameters()));
                    }
                    if (this.getPolicy() != null) {
                        obj.set("policy", om.valueToTree(this.getPolicy()));
                    }
                    if (this.getRestApiName() != null) {
                        obj.set("restApiName", om.valueToTree(this.getRestApiName()));
                    }
                    if (this.getRetainDeployments() != null) {
                        obj.set("retainDeployments", om.valueToTree(this.getRetainDeployments()));
                    }
                    if (this.getDefaultIntegration() != null) {
                        obj.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
                    }
                    if (this.getDefaultMethodOptions() != null) {
                        obj.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.RestApiProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The source of the API key for metering requests according to a usage plan.
         * 
         * Default: - Metering is disabled.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.ApiKeySourceType getApiKeySourceType() {
            return this.jsiiGet("apiKeySourceType", software.amazon.awscdk.services.apigateway.ApiKeySourceType.class);
        }

        /**
         * The list of binary media mine-types that are supported by the RestApi resource, such as "image/png" or "application/octet-stream".
         * 
         * Default: - RestApi supports only UTF-8-encoded text payloads.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<java.lang.String> getBinaryMediaTypes() {
            return this.jsiiGet("binaryMediaTypes", java.util.List.class);
        }

        /**
         * The ID of the API Gateway RestApi resource that you want to clone.
         * 
         * Default: - None.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IRestApi getCloneFrom() {
            return this.jsiiGet("cloneFrom", software.amazon.awscdk.services.apigateway.IRestApi.class);
        }

        /**
         * Automatically configure an AWS CloudWatch role for API Gateway.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getCloudWatchRole() {
            return this.jsiiGet("cloudWatchRole", java.lang.Boolean.class);
        }

        /**
         * Indicates if a Deployment should be automatically created for this API, and recreated when the API model (resources, methods) changes.
         * 
         * Since API Gateway deployments are immutable, When this option is enabled
         * (by default), an AWS::ApiGateway::Deployment resource will automatically
         * created with a logical ID that hashes the API model (methods, resources
         * and options). This means that when the model changes, the logical ID of
         * this CloudFormation resource will change, and a new deployment will be
         * created.
         * 
         * If this is set, `latestDeployment` will refer to the `Deployment` object
         * and `deploymentStage` will refer to a `Stage` that points to this
         * deployment. To customize the stage options, use the `deployStageOptions`
         * property.
         * 
         * A CloudFormation Output will also be defined with the root URL endpoint
         * of this REST API.
         * 
         * Default: true
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getDeploy() {
            return this.jsiiGet("deploy", java.lang.Boolean.class);
        }

        /**
         * Options for the API Gateway stage that will always point to the latest deployment when `deploy` is enabled.
         * 
         * If `deploy` is disabled,
         * this value cannot be set.
         * 
         * Default: - Based on defaults of `StageOptions`.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.StageOptions getDeployOptions() {
            return this.jsiiGet("deployOptions", software.amazon.awscdk.services.apigateway.StageOptions.class);
        }

        /**
         * A description of the purpose of this API Gateway RestApi resource.
         * 
         * Default: - No description.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A list of the endpoint types of the API.
         * 
         * Use this property when creating
         * an API.
         * 
         * Default: - No endpoint types.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getEndpointTypes() {
            return this.jsiiGet("endpointTypes", java.util.List.class);
        }

        /**
         * Indicates whether to roll back the resource if a warning occurs while API Gateway is creating the RestApi resource.
         * 
         * Default: false
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getFailOnWarnings() {
            return this.jsiiGet("failOnWarnings", java.lang.Boolean.class);
        }

        /**
         * A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (when undefined) on an API.
         * 
         * When compression is enabled, compression or
         * decompression is not applied on the payload if the payload size is
         * smaller than this value. Setting it to zero allows compression for any
         * payload size.
         * 
         * Default: - Compression is disabled.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Number getMinimumCompressionSize() {
            return this.jsiiGet("minimumCompressionSize", java.lang.Number.class);
        }

        /**
         * Custom header parameters for the request.
         * 
         * Default: - No parameters.
         * 
         * EXPERIMENTAL
         * 
         * @see https://docs.aws.amazon.com/cli/latest/reference/apigateway/import-rest-api.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.jsiiGet("parameters", java.util.Map.class);
        }

        /**
         * A policy document that contains the permissions for this RestApi.
         * 
         * Default: - No policy.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.iam.PolicyDocument getPolicy() {
            return this.jsiiGet("policy", software.amazon.awscdk.services.iam.PolicyDocument.class);
        }

        /**
         * A name for the API Gateway RestApi resource.
         * 
         * Default: - ID of the RestApi construct.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.String getRestApiName() {
            return this.jsiiGet("restApiName", java.lang.String.class);
        }

        /**
         * Retains old deployment resources when the API changes.
         * 
         * This allows
         * manually reverting stages to point to old deployments via the AWS
         * Console.
         * 
         * Default: false
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public java.lang.Boolean getRetainDeployments() {
            return this.jsiiGet("retainDeployments", java.lang.Boolean.class);
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * 
         * Default: - Inherited from parent.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.jsiiGet("defaultIntegration", software.amazon.awscdk.services.apigateway.Integration.class);
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * 
         * Default: - Inherited from parent.
         * 
         * EXPERIMENTAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Experimental)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.jsiiGet("defaultMethodOptions", software.amazon.awscdk.services.apigateway.MethodOptions.class);
        }
    }
}
