/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.BasePathMappingOptions;
import software.amazon.awscdk.services.apigateway.IDomainName;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface BasePathMappingProps
extends JsiiSerializable,
BasePathMappingOptions {
    public IDomainName getDomainName();

    public IRestApi getRestApi();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IDomainName _domainName;
        private IRestApi _restApi;
        @Nullable
        private String _basePath;

        public Builder withDomainName(IDomainName value) {
            this._domainName = Objects.requireNonNull(value, "domainName is required");
            return this;
        }

        public Builder withRestApi(IRestApi value) {
            this._restApi = Objects.requireNonNull(value, "restApi is required");
            return this;
        }

        public Builder withBasePath(@Nullable String value) {
            this._basePath = value;
            return this;
        }

        public BasePathMappingProps build() {
            return new BasePathMappingProps(){
                private final IDomainName $domainName;
                private final IRestApi $restApi;
                @Nullable
                private final String $basePath;
                {
                    this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    this.$restApi = Objects.requireNonNull(_restApi, "restApi is required");
                    this.$basePath = _basePath;
                }

                @Override
                public IDomainName getDomainName() {
                    return this.$domainName;
                }

                @Override
                public IRestApi getRestApi() {
                    return this.$restApi;
                }

                @Override
                public String getBasePath() {
                    return this.$basePath;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    obj.set("restApi", om.valueToTree((Object)this.getRestApi()));
                    if (this.getBasePath() != null) {
                        obj.set("basePath", om.valueToTree((Object)this.getBasePath()));
                    }
                    return obj;
                }
            };
        }
    }
}

