/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IResource;
import software.amazon.awscdk.services.apigateway.Integration;
import software.amazon.awscdk.services.apigateway.MethodOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface MethodProps
extends JsiiSerializable {
    public String getHttpMethod();

    public IResource getResource();

    public Integration getIntegration();

    public MethodOptions getOptions();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _httpMethod;
        private IResource _resource;
        @Nullable
        private Integration _integration;
        @Nullable
        private MethodOptions _options;

        public Builder withHttpMethod(String value) {
            this._httpMethod = Objects.requireNonNull(value, "httpMethod is required");
            return this;
        }

        public Builder withResource(IResource value) {
            this._resource = Objects.requireNonNull(value, "resource is required");
            return this;
        }

        public Builder withIntegration(@Nullable Integration value) {
            this._integration = value;
            return this;
        }

        public Builder withOptions(@Nullable MethodOptions value) {
            this._options = value;
            return this;
        }

        public MethodProps build() {
            return new MethodProps(){
                private final String $httpMethod;
                private final IResource $resource;
                @Nullable
                private final Integration $integration;
                @Nullable
                private final MethodOptions $options;
                {
                    this.$httpMethod = Objects.requireNonNull(_httpMethod, "httpMethod is required");
                    this.$resource = Objects.requireNonNull(_resource, "resource is required");
                    this.$integration = _integration;
                    this.$options = _options;
                }

                @Override
                public String getHttpMethod() {
                    return this.$httpMethod;
                }

                @Override
                public IResource getResource() {
                    return this.$resource;
                }

                @Override
                public Integration getIntegration() {
                    return this.$integration;
                }

                @Override
                public MethodOptions getOptions() {
                    return this.$options;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("httpMethod", om.valueToTree((Object)this.getHttpMethod()));
                    obj.set("resource", om.valueToTree((Object)this.getResource()));
                    if (this.getIntegration() != null) {
                        obj.set("integration", om.valueToTree((Object)this.getIntegration()));
                    }
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree((Object)this.getOptions()));
                    }
                    return obj;
                }
            };
        }
    }
}

