package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:41:01.207Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * Specifies an API method integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationType getType();
    /**
     * The integration's HTTP method type. Required unless you use a MOCK integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getIntegrationHttpMethod();
    /**
     * Integration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();
    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * 
     * - If you specify HTTP for the `type` property, specify the API endpoint URL.
     * - If you specify MOCK for the `type` property, don't specify this property.
     * - If you specify AWS for the `type` property, specify an AWS service that
     *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
     *    For example, a Lambda function URI follows this form:
     *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
     *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
     * 
     * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Object getUri();

    /**
     * @return a {@link Builder} of {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IntegrationType _type;
        @javax.annotation.Nullable
        private java.lang.String _integrationHttpMethod;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IntegrationOptions _options;
        @javax.annotation.Nullable
        private java.lang.Object _uri;

        /**
         * Sets the value of Type
         * @param value Specifies an API method integration type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withType(final software.amazon.awscdk.services.apigateway.IntegrationType value) {
            this._type = java.util.Objects.requireNonNull(value, "type is required");
            return this;
        }
        /**
         * Sets the value of IntegrationHttpMethod
         * @param value The integration's HTTP method type. Required unless you use a MOCK integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
            this._integrationHttpMethod = value;
            return this;
        }
        /**
         * Sets the value of Options
         * @param value Integration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withOptions(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IntegrationOptions value) {
            this._options = value;
            return this;
        }
        /**
         * Sets the value of Uri
         * @param value The Uniform Resource Identifier (URI) for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withUri(@javax.annotation.Nullable final java.lang.Object value) {
            this._uri = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public IntegrationProps build() {
            return new IntegrationProps() {
                private final software.amazon.awscdk.services.apigateway.IntegrationType $type = java.util.Objects.requireNonNull(_type, "type is required");
                @javax.annotation.Nullable
                private final java.lang.String $integrationHttpMethod = _integrationHttpMethod;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IntegrationOptions $options = _options;
                @javax.annotation.Nullable
                private final java.lang.Object $uri = _uri;

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
                    return this.$type;
                }

                @Override
                public java.lang.String getIntegrationHttpMethod() {
                    return this.$integrationHttpMethod;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public java.lang.Object getUri() {
                    return this.$uri;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("type", om.valueToTree(this.getType()));
                    if (this.getIntegrationHttpMethod() != null) {
                        obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                    }
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree(this.getOptions()));
                    }
                    if (this.getUri() != null) {
                        obj.set("uri", om.valueToTree(this.getUri()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.IntegrationProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * Specifies an API method integration type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.jsiiGet("type", software.amazon.awscdk.services.apigateway.IntegrationType.class);
        }

        /**
         * The integration's HTTP method type. Required unless you use a MOCK integration.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getIntegrationHttpMethod() {
            return this.jsiiGet("integrationHttpMethod", java.lang.String.class);
        }

        /**
         * Integration options.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
        }

        /**
         * The Uniform Resource Identifier (URI) for the integration.
         * 
         * - If you specify HTTP for the `type` property, specify the API endpoint URL.
         * - If you specify MOCK for the `type` property, don't specify this property.
         * - If you specify AWS for the `type` property, specify an AWS service that
         *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
         *    For example, a Lambda function URI follows this form:
         *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
         *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
         * 
         * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Object getUri() {
            return this.jsiiGet("uri", java.lang.Object.class);
        }
    }
}
