package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-08T23:41:01.214Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ModelProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ModelOptions {
    /**
     * The rest API that this model is part of.
     * 
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IRestApi getRestApi();

    /**
     * @return a {@link Builder} of {@link ModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link ModelProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.IRestApi _restApi;
        private software.amazon.awscdk.services.apigateway.JsonSchema _schema;
        @javax.annotation.Nullable
        private java.lang.String _contentType;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _modelName;

        /**
         * Sets the value of RestApi
         * @param value The rest API that this model is part of.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withRestApi(final software.amazon.awscdk.services.apigateway.IRestApi value) {
            this._restApi = java.util.Objects.requireNonNull(value, "restApi is required");
            return this;
        }
        /**
         * Sets the value of Schema
         * @param value The schema to use to transform data to one or more output formats. Specify null ({}) if you don't want to specify a schema.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withSchema(final software.amazon.awscdk.services.apigateway.JsonSchema value) {
            this._schema = java.util.Objects.requireNonNull(value, "schema is required");
            return this;
        }
        /**
         * Sets the value of ContentType
         * @param value The content type for the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withContentType(@javax.annotation.Nullable final java.lang.String value) {
            this._contentType = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description that identifies this model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of ModelName
         * @param value A name for the model.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withModelName(@javax.annotation.Nullable final java.lang.String value) {
            this._modelName = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ModelProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public ModelProps build() {
            return new ModelProps() {
                private final software.amazon.awscdk.services.apigateway.IRestApi $restApi = java.util.Objects.requireNonNull(_restApi, "restApi is required");
                private final software.amazon.awscdk.services.apigateway.JsonSchema $schema = java.util.Objects.requireNonNull(_schema, "schema is required");
                @javax.annotation.Nullable
                private final java.lang.String $contentType = _contentType;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $modelName = _modelName;

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
                    return this.$restApi;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.JsonSchema getSchema() {
                    return this.$schema;
                }

                @Override
                public java.lang.String getContentType() {
                    return this.$contentType;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getModelName() {
                    return this.$modelName;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("restApi", om.valueToTree(this.getRestApi()));
                    obj.set("schema", om.valueToTree(this.getSchema()));
                    if (this.getContentType() != null) {
                        obj.set("contentType", om.valueToTree(this.getContentType()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getModelName() != null) {
                        obj.set("modelName", om.valueToTree(this.getModelName()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.ModelProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The rest API that this model is part of.
         * 
         * The reason we need the RestApi object itself and not just the ID is because the model
         * is being tracked by the top-level RestApi object for the purpose of calculating it's
         * hash to determine the ID of the deployment. This allows us to automatically update
         * the deployment when the model of the REST API changes.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.IRestApi getRestApi() {
            return this.jsiiGet("restApi", software.amazon.awscdk.services.apigateway.IRestApi.class);
        }

        /**
         * The schema to use to transform data to one or more output formats. Specify null ({}) if you don't want to specify a schema.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.JsonSchema getSchema() {
            return this.jsiiGet("schema", software.amazon.awscdk.services.apigateway.JsonSchema.class);
        }

        /**
         * The content type for the model.
         * 
         * You can also force a
         * content type in the request or response model mapping.
         * 
         * Default: -
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getContentType() {
            return this.jsiiGet("contentType", java.lang.String.class);
        }

        /**
         * A description that identifies this model.
         * 
         * Default: None
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * A name for the model.
         * 
         * Important
         *   If you specify a name, you cannot perform updates that
         *   require replacement of this resource. You can perform
         *   updates that require no or some interruption. If you
         *   must replace the resource, specify a new name.
         * 
         * Default: <auto> If you don't specify a name,
         * AWS CloudFormation generates a unique physical ID and
         * uses that ID for the model name. For more information,
         * see Name Type.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getModelName() {
            return this.jsiiGet("modelName", java.lang.String.class);
        }
    }
}
