/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.EndpointType;
import software.amazon.awscdk.services.certificatemanager.ICertificate;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface DomainNameOptions
extends JsiiSerializable {
    public ICertificate getCertificate();

    public String getDomainName();

    public EndpointType getEndpointType();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private ICertificate _certificate;
        private String _domainName;
        @Nullable
        private EndpointType _endpointType;

        public Builder withCertificate(ICertificate value) {
            this._certificate = Objects.requireNonNull(value, "certificate is required");
            return this;
        }

        public Builder withDomainName(String value) {
            this._domainName = Objects.requireNonNull(value, "domainName is required");
            return this;
        }

        public Builder withEndpointType(@Nullable EndpointType value) {
            this._endpointType = value;
            return this;
        }

        public DomainNameOptions build() {
            return new DomainNameOptions(){
                private final ICertificate $certificate;
                private final String $domainName;
                @Nullable
                private final EndpointType $endpointType;
                {
                    this.$certificate = Objects.requireNonNull(_certificate, "certificate is required");
                    this.$domainName = Objects.requireNonNull(_domainName, "domainName is required");
                    this.$endpointType = _endpointType;
                }

                @Override
                public ICertificate getCertificate() {
                    return this.$certificate;
                }

                @Override
                public String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public EndpointType getEndpointType() {
                    return this.$endpointType;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("certificate", om.valueToTree((Object)this.getCertificate()));
                    obj.set("domainName", om.valueToTree((Object)this.getDomainName()));
                    if (this.getEndpointType() != null) {
                        obj.set("endpointType", om.valueToTree((Object)this.getEndpointType()));
                    }
                    return obj;
                }
            };
        }
    }
}

