/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IntegrationOptions;
import software.amazon.awscdk.services.apigateway.IntegrationType;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface IntegrationProps
extends JsiiSerializable {
    public IntegrationType getType();

    public String getIntegrationHttpMethod();

    public IntegrationOptions getOptions();

    public Object getUri();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IntegrationType _type;
        @Nullable
        private String _integrationHttpMethod;
        @Nullable
        private IntegrationOptions _options;
        @Nullable
        private Object _uri;

        public Builder withType(IntegrationType value) {
            this._type = Objects.requireNonNull(value, "type is required");
            return this;
        }

        public Builder withIntegrationHttpMethod(@Nullable String value) {
            this._integrationHttpMethod = value;
            return this;
        }

        public Builder withOptions(@Nullable IntegrationOptions value) {
            this._options = value;
            return this;
        }

        public Builder withUri(@Nullable Object value) {
            this._uri = value;
            return this;
        }

        public IntegrationProps build() {
            return new IntegrationProps(){
                private final IntegrationType $type;
                @Nullable
                private final String $integrationHttpMethod;
                @Nullable
                private final IntegrationOptions $options;
                @Nullable
                private final Object $uri;
                {
                    this.$type = Objects.requireNonNull(_type, "type is required");
                    this.$integrationHttpMethod = _integrationHttpMethod;
                    this.$options = _options;
                    this.$uri = _uri;
                }

                @Override
                public IntegrationType getType() {
                    return this.$type;
                }

                @Override
                public String getIntegrationHttpMethod() {
                    return this.$integrationHttpMethod;
                }

                @Override
                public IntegrationOptions getOptions() {
                    return this.$options;
                }

                @Override
                public Object getUri() {
                    return this.$uri;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("type", om.valueToTree((Object)this.getType()));
                    if (this.getIntegrationHttpMethod() != null) {
                        obj.set("integrationHttpMethod", om.valueToTree((Object)this.getIntegrationHttpMethod()));
                    }
                    if (this.getOptions() != null) {
                        obj.set("options", om.valueToTree((Object)this.getOptions()));
                    }
                    if (this.getUri() != null) {
                        obj.set("uri", om.valueToTree(this.getUri()));
                    }
                    return obj;
                }
            };
        }
    }
}

