/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.services.apigateway.IRestApi;
import software.amazon.awscdk.services.apigateway.RequestValidatorOptions;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface RequestValidatorProps
extends JsiiSerializable,
RequestValidatorOptions {
    public IRestApi getRestApi();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private IRestApi _restApi;
        @Nullable
        private String _requestValidatorName;
        @Nullable
        private Boolean _validateRequestBody;
        @Nullable
        private Boolean _validateRequestParameters;

        public Builder withRestApi(IRestApi value) {
            this._restApi = Objects.requireNonNull(value, "restApi is required");
            return this;
        }

        public Builder withRequestValidatorName(@Nullable String value) {
            this._requestValidatorName = value;
            return this;
        }

        public Builder withValidateRequestBody(@Nullable Boolean value) {
            this._validateRequestBody = value;
            return this;
        }

        public Builder withValidateRequestParameters(@Nullable Boolean value) {
            this._validateRequestParameters = value;
            return this;
        }

        public RequestValidatorProps build() {
            return new RequestValidatorProps(){
                private final IRestApi $restApi;
                @Nullable
                private final String $requestValidatorName;
                @Nullable
                private final Boolean $validateRequestBody;
                @Nullable
                private final Boolean $validateRequestParameters;
                {
                    this.$restApi = Objects.requireNonNull(_restApi, "restApi is required");
                    this.$requestValidatorName = _requestValidatorName;
                    this.$validateRequestBody = _validateRequestBody;
                    this.$validateRequestParameters = _validateRequestParameters;
                }

                @Override
                public IRestApi getRestApi() {
                    return this.$restApi;
                }

                @Override
                public String getRequestValidatorName() {
                    return this.$requestValidatorName;
                }

                @Override
                public Boolean getValidateRequestBody() {
                    return this.$validateRequestBody;
                }

                @Override
                public Boolean getValidateRequestParameters() {
                    return this.$validateRequestParameters;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("restApi", om.valueToTree((Object)this.getRestApi()));
                    if (this.getRequestValidatorName() != null) {
                        obj.set("requestValidatorName", om.valueToTree((Object)this.getRequestValidatorName()));
                    }
                    if (this.getValidateRequestBody() != null) {
                        obj.set("validateRequestBody", om.valueToTree((Object)this.getValidateRequestBody()));
                    }
                    if (this.getValidateRequestParameters() != null) {
                        obj.set("validateRequestParameters", om.valueToTree((Object)this.getValidateRequestParameters()));
                    }
                    return obj;
                }
            };
        }
    }
}

