package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.DeploymentResource")
public class DeploymentResource extends software.amazon.awscdk.Resource {
    protected DeploymentResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.DeploymentResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::Deployment``.
     * @param parent the ``cdk.Construct`` this ``DeploymentResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``DeploymentResource``
     */
    public DeploymentResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.DeploymentResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html
     */
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final java.lang.Number value);
        /**
         * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         */
        void setCachingEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
         */
        void setCachingEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         */
        java.lang.Object getHttpMethod();
        /**
         * ``DeploymentResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         */
        void setHttpMethod(final java.lang.String value);
        /**
         * ``DeploymentResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
         */
        void setHttpMethod(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         */
        java.lang.Object getLoggingLevel();
        /**
         * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         */
        void setLoggingLevel(final java.lang.String value);
        /**
         * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
         */
        void setLoggingLevel(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         */
        java.lang.Object getResourcePath();
        /**
         * ``DeploymentResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         */
        void setResourcePath(final java.lang.String value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
         */
        void setResourcePath(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final java.lang.Number value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final java.lang.Number value);
        /**
         * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link MethodSettingProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final java.lang.Boolean value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final java.lang.Number value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            public Builder withCachingEnabled(final java.lang.Boolean value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            public Builder withCachingEnabled(final software.amazon.awscdk.Token value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            public Builder withDataTraceEnabled(final java.lang.Boolean value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            public Builder withDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            public Builder withHttpMethod(final java.lang.String value) {
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            public Builder withHttpMethod(final software.amazon.awscdk.Token value) {
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            public Builder withLoggingLevel(final java.lang.String value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            public Builder withLoggingLevel(final software.amazon.awscdk.Token value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            public Builder withMetricsEnabled(final java.lang.Boolean value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            public Builder withMetricsEnabled(final software.amazon.awscdk.Token value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            public Builder withResourcePath(final java.lang.String value) {
                this.instance._resourcePath = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            public Builder withResourcePath(final software.amazon.awscdk.Token value) {
                this.instance._resourcePath = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final java.lang.Number value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final java.lang.Number value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            public MethodSettingProperty build() {
                MethodSettingProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MethodSettingProperty}.
         */
        final class Jsii$Pojo implements MethodSettingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cacheDataEncrypted;

            public java.lang.Object getCacheDataEncrypted() {
                return this._cacheDataEncrypted;
            }
            public void setCacheDataEncrypted(final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
            }
            public void setCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
            }

            protected java.lang.Object _cacheTtlInSeconds;

            public java.lang.Object getCacheTtlInSeconds() {
                return this._cacheTtlInSeconds;
            }
            public void setCacheTtlInSeconds(final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
            }
            public void setCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
            }

            protected java.lang.Object _cachingEnabled;

            public java.lang.Object getCachingEnabled() {
                return this._cachingEnabled;
            }
            public void setCachingEnabled(final java.lang.Boolean value) {
                this._cachingEnabled = value;
            }
            public void setCachingEnabled(final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
            }

            protected java.lang.Object _dataTraceEnabled;

            public java.lang.Object getDataTraceEnabled() {
                return this._dataTraceEnabled;
            }
            public void setDataTraceEnabled(final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
            }
            public void setDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
            }

            protected java.lang.Object _httpMethod;

            public java.lang.Object getHttpMethod() {
                return this._httpMethod;
            }
            public void setHttpMethod(final java.lang.String value) {
                this._httpMethod = value;
            }
            public void setHttpMethod(final software.amazon.awscdk.Token value) {
                this._httpMethod = value;
            }

            protected java.lang.Object _loggingLevel;

            public java.lang.Object getLoggingLevel() {
                return this._loggingLevel;
            }
            public void setLoggingLevel(final java.lang.String value) {
                this._loggingLevel = value;
            }
            public void setLoggingLevel(final software.amazon.awscdk.Token value) {
                this._loggingLevel = value;
            }

            protected java.lang.Object _metricsEnabled;

            public java.lang.Object getMetricsEnabled() {
                return this._metricsEnabled;
            }
            public void setMetricsEnabled(final java.lang.Boolean value) {
                this._metricsEnabled = value;
            }
            public void setMetricsEnabled(final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
            }

            protected java.lang.Object _resourcePath;

            public java.lang.Object getResourcePath() {
                return this._resourcePath;
            }
            public void setResourcePath(final java.lang.String value) {
                this._resourcePath = value;
            }
            public void setResourcePath(final software.amazon.awscdk.Token value) {
                this._resourcePath = value;
            }

            protected java.lang.Object _throttlingBurstLimit;

            public java.lang.Object getThrottlingBurstLimit() {
                return this._throttlingBurstLimit;
            }
            public void setThrottlingBurstLimit(final java.lang.Number value) {
                this._throttlingBurstLimit = value;
            }
            public void setThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
            }

            protected java.lang.Object _throttlingRateLimit;

            public java.lang.Object getThrottlingRateLimit() {
                return this._throttlingRateLimit;
            }
            public void setThrottlingRateLimit(final java.lang.Number value) {
                this._throttlingRateLimit = value;
            }
            public void setThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.DeploymentResource.MethodSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            @javax.annotation.Nullable
            public java.lang.Object getHttpMethod() {
                return this.jsiiGet("httpMethod", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            public void setHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpMethod", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-httpmethod
             */
            public void setHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpMethod", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            @javax.annotation.Nullable
            public java.lang.Object getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourcePath() {
                return this.jsiiGet("resourcePath", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            public void setResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourcePath", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-resourcepath
             */
            public void setResourcePath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourcePath", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
            /**
             * ``DeploymentResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription-methodsetting.html#cfn-apigateway-deployment-stagedescription-methodsetting-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html
     */
    public static interface StageDescriptionProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         */
        java.lang.Object getCacheClusterEnabled();
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         */
        void setCacheClusterEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
         */
        void setCacheClusterEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         */
        java.lang.Object getCacheClusterSize();
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         */
        void setCacheClusterSize(final java.lang.String value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
         */
        void setCacheClusterSize(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         */
        void setCacheDataEncrypted(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
         */
        void setCacheDataEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         */
        void setCacheTtlInSeconds(final java.lang.Number value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
         */
        void setCacheTtlInSeconds(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         */
        void setCachingEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
         */
        void setCachingEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         */
        java.lang.Object getClientCertificateId();
        /**
         * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         */
        void setClientCertificateId(final java.lang.String value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
         */
        void setClientCertificateId(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         */
        void setDataTraceEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
         */
        void setDataTraceEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         */
        java.lang.Object getDescription();
        /**
         * ``DeploymentResource.StageDescriptionProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         */
        void setDescription(final java.lang.String value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
         */
        void setDescription(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         */
        java.lang.Object getDocumentationVersion();
        /**
         * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         */
        void setDocumentationVersion(final java.lang.String value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
         */
        void setDocumentationVersion(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         */
        java.lang.Object getLoggingLevel();
        /**
         * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         */
        void setLoggingLevel(final java.lang.String value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
         */
        void setLoggingLevel(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         */
        java.lang.Object getMethodSettings();
        /**
         * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         */
        void setMethodSettings(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
         */
        void setMethodSettings(final java.util.List<java.lang.Object> value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         */
        void setMetricsEnabled(final java.lang.Boolean value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
         */
        void setMetricsEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final java.lang.Number value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         */
        void setThrottlingRateLimit(final java.lang.Number value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
         */
        void setThrottlingRateLimit(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.Variables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         */
        java.lang.Object getVariables();
        /**
         * ``DeploymentResource.StageDescriptionProperty.Variables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         */
        void setVariables(final software.amazon.awscdk.Token value);
        /**
         * ``DeploymentResource.StageDescriptionProperty.Variables``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
         */
        void setVariables(final java.util.Map<java.lang.String, java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link StageDescriptionProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            public Builder withCacheClusterEnabled(final java.lang.Boolean value) {
                this.instance._cacheClusterEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            public Builder withCacheClusterEnabled(final software.amazon.awscdk.Token value) {
                this.instance._cacheClusterEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            public Builder withCacheClusterSize(final java.lang.String value) {
                this.instance._cacheClusterSize = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            public Builder withCacheClusterSize(final software.amazon.awscdk.Token value) {
                this.instance._cacheClusterSize = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final java.lang.Boolean value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final java.lang.Number value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            public Builder withCachingEnabled(final java.lang.Boolean value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            public Builder withCachingEnabled(final software.amazon.awscdk.Token value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            public Builder withClientCertificateId(final java.lang.String value) {
                this.instance._clientCertificateId = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            public Builder withClientCertificateId(final software.amazon.awscdk.Token value) {
                this.instance._clientCertificateId = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            public Builder withDataTraceEnabled(final java.lang.Boolean value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            public Builder withDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            public Builder withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            public Builder withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            public Builder withDocumentationVersion(final java.lang.String value) {
                this.instance._documentationVersion = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            public Builder withDocumentationVersion(final software.amazon.awscdk.Token value) {
                this.instance._documentationVersion = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            public Builder withLoggingLevel(final java.lang.String value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            public Builder withLoggingLevel(final software.amazon.awscdk.Token value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            public Builder withMethodSettings(final software.amazon.awscdk.Token value) {
                this.instance._methodSettings = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            public Builder withMethodSettings(final java.util.List<java.lang.Object> value) {
                this.instance._methodSettings = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            public Builder withMetricsEnabled(final java.lang.Boolean value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            public Builder withMetricsEnabled(final software.amazon.awscdk.Token value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final java.lang.Number value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final java.lang.Number value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Variables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            public Builder withVariables(final software.amazon.awscdk.Token value) {
                this.instance._variables = value;
                return this;
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Variables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            public Builder withVariables(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._variables = value;
                return this;
            }
            public StageDescriptionProperty build() {
                StageDescriptionProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link StageDescriptionProperty}.
         */
        final class Jsii$Pojo implements StageDescriptionProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cacheClusterEnabled;

            public java.lang.Object getCacheClusterEnabled() {
                return this._cacheClusterEnabled;
            }
            public void setCacheClusterEnabled(final java.lang.Boolean value) {
                this._cacheClusterEnabled = value;
            }
            public void setCacheClusterEnabled(final software.amazon.awscdk.Token value) {
                this._cacheClusterEnabled = value;
            }

            protected java.lang.Object _cacheClusterSize;

            public java.lang.Object getCacheClusterSize() {
                return this._cacheClusterSize;
            }
            public void setCacheClusterSize(final java.lang.String value) {
                this._cacheClusterSize = value;
            }
            public void setCacheClusterSize(final software.amazon.awscdk.Token value) {
                this._cacheClusterSize = value;
            }

            protected java.lang.Object _cacheDataEncrypted;

            public java.lang.Object getCacheDataEncrypted() {
                return this._cacheDataEncrypted;
            }
            public void setCacheDataEncrypted(final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
            }
            public void setCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
            }

            protected java.lang.Object _cacheTtlInSeconds;

            public java.lang.Object getCacheTtlInSeconds() {
                return this._cacheTtlInSeconds;
            }
            public void setCacheTtlInSeconds(final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
            }
            public void setCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
            }

            protected java.lang.Object _cachingEnabled;

            public java.lang.Object getCachingEnabled() {
                return this._cachingEnabled;
            }
            public void setCachingEnabled(final java.lang.Boolean value) {
                this._cachingEnabled = value;
            }
            public void setCachingEnabled(final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
            }

            protected java.lang.Object _clientCertificateId;

            public java.lang.Object getClientCertificateId() {
                return this._clientCertificateId;
            }
            public void setClientCertificateId(final java.lang.String value) {
                this._clientCertificateId = value;
            }
            public void setClientCertificateId(final software.amazon.awscdk.Token value) {
                this._clientCertificateId = value;
            }

            protected java.lang.Object _dataTraceEnabled;

            public java.lang.Object getDataTraceEnabled() {
                return this._dataTraceEnabled;
            }
            public void setDataTraceEnabled(final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
            }
            public void setDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
            }

            protected java.lang.Object _description;

            public java.lang.Object getDescription() {
                return this._description;
            }
            public void setDescription(final java.lang.String value) {
                this._description = value;
            }
            public void setDescription(final software.amazon.awscdk.Token value) {
                this._description = value;
            }

            protected java.lang.Object _documentationVersion;

            public java.lang.Object getDocumentationVersion() {
                return this._documentationVersion;
            }
            public void setDocumentationVersion(final java.lang.String value) {
                this._documentationVersion = value;
            }
            public void setDocumentationVersion(final software.amazon.awscdk.Token value) {
                this._documentationVersion = value;
            }

            protected java.lang.Object _loggingLevel;

            public java.lang.Object getLoggingLevel() {
                return this._loggingLevel;
            }
            public void setLoggingLevel(final java.lang.String value) {
                this._loggingLevel = value;
            }
            public void setLoggingLevel(final software.amazon.awscdk.Token value) {
                this._loggingLevel = value;
            }

            protected java.lang.Object _methodSettings;

            public java.lang.Object getMethodSettings() {
                return this._methodSettings;
            }
            public void setMethodSettings(final software.amazon.awscdk.Token value) {
                this._methodSettings = value;
            }
            public void setMethodSettings(final java.util.List<java.lang.Object> value) {
                this._methodSettings = value;
            }

            protected java.lang.Object _metricsEnabled;

            public java.lang.Object getMetricsEnabled() {
                return this._metricsEnabled;
            }
            public void setMetricsEnabled(final java.lang.Boolean value) {
                this._metricsEnabled = value;
            }
            public void setMetricsEnabled(final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
            }

            protected java.lang.Object _throttlingBurstLimit;

            public java.lang.Object getThrottlingBurstLimit() {
                return this._throttlingBurstLimit;
            }
            public void setThrottlingBurstLimit(final java.lang.Number value) {
                this._throttlingBurstLimit = value;
            }
            public void setThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
            }

            protected java.lang.Object _throttlingRateLimit;

            public java.lang.Object getThrottlingRateLimit() {
                return this._throttlingRateLimit;
            }
            public void setThrottlingRateLimit(final java.lang.Number value) {
                this._throttlingRateLimit = value;
            }
            public void setThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
            }

            protected java.lang.Object _variables;

            public java.lang.Object getVariables() {
                return this._variables;
            }
            public void setVariables(final software.amazon.awscdk.Token value) {
                this._variables = value;
            }
            public void setVariables(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._variables = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.DeploymentResource.StageDescriptionProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheClusterEnabled() {
                return this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            public void setCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cacheClusterEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclusterenabled
             */
            public void setCacheClusterEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheClusterEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheClusterSize() {
                return this.jsiiGet("cacheClusterSize", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            public void setCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cacheClusterSize", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheClusterSize``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cacheclustersize
             */
            public void setCacheClusterSize(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheClusterSize", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            @javax.annotation.Nullable
            public java.lang.Object getClientCertificateId() {
                return this.jsiiGet("clientCertificateId", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            public void setClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("clientCertificateId", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ClientCertificateId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-clientcertificateid
             */
            public void setClientCertificateId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("clientCertificateId", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            @javax.annotation.Nullable
            public java.lang.Object getDescription() {
                return this.jsiiGet("description", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-description
             */
            public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("description", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            @javax.annotation.Nullable
            public java.lang.Object getDocumentationVersion() {
                return this.jsiiGet("documentationVersion", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            public void setDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("documentationVersion", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-documentationversion
             */
            public void setDocumentationVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("documentationVersion", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            @javax.annotation.Nullable
            public java.lang.Object getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            @javax.annotation.Nullable
            public java.lang.Object getMethodSettings() {
                return this.jsiiGet("methodSettings", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            public void setMethodSettings(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("methodSettings", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MethodSettings``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-methodsettings
             */
            public void setMethodSettings(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("methodSettings", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Variables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            @javax.annotation.Nullable
            public java.lang.Object getVariables() {
                return this.jsiiGet("variables", java.lang.Object.class);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Variables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            public void setVariables(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("variables", value);
            }
            /**
             * ``DeploymentResource.StageDescriptionProperty.Variables``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-deployment-stagedescription.html#cfn-apigateway-deployment-stagedescription-variables
             */
            public void setVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("variables", value);
            }
        }
    }
}
