package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationpart.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.DocumentationPartResource")
public class DocumentationPartResource extends software.amazon.awscdk.Resource {
    protected DocumentationPartResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.DocumentationPartResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::DocumentationPart``.
     * @param parent the ``cdk.Construct`` this ``DocumentationPartResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``DocumentationPartResource``
     */
    public DocumentationPartResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.DocumentationPartResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html
     */
    public static interface LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``DocumentationPartResource.LocationProperty.Method``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
         */
        java.lang.Object getMethod();
        /**
         * ``DocumentationPartResource.LocationProperty.Method``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
         */
        void setMethod(final java.lang.String value);
        /**
         * ``DocumentationPartResource.LocationProperty.Method``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
         */
        void setMethod(final software.amazon.awscdk.Token value);
        /**
         * ``DocumentationPartResource.LocationProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
         */
        java.lang.Object getName();
        /**
         * ``DocumentationPartResource.LocationProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
         */
        void setName(final java.lang.String value);
        /**
         * ``DocumentationPartResource.LocationProperty.Name``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
         */
        void setName(final software.amazon.awscdk.Token value);
        /**
         * ``DocumentationPartResource.LocationProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
         */
        java.lang.Object getPath();
        /**
         * ``DocumentationPartResource.LocationProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
         */
        void setPath(final java.lang.String value);
        /**
         * ``DocumentationPartResource.LocationProperty.Path``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
         */
        void setPath(final software.amazon.awscdk.Token value);
        /**
         * ``DocumentationPartResource.LocationProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``DocumentationPartResource.LocationProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``DocumentationPartResource.LocationProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.Token value);
        /**
         * ``DocumentationPartResource.LocationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
         */
        java.lang.Object getType();
        /**
         * ``DocumentationPartResource.LocationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
         */
        void setType(final java.lang.String value);
        /**
         * ``DocumentationPartResource.LocationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
         */
        void setType(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link LocationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``DocumentationPartResource.LocationProperty.Method``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            public Builder withMethod(final java.lang.String value) {
                this.instance._method = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Method``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            public Builder withMethod(final software.amazon.awscdk.Token value) {
                this.instance._method = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            public Builder withName(final java.lang.String value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            public Builder withName(final software.amazon.awscdk.Token value) {
                this.instance._name = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            public Builder withPath(final java.lang.String value) {
                this.instance._path = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            public Builder withPath(final software.amazon.awscdk.Token value) {
                this.instance._path = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            public Builder withStatusCode(final java.lang.String value) {
                this.instance._statusCode = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            public Builder withStatusCode(final software.amazon.awscdk.Token value) {
                this.instance._statusCode = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            public LocationProperty build() {
                LocationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link LocationProperty}.
         */
        final class Jsii$Pojo implements LocationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _method;

            public java.lang.Object getMethod() {
                return this._method;
            }
            public void setMethod(final java.lang.String value) {
                this._method = value;
            }
            public void setMethod(final software.amazon.awscdk.Token value) {
                this._method = value;
            }

            protected java.lang.Object _name;

            public java.lang.Object getName() {
                return this._name;
            }
            public void setName(final java.lang.String value) {
                this._name = value;
            }
            public void setName(final software.amazon.awscdk.Token value) {
                this._name = value;
            }

            protected java.lang.Object _path;

            public java.lang.Object getPath() {
                return this._path;
            }
            public void setPath(final java.lang.String value) {
                this._path = value;
            }
            public void setPath(final software.amazon.awscdk.Token value) {
                this._path = value;
            }

            protected java.lang.Object _statusCode;

            public java.lang.Object getStatusCode() {
                return this._statusCode;
            }
            public void setStatusCode(final java.lang.String value) {
                this._statusCode = value;
            }
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this._statusCode = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.DocumentationPartResource.LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Method``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            @javax.annotation.Nullable
            public java.lang.Object getMethod() {
                return this.jsiiGet("method", java.lang.Object.class);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Method``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            public void setMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("method", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Method``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-method
             */
            public void setMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("method", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            @javax.annotation.Nullable
            public java.lang.Object getName() {
                return this.jsiiGet("name", java.lang.Object.class);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            public void setName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Name``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-name
             */
            public void setName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("name", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            @javax.annotation.Nullable
            public java.lang.Object getPath() {
                return this.jsiiGet("path", java.lang.Object.class);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            public void setPath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("path", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Path``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-path
             */
            public void setPath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("path", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            @javax.annotation.Nullable
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            public void setStatusCode(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("statusCode", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-statuscode
             */
            public void setStatusCode(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("statusCode", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``DocumentationPartResource.LocationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-documentationpart-location.html#cfn-apigateway-documentationpart-location-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
        }
    }
}
