package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-apikey.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.ApiKeyResource")
public class ApiKeyResource extends software.amazon.awscdk.Resource {
    protected ApiKeyResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::ApiKey``.
     * @param parent the ``cdk.Construct`` this ``ApiKeyResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``ApiKeyResource``
     */
    public ApiKeyResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ApiGateway::ApiKey``.
     * @param parent the ``cdk.Construct`` this ``ApiKeyResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public ApiKeyResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html
     */
    public static interface StageKeyProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        java.lang.Object getRestApiId();
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        void setRestApiId(final java.lang.String value);
        /**
         * ``ApiKeyResource.StageKeyProperty.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
         */
        void setRestApiId(final software.amazon.awscdk.Token value);
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        java.lang.Object getStageName();
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        void setStageName(final java.lang.String value);
        /**
         * ``ApiKeyResource.StageKeyProperty.StageName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
         */
        void setStageName(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link StageKeyProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            public Builder withRestApiId(final java.lang.String value) {
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            public Builder withRestApiId(final software.amazon.awscdk.Token value) {
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            public Builder withStageName(final java.lang.String value) {
                this.instance._stageName = value;
                return this;
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            public Builder withStageName(final software.amazon.awscdk.Token value) {
                this.instance._stageName = value;
                return this;
            }
            public StageKeyProperty build() {
                StageKeyProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link StageKeyProperty}.
         */
        final class Jsii$Pojo implements StageKeyProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _restApiId;

            public java.lang.Object getRestApiId() {
                return this._restApiId;
            }
            public void setRestApiId(final java.lang.String value) {
                this._restApiId = value;
            }
            public void setRestApiId(final software.amazon.awscdk.Token value) {
                this._restApiId = value;
            }

            protected java.lang.Object _stageName;

            public java.lang.Object getStageName() {
                return this._stageName;
            }
            public void setStageName(final java.lang.String value) {
                this._stageName = value;
            }
            public void setStageName(final software.amazon.awscdk.Token value) {
                this._stageName = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.ApiKeyResource.StageKeyProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            @javax.annotation.Nullable
            public java.lang.Object getRestApiId() {
                return this.jsiiGet("restApiId", java.lang.Object.class);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            public void setRestApiId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("restApiId", value);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-restapiid
             */
            public void setRestApiId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("restApiId", value);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            @javax.annotation.Nullable
            public java.lang.Object getStageName() {
                return this.jsiiGet("stageName", java.lang.Object.class);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            public void setStageName(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("stageName", value);
            }
            /**
             * ``ApiKeyResource.StageKeyProperty.StageName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-apikey-stagekey.html#cfn-apigateway-apikey-stagekey-stagename
             */
            public void setStageName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("stageName", value);
            }
        }
    }
}
