package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html
 */
public interface DocumentationVersionResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
     */
    java.lang.Object getDocumentationVersion();
    /**
     * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
     */
    void setDocumentationVersion(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
     */
    void setDocumentationVersion(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
     */
    java.lang.Object getRestApiId();
    /**
     * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
     */
    void setRestApiId(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
     */
    void setRestApiId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::DocumentationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
     */
    java.lang.Object getDescription();
    /**
     * ``AWS::ApiGateway::DocumentationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
     */
    void setDescription(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::DocumentationVersion.Description``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
     */
    void setDescription(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link DocumentationVersionResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
         */
        public RestApiIdStep withDocumentationVersion(final java.lang.String value) {
            return new FullBuilder().withDocumentationVersion(value);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
         */
        public RestApiIdStep withDocumentationVersion(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withDocumentationVersion(value);
        }

        public interface RestApiIdStep {
            /**
             * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
             */
            Build withRestApiId(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
             */
            Build withRestApiId(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link DocumentationVersionResourceProps} object, initialized with the values set on this builder.
             */
            DocumentationVersionResourceProps build();
            /**
             * ``AWS::ApiGateway::DocumentationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
             */
            Build withDescription(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::DocumentationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
             */
            Build withDescription(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements RestApiIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
             */
            public RestApiIdStep withDocumentationVersion(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "DocumentationVersionResourceProps#documentationVersion is required");
                this.instance._documentationVersion = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
             */
            public RestApiIdStep withDocumentationVersion(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "DocumentationVersionResourceProps#documentationVersion is required");
                this.instance._documentationVersion = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
             */
            public Build withRestApiId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "DocumentationVersionResourceProps#restApiId is required");
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
             */
            public Build withRestApiId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "DocumentationVersionResourceProps#restApiId is required");
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::DocumentationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
             */
            public Build withDescription(final java.lang.String value) {
                this.instance._description = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::DocumentationVersion.Description``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
             */
            public Build withDescription(final software.amazon.awscdk.Token value) {
                this.instance._description = value;
                return this;
            }
            public DocumentationVersionResourceProps build() {
                DocumentationVersionResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link DocumentationVersionResourceProps}.
     */
    final class Jsii$Pojo implements DocumentationVersionResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _documentationVersion;

        public java.lang.Object getDocumentationVersion() {
            return this._documentationVersion;
        }
        public void setDocumentationVersion(final java.lang.String value) {
            this._documentationVersion = value;
        }
        public void setDocumentationVersion(final software.amazon.awscdk.Token value) {
            this._documentationVersion = value;
        }

        protected java.lang.Object _restApiId;

        public java.lang.Object getRestApiId() {
            return this._restApiId;
        }
        public void setRestApiId(final java.lang.String value) {
            this._restApiId = value;
        }
        public void setRestApiId(final software.amazon.awscdk.Token value) {
            this._restApiId = value;
        }

        protected java.lang.Object _description;

        public java.lang.Object getDescription() {
            return this._description;
        }
        public void setDescription(final java.lang.String value) {
            this._description = value;
        }
        public void setDescription(final software.amazon.awscdk.Token value) {
            this._description = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.DocumentationVersionResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
         */
        public java.lang.Object getDocumentationVersion() {
            return this.jsiiGet("documentationVersion", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
         */
        public void setDocumentationVersion(final java.lang.String value) {
            this.jsiiSet("documentationVersion", java.util.Objects.requireNonNull(value, "documentationVersion is required"));
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.DocumentationVersion``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-documentationversion
         */
        public void setDocumentationVersion(final software.amazon.awscdk.Token value) {
            this.jsiiSet("documentationVersion", java.util.Objects.requireNonNull(value, "documentationVersion is required"));
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
         */
        public java.lang.Object getRestApiId() {
            return this.jsiiGet("restApiId", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
         */
        public void setRestApiId(final java.lang.String value) {
            this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-restapiid
         */
        public void setRestApiId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
         */
        @javax.annotation.Nullable
        public java.lang.Object getDescription() {
            return this.jsiiGet("description", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
         */
        public void setDescription(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("description", value);
        }
        /**
         * ``AWS::ApiGateway::DocumentationVersion.Description``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-documentationversion.html#cfn-apigateway-documentationversion-description
         */
        public void setDescription(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("description", value);
        }
    }
}
