package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.MethodResource")
public class MethodResource extends software.amazon.awscdk.Resource {
    protected MethodResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::Method``.
     * @param parent the ``cdk.Construct`` this ``MethodResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``MethodResource``
     */
    public MethodResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.MethodResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     */
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        java.lang.Object getCacheKeyParameters();
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        void setCacheKeyParameters(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        void setCacheKeyParameters(final java.util.List<java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        java.lang.Object getCacheNamespace();
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        void setCacheNamespace(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        void setCacheNamespace(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        java.lang.Object getContentHandling();
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        void setContentHandling(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        void setContentHandling(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        java.lang.Object getCredentials();
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        void setCredentials(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        void setCredentials(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        java.lang.Object getIntegrationHttpMethod();
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        void setIntegrationHttpMethod(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        void setIntegrationHttpMethod(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        java.lang.Object getIntegrationResponses();
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        void setIntegrationResponses(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        void setIntegrationResponses(final java.util.List<java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        java.lang.Object getPassthroughBehavior();
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        void setPassthroughBehavior(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        void setPassthroughBehavior(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        java.lang.Object getRequestParameters();
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        void setRequestParameters(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        java.lang.Object getRequestTemplates();
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        void setRequestTemplates(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        void setRequestTemplates(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        java.lang.Object getType();
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        void setType(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        void setType(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        java.lang.Object getUri();
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        void setUri(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        void setUri(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link IntegrationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            public Builder withCacheKeyParameters(final software.amazon.awscdk.Token value) {
                this.instance._cacheKeyParameters = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            public Builder withCacheKeyParameters(final java.util.List<java.lang.Object> value) {
                this.instance._cacheKeyParameters = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            public Builder withCacheNamespace(final java.lang.String value) {
                this.instance._cacheNamespace = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            public Builder withCacheNamespace(final software.amazon.awscdk.Token value) {
                this.instance._cacheNamespace = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            public Builder withContentHandling(final java.lang.String value) {
                this.instance._contentHandling = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            public Builder withContentHandling(final software.amazon.awscdk.Token value) {
                this.instance._contentHandling = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            public Builder withCredentials(final java.lang.String value) {
                this.instance._credentials = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            public Builder withCredentials(final software.amazon.awscdk.Token value) {
                this.instance._credentials = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            public Builder withIntegrationHttpMethod(final java.lang.String value) {
                this.instance._integrationHttpMethod = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            public Builder withIntegrationHttpMethod(final software.amazon.awscdk.Token value) {
                this.instance._integrationHttpMethod = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            public Builder withIntegrationResponses(final software.amazon.awscdk.Token value) {
                this.instance._integrationResponses = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            public Builder withIntegrationResponses(final java.util.List<java.lang.Object> value) {
                this.instance._integrationResponses = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            public Builder withPassthroughBehavior(final java.lang.String value) {
                this.instance._passthroughBehavior = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            public Builder withPassthroughBehavior(final software.amazon.awscdk.Token value) {
                this.instance._passthroughBehavior = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            public Builder withRequestParameters(final software.amazon.awscdk.Token value) {
                this.instance._requestParameters = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            public Builder withRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._requestParameters = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            public Builder withRequestTemplates(final software.amazon.awscdk.Token value) {
                this.instance._requestTemplates = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            public Builder withRequestTemplates(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._requestTemplates = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            public Builder withType(final java.lang.String value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            public Builder withType(final software.amazon.awscdk.Token value) {
                this.instance._type = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            public Builder withUri(final java.lang.String value) {
                this.instance._uri = value;
                return this;
            }
            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            public Builder withUri(final software.amazon.awscdk.Token value) {
                this.instance._uri = value;
                return this;
            }
            public IntegrationProperty build() {
                IntegrationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IntegrationProperty}.
         */
        final class Jsii$Pojo implements IntegrationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cacheKeyParameters;

            public java.lang.Object getCacheKeyParameters() {
                return this._cacheKeyParameters;
            }
            public void setCacheKeyParameters(final software.amazon.awscdk.Token value) {
                this._cacheKeyParameters = value;
            }
            public void setCacheKeyParameters(final java.util.List<java.lang.Object> value) {
                this._cacheKeyParameters = value;
            }

            protected java.lang.Object _cacheNamespace;

            public java.lang.Object getCacheNamespace() {
                return this._cacheNamespace;
            }
            public void setCacheNamespace(final java.lang.String value) {
                this._cacheNamespace = value;
            }
            public void setCacheNamespace(final software.amazon.awscdk.Token value) {
                this._cacheNamespace = value;
            }

            protected java.lang.Object _contentHandling;

            public java.lang.Object getContentHandling() {
                return this._contentHandling;
            }
            public void setContentHandling(final java.lang.String value) {
                this._contentHandling = value;
            }
            public void setContentHandling(final software.amazon.awscdk.Token value) {
                this._contentHandling = value;
            }

            protected java.lang.Object _credentials;

            public java.lang.Object getCredentials() {
                return this._credentials;
            }
            public void setCredentials(final java.lang.String value) {
                this._credentials = value;
            }
            public void setCredentials(final software.amazon.awscdk.Token value) {
                this._credentials = value;
            }

            protected java.lang.Object _integrationHttpMethod;

            public java.lang.Object getIntegrationHttpMethod() {
                return this._integrationHttpMethod;
            }
            public void setIntegrationHttpMethod(final java.lang.String value) {
                this._integrationHttpMethod = value;
            }
            public void setIntegrationHttpMethod(final software.amazon.awscdk.Token value) {
                this._integrationHttpMethod = value;
            }

            protected java.lang.Object _integrationResponses;

            public java.lang.Object getIntegrationResponses() {
                return this._integrationResponses;
            }
            public void setIntegrationResponses(final software.amazon.awscdk.Token value) {
                this._integrationResponses = value;
            }
            public void setIntegrationResponses(final java.util.List<java.lang.Object> value) {
                this._integrationResponses = value;
            }

            protected java.lang.Object _passthroughBehavior;

            public java.lang.Object getPassthroughBehavior() {
                return this._passthroughBehavior;
            }
            public void setPassthroughBehavior(final java.lang.String value) {
                this._passthroughBehavior = value;
            }
            public void setPassthroughBehavior(final software.amazon.awscdk.Token value) {
                this._passthroughBehavior = value;
            }

            protected java.lang.Object _requestParameters;

            public java.lang.Object getRequestParameters() {
                return this._requestParameters;
            }
            public void setRequestParameters(final software.amazon.awscdk.Token value) {
                this._requestParameters = value;
            }
            public void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._requestParameters = value;
            }

            protected java.lang.Object _requestTemplates;

            public java.lang.Object getRequestTemplates() {
                return this._requestTemplates;
            }
            public void setRequestTemplates(final software.amazon.awscdk.Token value) {
                this._requestTemplates = value;
            }
            public void setRequestTemplates(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._requestTemplates = value;
            }

            protected java.lang.Object _type;

            public java.lang.Object getType() {
                return this._type;
            }
            public void setType(final java.lang.String value) {
                this._type = value;
            }
            public void setType(final software.amazon.awscdk.Token value) {
                this._type = value;
            }

            protected java.lang.Object _uri;

            public java.lang.Object getUri() {
                return this._uri;
            }
            public void setUri(final java.lang.String value) {
                this._uri = value;
            }
            public void setUri(final software.amazon.awscdk.Token value) {
                this._uri = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheKeyParameters() {
                return this.jsiiGet("cacheKeyParameters", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            public void setCacheKeyParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheKeyParameters", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            public void setCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("cacheKeyParameters", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheNamespace() {
                return this.jsiiGet("cacheNamespace", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            public void setCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cacheNamespace", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            public void setCacheNamespace(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheNamespace", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            @javax.annotation.Nullable
            public java.lang.Object getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("contentHandling", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("contentHandling", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            @javax.annotation.Nullable
            public java.lang.Object getCredentials() {
                return this.jsiiGet("credentials", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            public void setCredentials(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("credentials", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            public void setCredentials(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("credentials", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            @javax.annotation.Nullable
            public java.lang.Object getIntegrationHttpMethod() {
                return this.jsiiGet("integrationHttpMethod", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            public void setIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("integrationHttpMethod", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            public void setIntegrationHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("integrationHttpMethod", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            @javax.annotation.Nullable
            public java.lang.Object getIntegrationResponses() {
                return this.jsiiGet("integrationResponses", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            public void setIntegrationResponses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("integrationResponses", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            public void setIntegrationResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("integrationResponses", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            @javax.annotation.Nullable
            public java.lang.Object getPassthroughBehavior() {
                return this.jsiiGet("passthroughBehavior", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            public void setPassthroughBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("passthroughBehavior", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            public void setPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("passthroughBehavior", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getRequestParameters() {
                return this.jsiiGet("requestParameters", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            public void setRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("requestParameters", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("requestParameters", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            @javax.annotation.Nullable
            public java.lang.Object getRequestTemplates() {
                return this.jsiiGet("requestTemplates", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            public void setRequestTemplates(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("requestTemplates", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            public void setRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("requestTemplates", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("type", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            @javax.annotation.Nullable
            public java.lang.Object getUri() {
                return this.jsiiGet("uri", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            public void setUri(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("uri", value);
            }
            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            public void setUri(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("uri", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     */
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        java.lang.Object getContentHandling();
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        void setContentHandling(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        void setContentHandling(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        java.lang.Object getResponseParameters();
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        void setResponseParameters(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        java.lang.Object getResponseTemplates();
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        void setResponseTemplates(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        void setResponseTemplates(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        java.lang.Object getSelectionPattern();
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        void setSelectionPattern(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        void setSelectionPattern(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link IntegrationResponseProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            public Build withStatusCode(final java.lang.String value) {
                return new FullBuilder().withStatusCode(value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            public Build withStatusCode(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStatusCode(value);
            }

            public interface Build {
                /**
                 * @return a new {@link IntegrationResponseProperty} object, initialized with the values set on this builder.
                 */
                IntegrationResponseProperty build();
                /**
                 * ``MethodResource.IntegrationResponseProperty.ContentHandling``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
                 */
                Build withContentHandling(final java.lang.String value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.ContentHandling``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
                 */
                Build withContentHandling(final software.amazon.awscdk.Token value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
                 */
                Build withResponseParameters(final software.amazon.awscdk.Token value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
                 */
                Build withResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
                 */
                Build withResponseTemplates(final software.amazon.awscdk.Token value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
                 */
                Build withResponseTemplates(final java.util.Map<java.lang.String, java.lang.Object> value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
                 */
                Build withSelectionPattern(final java.lang.String value);
                /**
                 * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
                 */
                Build withSelectionPattern(final software.amazon.awscdk.Token value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``MethodResource.IntegrationResponseProperty.ContentHandling``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
                 */
                public Build withContentHandling(final java.lang.String value) {
                    this.instance._contentHandling = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.ContentHandling``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
                 */
                public Build withContentHandling(final software.amazon.awscdk.Token value) {
                    this.instance._contentHandling = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
                 */
                public Build withResponseParameters(final software.amazon.awscdk.Token value) {
                    this.instance._responseParameters = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
                 */
                public Build withResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.instance._responseParameters = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
                 */
                public Build withResponseTemplates(final software.amazon.awscdk.Token value) {
                    this.instance._responseTemplates = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
                 */
                public Build withResponseTemplates(final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.instance._responseTemplates = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
                 */
                public Build withSelectionPattern(final java.lang.String value) {
                    this.instance._selectionPattern = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
                 */
                public Build withSelectionPattern(final software.amazon.awscdk.Token value) {
                    this.instance._selectionPattern = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.StatusCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
                 */
                public Build withStatusCode(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "IntegrationResponseProperty#statusCode is required");
                    this.instance._statusCode = value;
                    return this;
                }
                /**
                 * ``MethodResource.IntegrationResponseProperty.StatusCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
                 */
                public Build withStatusCode(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "IntegrationResponseProperty#statusCode is required");
                    this.instance._statusCode = value;
                    return this;
                }
                public IntegrationResponseProperty build() {
                    IntegrationResponseProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link IntegrationResponseProperty}.
         */
        final class Jsii$Pojo implements IntegrationResponseProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _contentHandling;

            public java.lang.Object getContentHandling() {
                return this._contentHandling;
            }
            public void setContentHandling(final java.lang.String value) {
                this._contentHandling = value;
            }
            public void setContentHandling(final software.amazon.awscdk.Token value) {
                this._contentHandling = value;
            }

            protected java.lang.Object _responseParameters;

            public java.lang.Object getResponseParameters() {
                return this._responseParameters;
            }
            public void setResponseParameters(final software.amazon.awscdk.Token value) {
                this._responseParameters = value;
            }
            public void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseParameters = value;
            }

            protected java.lang.Object _responseTemplates;

            public java.lang.Object getResponseTemplates() {
                return this._responseTemplates;
            }
            public void setResponseTemplates(final software.amazon.awscdk.Token value) {
                this._responseTemplates = value;
            }
            public void setResponseTemplates(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseTemplates = value;
            }

            protected java.lang.Object _selectionPattern;

            public java.lang.Object getSelectionPattern() {
                return this._selectionPattern;
            }
            public void setSelectionPattern(final java.lang.String value) {
                this._selectionPattern = value;
            }
            public void setSelectionPattern(final software.amazon.awscdk.Token value) {
                this._selectionPattern = value;
            }

            protected java.lang.Object _statusCode;

            public java.lang.Object getStatusCode() {
                return this._statusCode;
            }
            public void setStatusCode(final java.lang.String value) {
                this._statusCode = value;
            }
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this._statusCode = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            @javax.annotation.Nullable
            public java.lang.Object getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("contentHandling", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("contentHandling", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("responseParameters", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseParameters", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            @javax.annotation.Nullable
            public java.lang.Object getResponseTemplates() {
                return this.jsiiGet("responseTemplates", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            public void setResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("responseTemplates", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            public void setResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseTemplates", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            @javax.annotation.Nullable
            public java.lang.Object getSelectionPattern() {
                return this.jsiiGet("selectionPattern", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            public void setSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("selectionPattern", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            public void setSelectionPattern(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("selectionPattern", value);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }
            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     */
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        java.lang.Object getResponseModels();
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        void setResponseModels(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        void setResponseModels(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        java.lang.Object getResponseParameters();
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        void setResponseParameters(final software.amazon.awscdk.Token value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }
        /**
         * A fluent step builder class for {@link MethodResponseProperty}.
         * The {@link Build#build()} method will be available once all required properties are fulfilled.
         */
        final class Builder {
            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            public Build withStatusCode(final java.lang.String value) {
                return new FullBuilder().withStatusCode(value);
            }
            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            public Build withStatusCode(final software.amazon.awscdk.Token value) {
                return new FullBuilder().withStatusCode(value);
            }

            public interface Build {
                /**
                 * @return a new {@link MethodResponseProperty} object, initialized with the values set on this builder.
                 */
                MethodResponseProperty build();
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseModels``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
                 */
                Build withResponseModels(final software.amazon.awscdk.Token value);
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseModels``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
                 */
                Build withResponseModels(final java.util.Map<java.lang.String, java.lang.Object> value);
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
                 */
                Build withResponseParameters(final software.amazon.awscdk.Token value);
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
                 */
                Build withResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
            }

            final class FullBuilder implements Build {

                private Jsii$Pojo instance = new Jsii$Pojo();

                /**
                 * ``MethodResource.MethodResponseProperty.ResponseModels``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
                 */
                public Build withResponseModels(final software.amazon.awscdk.Token value) {
                    this.instance._responseModels = value;
                    return this;
                }
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseModels``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
                 */
                public Build withResponseModels(final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.instance._responseModels = value;
                    return this;
                }
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
                 */
                public Build withResponseParameters(final software.amazon.awscdk.Token value) {
                    this.instance._responseParameters = value;
                    return this;
                }
                /**
                 * ``MethodResource.MethodResponseProperty.ResponseParameters``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
                 */
                public Build withResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                    this.instance._responseParameters = value;
                    return this;
                }
                /**
                 * ``MethodResource.MethodResponseProperty.StatusCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
                 */
                public Build withStatusCode(final java.lang.String value) {
                    java.util.Objects.requireNonNull(value, "MethodResponseProperty#statusCode is required");
                    this.instance._statusCode = value;
                    return this;
                }
                /**
                 * ``MethodResource.MethodResponseProperty.StatusCode``
                 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
                 */
                public Build withStatusCode(final software.amazon.awscdk.Token value) {
                    java.util.Objects.requireNonNull(value, "MethodResponseProperty#statusCode is required");
                    this.instance._statusCode = value;
                    return this;
                }
                public MethodResponseProperty build() {
                    MethodResponseProperty result = this.instance;
                    this.instance = new Jsii$Pojo();
                    return result;
                }
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MethodResponseProperty}.
         */
        final class Jsii$Pojo implements MethodResponseProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _responseModels;

            public java.lang.Object getResponseModels() {
                return this._responseModels;
            }
            public void setResponseModels(final software.amazon.awscdk.Token value) {
                this._responseModels = value;
            }
            public void setResponseModels(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseModels = value;
            }

            protected java.lang.Object _responseParameters;

            public java.lang.Object getResponseParameters() {
                return this._responseParameters;
            }
            public void setResponseParameters(final software.amazon.awscdk.Token value) {
                this._responseParameters = value;
            }
            public void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseParameters = value;
            }

            protected java.lang.Object _statusCode;

            public java.lang.Object getStatusCode() {
                return this._statusCode;
            }
            public void setStatusCode(final java.lang.String value) {
                this._statusCode = value;
            }
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this._statusCode = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.MethodResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            @javax.annotation.Nullable
            public java.lang.Object getResponseModels() {
                return this.jsiiGet("responseModels", java.lang.Object.class);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            public void setResponseModels(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("responseModels", value);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            public void setResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseModels", value);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("responseParameters", value);
            }
            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseParameters", value);
            }
            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }
            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }
            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            public void setStatusCode(final software.amazon.awscdk.Token value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }
        }
    }
}
