package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
public interface MethodResourceProps extends software.amazon.jsii.JsiiSerializable {
    /**
     * ``AWS::ApiGateway::Method.HttpMethod``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    java.lang.Object getHttpMethod();
    /**
     * ``AWS::ApiGateway::Method.HttpMethod``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    void setHttpMethod(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.HttpMethod``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    void setHttpMethod(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.ResourceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    java.lang.Object getResourceId();
    /**
     * ``AWS::ApiGateway::Method.ResourceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    void setResourceId(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.ResourceId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    void setResourceId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    java.lang.Object getRestApiId();
    /**
     * ``AWS::ApiGateway::Method.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    void setRestApiId(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.RestApiId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    void setRestApiId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.ApiKeyRequired``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    java.lang.Object getApiKeyRequired();
    /**
     * ``AWS::ApiGateway::Method.ApiKeyRequired``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    void setApiKeyRequired(final java.lang.Boolean value);
    /**
     * ``AWS::ApiGateway::Method.ApiKeyRequired``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    void setApiKeyRequired(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.AuthorizationType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    java.lang.Object getAuthorizationType();
    /**
     * ``AWS::ApiGateway::Method.AuthorizationType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    void setAuthorizationType(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.AuthorizationType``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    void setAuthorizationType(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.AuthorizerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    java.lang.Object getAuthorizerId();
    /**
     * ``AWS::ApiGateway::Method.AuthorizerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    void setAuthorizerId(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.AuthorizerId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    void setAuthorizerId(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.Integration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    java.lang.Object getIntegration();
    /**
     * ``AWS::ApiGateway::Method.Integration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    void setIntegration(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.Integration``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    void setIntegration(final software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty value);
    /**
     * ``AWS::ApiGateway::Method.MethodResponses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    java.lang.Object getMethodResponses();
    /**
     * ``AWS::ApiGateway::Method.MethodResponses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    void setMethodResponses(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.MethodResponses``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    void setMethodResponses(final java.util.List<java.lang.Object> value);
    /**
     * ``AWS::ApiGateway::Method.OperationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    java.lang.Object getOperationName();
    /**
     * ``AWS::ApiGateway::Method.OperationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    void setOperationName(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.OperationName``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    void setOperationName(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.RequestModels``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    java.lang.Object getRequestModels();
    /**
     * ``AWS::ApiGateway::Method.RequestModels``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    void setRequestModels(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.RequestModels``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    void setRequestModels(final java.util.Map<java.lang.String, java.lang.Object> value);
    /**
     * ``AWS::ApiGateway::Method.RequestParameters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    java.lang.Object getRequestParameters();
    /**
     * ``AWS::ApiGateway::Method.RequestParameters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    void setRequestParameters(final software.amazon.awscdk.Token value);
    /**
     * ``AWS::ApiGateway::Method.RequestParameters``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
    /**
     * ``AWS::ApiGateway::Method.RequestValidatorId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    java.lang.Object getRequestValidatorId();
    /**
     * ``AWS::ApiGateway::Method.RequestValidatorId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    void setRequestValidatorId(final java.lang.String value);
    /**
     * ``AWS::ApiGateway::Method.RequestValidatorId``
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    void setRequestValidatorId(final software.amazon.awscdk.Token value);

    // ==================================================================
    // Builder
    // ==================================================================

    static Builder builder() {
        return new Builder();
    }
    /**
     * A fluent step builder class for {@link MethodResourceProps}.
     * The {@link Build#build()} method will be available once all required properties are fulfilled.
     */
    final class Builder {
        /**
         * ``AWS::ApiGateway::Method.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        public ResourceIdStep withHttpMethod(final java.lang.String value) {
            return new FullBuilder().withHttpMethod(value);
        }
        /**
         * ``AWS::ApiGateway::Method.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        public ResourceIdStep withHttpMethod(final software.amazon.awscdk.Token value) {
            return new FullBuilder().withHttpMethod(value);
        }

        public interface ResourceIdStep {
            /**
             * ``AWS::ApiGateway::Method.ResourceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
             */
            RestApiIdStep withResourceId(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.ResourceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
             */
            RestApiIdStep withResourceId(final software.amazon.awscdk.Token value);
        }

        public interface RestApiIdStep {
            /**
             * ``AWS::ApiGateway::Method.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
             */
            Build withRestApiId(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
             */
            Build withRestApiId(final software.amazon.awscdk.Token value);
        }

        public interface Build {
            /**
             * @return a new {@link MethodResourceProps} object, initialized with the values set on this builder.
             */
            MethodResourceProps build();
            /**
             * ``AWS::ApiGateway::Method.ApiKeyRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
             */
            Build withApiKeyRequired(final java.lang.Boolean value);
            /**
             * ``AWS::ApiGateway::Method.ApiKeyRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
             */
            Build withApiKeyRequired(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.AuthorizationType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
             */
            Build withAuthorizationType(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.AuthorizationType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
             */
            Build withAuthorizationType(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.AuthorizerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
             */
            Build withAuthorizerId(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.AuthorizerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
             */
            Build withAuthorizerId(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.Integration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
             */
            Build withIntegration(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.Integration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
             */
            Build withIntegration(final software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty value);
            /**
             * ``AWS::ApiGateway::Method.MethodResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
             */
            Build withMethodResponses(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.MethodResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
             */
            Build withMethodResponses(final java.util.List<java.lang.Object> value);
            /**
             * ``AWS::ApiGateway::Method.OperationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
             */
            Build withOperationName(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.OperationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
             */
            Build withOperationName(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.RequestModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
             */
            Build withRequestModels(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.RequestModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
             */
            Build withRequestModels(final java.util.Map<java.lang.String, java.lang.Object> value);
            /**
             * ``AWS::ApiGateway::Method.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
             */
            Build withRequestParameters(final software.amazon.awscdk.Token value);
            /**
             * ``AWS::ApiGateway::Method.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
             */
            Build withRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
            /**
             * ``AWS::ApiGateway::Method.RequestValidatorId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
             */
            Build withRequestValidatorId(final java.lang.String value);
            /**
             * ``AWS::ApiGateway::Method.RequestValidatorId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
             */
            Build withRequestValidatorId(final software.amazon.awscdk.Token value);
        }

        final class FullBuilder implements ResourceIdStep, RestApiIdStep, Build {

            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``AWS::ApiGateway::Method.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
             */
            public ResourceIdStep withHttpMethod(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#httpMethod is required");
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
             */
            public ResourceIdStep withHttpMethod(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#httpMethod is required");
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.ResourceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
             */
            public RestApiIdStep withResourceId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#resourceId is required");
                this.instance._resourceId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.ResourceId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
             */
            public RestApiIdStep withResourceId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#resourceId is required");
                this.instance._resourceId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
             */
            public Build withRestApiId(final java.lang.String value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#restApiId is required");
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RestApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
             */
            public Build withRestApiId(final software.amazon.awscdk.Token value) {
                java.util.Objects.requireNonNull(value, "MethodResourceProps#restApiId is required");
                this.instance._restApiId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.ApiKeyRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
             */
            public Build withApiKeyRequired(final java.lang.Boolean value) {
                this.instance._apiKeyRequired = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.ApiKeyRequired``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
             */
            public Build withApiKeyRequired(final software.amazon.awscdk.Token value) {
                this.instance._apiKeyRequired = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.AuthorizationType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
             */
            public Build withAuthorizationType(final java.lang.String value) {
                this.instance._authorizationType = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.AuthorizationType``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
             */
            public Build withAuthorizationType(final software.amazon.awscdk.Token value) {
                this.instance._authorizationType = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.AuthorizerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
             */
            public Build withAuthorizerId(final java.lang.String value) {
                this.instance._authorizerId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.AuthorizerId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
             */
            public Build withAuthorizerId(final software.amazon.awscdk.Token value) {
                this.instance._authorizerId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.Integration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
             */
            public Build withIntegration(final software.amazon.awscdk.Token value) {
                this.instance._integration = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.Integration``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
             */
            public Build withIntegration(final software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty value) {
                this.instance._integration = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.MethodResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
             */
            public Build withMethodResponses(final software.amazon.awscdk.Token value) {
                this.instance._methodResponses = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.MethodResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
             */
            public Build withMethodResponses(final java.util.List<java.lang.Object> value) {
                this.instance._methodResponses = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.OperationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
             */
            public Build withOperationName(final java.lang.String value) {
                this.instance._operationName = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.OperationName``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
             */
            public Build withOperationName(final software.amazon.awscdk.Token value) {
                this.instance._operationName = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
             */
            public Build withRequestModels(final software.amazon.awscdk.Token value) {
                this.instance._requestModels = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
             */
            public Build withRequestModels(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._requestModels = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
             */
            public Build withRequestParameters(final software.amazon.awscdk.Token value) {
                this.instance._requestParameters = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
             */
            public Build withRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.instance._requestParameters = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestValidatorId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
             */
            public Build withRequestValidatorId(final java.lang.String value) {
                this.instance._requestValidatorId = value;
                return this;
            }
            /**
             * ``AWS::ApiGateway::Method.RequestValidatorId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
             */
            public Build withRequestValidatorId(final software.amazon.awscdk.Token value) {
                this.instance._requestValidatorId = value;
                return this;
            }
            public MethodResourceProps build() {
                MethodResourceProps result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }
    }

    /**
     * A PoJo (plain-old-java-object) class that implements {@link MethodResourceProps}.
     */
    final class Jsii$Pojo implements MethodResourceProps {

        /**
         * Constructor used by builders.
         */
        protected Jsii$Pojo() { }


        protected java.lang.Object _httpMethod;

        public java.lang.Object getHttpMethod() {
            return this._httpMethod;
        }
        public void setHttpMethod(final java.lang.String value) {
            this._httpMethod = value;
        }
        public void setHttpMethod(final software.amazon.awscdk.Token value) {
            this._httpMethod = value;
        }

        protected java.lang.Object _resourceId;

        public java.lang.Object getResourceId() {
            return this._resourceId;
        }
        public void setResourceId(final java.lang.String value) {
            this._resourceId = value;
        }
        public void setResourceId(final software.amazon.awscdk.Token value) {
            this._resourceId = value;
        }

        protected java.lang.Object _restApiId;

        public java.lang.Object getRestApiId() {
            return this._restApiId;
        }
        public void setRestApiId(final java.lang.String value) {
            this._restApiId = value;
        }
        public void setRestApiId(final software.amazon.awscdk.Token value) {
            this._restApiId = value;
        }

        protected java.lang.Object _apiKeyRequired;

        public java.lang.Object getApiKeyRequired() {
            return this._apiKeyRequired;
        }
        public void setApiKeyRequired(final java.lang.Boolean value) {
            this._apiKeyRequired = value;
        }
        public void setApiKeyRequired(final software.amazon.awscdk.Token value) {
            this._apiKeyRequired = value;
        }

        protected java.lang.Object _authorizationType;

        public java.lang.Object getAuthorizationType() {
            return this._authorizationType;
        }
        public void setAuthorizationType(final java.lang.String value) {
            this._authorizationType = value;
        }
        public void setAuthorizationType(final software.amazon.awscdk.Token value) {
            this._authorizationType = value;
        }

        protected java.lang.Object _authorizerId;

        public java.lang.Object getAuthorizerId() {
            return this._authorizerId;
        }
        public void setAuthorizerId(final java.lang.String value) {
            this._authorizerId = value;
        }
        public void setAuthorizerId(final software.amazon.awscdk.Token value) {
            this._authorizerId = value;
        }

        protected java.lang.Object _integration;

        public java.lang.Object getIntegration() {
            return this._integration;
        }
        public void setIntegration(final software.amazon.awscdk.Token value) {
            this._integration = value;
        }
        public void setIntegration(final software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty value) {
            this._integration = value;
        }

        protected java.lang.Object _methodResponses;

        public java.lang.Object getMethodResponses() {
            return this._methodResponses;
        }
        public void setMethodResponses(final software.amazon.awscdk.Token value) {
            this._methodResponses = value;
        }
        public void setMethodResponses(final java.util.List<java.lang.Object> value) {
            this._methodResponses = value;
        }

        protected java.lang.Object _operationName;

        public java.lang.Object getOperationName() {
            return this._operationName;
        }
        public void setOperationName(final java.lang.String value) {
            this._operationName = value;
        }
        public void setOperationName(final software.amazon.awscdk.Token value) {
            this._operationName = value;
        }

        protected java.lang.Object _requestModels;

        public java.lang.Object getRequestModels() {
            return this._requestModels;
        }
        public void setRequestModels(final software.amazon.awscdk.Token value) {
            this._requestModels = value;
        }
        public void setRequestModels(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._requestModels = value;
        }

        protected java.lang.Object _requestParameters;

        public java.lang.Object getRequestParameters() {
            return this._requestParameters;
        }
        public void setRequestParameters(final software.amazon.awscdk.Token value) {
            this._requestParameters = value;
        }
        public void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
            this._requestParameters = value;
        }

        protected java.lang.Object _requestValidatorId;

        public java.lang.Object getRequestValidatorId() {
            return this._requestValidatorId;
        }
        public void setRequestValidatorId(final java.lang.String value) {
            this._requestValidatorId = value;
        }
        public void setRequestValidatorId(final software.amazon.awscdk.Token value) {
            this._requestValidatorId = value;
        }
    }

    /**
     * A proxy class which for javascript object literal which adhere to this interface.
     */
    class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResourceProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }
        /**
         * ``AWS::ApiGateway::Method.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        public java.lang.Object getHttpMethod() {
            return this.jsiiGet("httpMethod", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        public void setHttpMethod(final java.lang.String value) {
            this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
         */
        public void setHttpMethod(final software.amazon.awscdk.Token value) {
            this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.ResourceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
         */
        public java.lang.Object getResourceId() {
            return this.jsiiGet("resourceId", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.ResourceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
         */
        public void setResourceId(final java.lang.String value) {
            this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.ResourceId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
         */
        public void setResourceId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
         */
        public java.lang.Object getRestApiId() {
            return this.jsiiGet("restApiId", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
         */
        public void setRestApiId(final java.lang.String value) {
            this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.RestApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
         */
        public void setRestApiId(final software.amazon.awscdk.Token value) {
            this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
        }
        /**
         * ``AWS::ApiGateway::Method.ApiKeyRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         */
        @javax.annotation.Nullable
        public java.lang.Object getApiKeyRequired() {
            return this.jsiiGet("apiKeyRequired", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.ApiKeyRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         */
        public void setApiKeyRequired(@javax.annotation.Nullable final java.lang.Boolean value) {
            this.jsiiSet("apiKeyRequired", value);
        }
        /**
         * ``AWS::ApiGateway::Method.ApiKeyRequired``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
         */
        public void setApiKeyRequired(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("apiKeyRequired", value);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizationType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
         */
        @javax.annotation.Nullable
        public java.lang.Object getAuthorizationType() {
            return this.jsiiGet("authorizationType", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizationType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
         */
        public void setAuthorizationType(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("authorizationType", value);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizationType``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
         */
        public void setAuthorizationType(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("authorizationType", value);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
         */
        @javax.annotation.Nullable
        public java.lang.Object getAuthorizerId() {
            return this.jsiiGet("authorizerId", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
         */
        public void setAuthorizerId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("authorizerId", value);
        }
        /**
         * ``AWS::ApiGateway::Method.AuthorizerId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
         */
        public void setAuthorizerId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("authorizerId", value);
        }
        /**
         * ``AWS::ApiGateway::Method.Integration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         */
        @javax.annotation.Nullable
        public java.lang.Object getIntegration() {
            return this.jsiiGet("integration", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.Integration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         */
        public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("integration", value);
        }
        /**
         * ``AWS::ApiGateway::Method.Integration``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
         */
        public void setIntegration(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty value) {
            this.jsiiSet("integration", value);
        }
        /**
         * ``AWS::ApiGateway::Method.MethodResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         */
        @javax.annotation.Nullable
        public java.lang.Object getMethodResponses() {
            return this.jsiiGet("methodResponses", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.MethodResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         */
        public void setMethodResponses(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("methodResponses", value);
        }
        /**
         * ``AWS::ApiGateway::Method.MethodResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
         */
        public void setMethodResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
            this.jsiiSet("methodResponses", value);
        }
        /**
         * ``AWS::ApiGateway::Method.OperationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
         */
        @javax.annotation.Nullable
        public java.lang.Object getOperationName() {
            return this.jsiiGet("operationName", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.OperationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
         */
        public void setOperationName(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("operationName", value);
        }
        /**
         * ``AWS::ApiGateway::Method.OperationName``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
         */
        public void setOperationName(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("operationName", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         */
        @javax.annotation.Nullable
        public java.lang.Object getRequestModels() {
            return this.jsiiGet("requestModels", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         */
        public void setRequestModels(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("requestModels", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
         */
        public void setRequestModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("requestModels", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         */
        @javax.annotation.Nullable
        public java.lang.Object getRequestParameters() {
            return this.jsiiGet("requestParameters", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         */
        public void setRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("requestParameters", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
         */
        public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
            this.jsiiSet("requestParameters", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestValidatorId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
         */
        @javax.annotation.Nullable
        public java.lang.Object getRequestValidatorId() {
            return this.jsiiGet("requestValidatorId", java.lang.Object.class);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestValidatorId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
         */
        public void setRequestValidatorId(@javax.annotation.Nullable final java.lang.String value) {
            this.jsiiSet("requestValidatorId", value);
        }
        /**
         * ``AWS::ApiGateway::Method.RequestValidatorId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
         */
        public void setRequestValidatorId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
            this.jsiiSet("requestValidatorId", value);
        }
    }
}
