package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-restapi.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.RestApiResource")
public class RestApiResource extends software.amazon.awscdk.Resource {
    protected RestApiResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::RestApi``.
     * @param parent the ``cdk.Construct`` this ``RestApiResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``RestApiResource``
     */
    public RestApiResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.RestApiResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ApiGateway::RestApi``.
     * @param parent the ``cdk.Construct`` this ``RestApiResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public RestApiResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @cloudformation_attribute RootResourceId
     */
    public software.amazon.awscdk.services.apigateway.RestApiRootResourceId getRestApiRootResourceId() {
        return this.jsiiGet("restApiRootResourceId", software.amazon.awscdk.services.apigateway.RestApiRootResourceId.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html
     */
    public static interface EndpointConfigurationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        java.lang.Object getTypes();
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        void setTypes(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.EndpointConfigurationProperty.Types``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
         */
        void setTypes(final java.util.List<java.lang.Object> value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link EndpointConfigurationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            public Builder withTypes(final software.amazon.awscdk.Token value) {
                this.instance._types = value;
                return this;
            }
            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            public Builder withTypes(final java.util.List<java.lang.Object> value) {
                this.instance._types = value;
                return this;
            }
            public EndpointConfigurationProperty build() {
                EndpointConfigurationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link EndpointConfigurationProperty}.
         */
        final class Jsii$Pojo implements EndpointConfigurationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _types;

            public java.lang.Object getTypes() {
                return this._types;
            }
            public void setTypes(final software.amazon.awscdk.Token value) {
                this._types = value;
            }
            public void setTypes(final java.util.List<java.lang.Object> value) {
                this._types = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.EndpointConfigurationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            @javax.annotation.Nullable
            public java.lang.Object getTypes() {
                return this.jsiiGet("types", java.lang.Object.class);
            }
            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            public void setTypes(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("types", value);
            }
            /**
             * ``RestApiResource.EndpointConfigurationProperty.Types``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-endpointconfiguration.html#cfn-apigateway-restapi-endpointconfiguration-types
             */
            public void setTypes(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("types", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html
     */
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        java.lang.Object getBucket();
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        void setBucket(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Bucket``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
         */
        void setBucket(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        java.lang.Object getETag();
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        void setETag(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.ETag``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
         */
        void setETag(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        java.lang.Object getKey();
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        void setKey(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Key``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
         */
        void setKey(final software.amazon.awscdk.Token value);
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        java.lang.Object getVersion();
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        void setVersion(final java.lang.String value);
        /**
         * ``RestApiResource.S3LocationProperty.Version``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
         */
        void setVersion(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link S3LocationProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            public Builder withBucket(final java.lang.String value) {
                this.instance._bucket = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            public Builder withBucket(final software.amazon.awscdk.Token value) {
                this.instance._bucket = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            public Builder withETag(final java.lang.String value) {
                this.instance._eTag = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            public Builder withETag(final software.amazon.awscdk.Token value) {
                this.instance._eTag = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            public Builder withKey(final java.lang.String value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            public Builder withKey(final software.amazon.awscdk.Token value) {
                this.instance._key = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            public Builder withVersion(final java.lang.String value) {
                this.instance._version = value;
                return this;
            }
            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            public Builder withVersion(final software.amazon.awscdk.Token value) {
                this.instance._version = value;
                return this;
            }
            public S3LocationProperty build() {
                S3LocationProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link S3LocationProperty}.
         */
        final class Jsii$Pojo implements S3LocationProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _bucket;

            public java.lang.Object getBucket() {
                return this._bucket;
            }
            public void setBucket(final java.lang.String value) {
                this._bucket = value;
            }
            public void setBucket(final software.amazon.awscdk.Token value) {
                this._bucket = value;
            }

            protected java.lang.Object _eTag;

            public java.lang.Object getETag() {
                return this._eTag;
            }
            public void setETag(final java.lang.String value) {
                this._eTag = value;
            }
            public void setETag(final software.amazon.awscdk.Token value) {
                this._eTag = value;
            }

            protected java.lang.Object _key;

            public java.lang.Object getKey() {
                return this._key;
            }
            public void setKey(final java.lang.String value) {
                this._key = value;
            }
            public void setKey(final software.amazon.awscdk.Token value) {
                this._key = value;
            }

            protected java.lang.Object _version;

            public java.lang.Object getVersion() {
                return this._version;
            }
            public void setVersion(final java.lang.String value) {
                this._version = value;
            }
            public void setVersion(final software.amazon.awscdk.Token value) {
                this._version = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.RestApiResource.S3LocationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            @javax.annotation.Nullable
            public java.lang.Object getBucket() {
                return this.jsiiGet("bucket", java.lang.Object.class);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            public void setBucket(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("bucket", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Bucket``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-bucket
             */
            public void setBucket(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("bucket", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            @javax.annotation.Nullable
            public java.lang.Object getETag() {
                return this.jsiiGet("eTag", java.lang.Object.class);
            }
            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            public void setETag(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("eTag", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.ETag``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-etag
             */
            public void setETag(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("eTag", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            @javax.annotation.Nullable
            public java.lang.Object getKey() {
                return this.jsiiGet("key", java.lang.Object.class);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            public void setKey(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Key``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-key
             */
            public void setKey(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("key", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            @javax.annotation.Nullable
            public java.lang.Object getVersion() {
                return this.jsiiGet("version", java.lang.Object.class);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            public void setVersion(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("version", value);
            }
            /**
             * ``RestApiResource.S3LocationProperty.Version``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-restapi-s3location.html#cfn-apigateway-restapi-s3location-version
             */
            public void setVersion(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("version", value);
            }
        }
    }
}
