package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.StageResource")
public class StageResource extends software.amazon.awscdk.Resource {
    protected StageResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.StageResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::Stage``.
     * @param parent the ``cdk.Construct`` this ``StageResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``StageResource``
     */
    public StageResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.StageResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html
     */
    public static interface MethodSettingProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        java.lang.Object getCacheDataEncrypted();
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
         */
        void setCacheDataEncrypted(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        java.lang.Object getCacheTtlInSeconds();
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
         */
        void setCacheTtlInSeconds(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        java.lang.Object getCachingEnabled();
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        void setCachingEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.CachingEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
         */
        void setCachingEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        java.lang.Object getDataTraceEnabled();
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.DataTraceEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
         */
        void setDataTraceEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        java.lang.Object getHttpMethod();
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        void setHttpMethod(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.HttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
         */
        void setHttpMethod(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        java.lang.Object getLoggingLevel();
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        void setLoggingLevel(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.LoggingLevel``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
         */
        void setLoggingLevel(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        java.lang.Object getMetricsEnabled();
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final java.lang.Boolean value);
        /**
         * ``StageResource.MethodSettingProperty.MetricsEnabled``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
         */
        void setMetricsEnabled(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        java.lang.Object getResourcePath();
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        void setResourcePath(final java.lang.String value);
        /**
         * ``StageResource.MethodSettingProperty.ResourcePath``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
         */
        void setResourcePath(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        java.lang.Object getThrottlingBurstLimit();
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
         */
        void setThrottlingBurstLimit(final software.amazon.awscdk.Token value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        java.lang.Object getThrottlingRateLimit();
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final java.lang.Number value);
        /**
         * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
         */
        void setThrottlingRateLimit(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link MethodSettingProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final java.lang.Boolean value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            public Builder withCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this.instance._cacheDataEncrypted = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final java.lang.Number value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            public Builder withCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this.instance._cacheTtlInSeconds = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            public Builder withCachingEnabled(final java.lang.Boolean value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            public Builder withCachingEnabled(final software.amazon.awscdk.Token value) {
                this.instance._cachingEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            public Builder withDataTraceEnabled(final java.lang.Boolean value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            public Builder withDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this.instance._dataTraceEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            public Builder withHttpMethod(final java.lang.String value) {
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            public Builder withHttpMethod(final software.amazon.awscdk.Token value) {
                this.instance._httpMethod = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            public Builder withLoggingLevel(final java.lang.String value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            public Builder withLoggingLevel(final software.amazon.awscdk.Token value) {
                this.instance._loggingLevel = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            public Builder withMetricsEnabled(final java.lang.Boolean value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            public Builder withMetricsEnabled(final software.amazon.awscdk.Token value) {
                this.instance._metricsEnabled = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            public Builder withResourcePath(final java.lang.String value) {
                this.instance._resourcePath = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            public Builder withResourcePath(final software.amazon.awscdk.Token value) {
                this.instance._resourcePath = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final java.lang.Number value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            public Builder withThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingBurstLimit = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final java.lang.Number value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            public Builder withThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this.instance._throttlingRateLimit = value;
                return this;
            }
            public MethodSettingProperty build() {
                MethodSettingProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link MethodSettingProperty}.
         */
        final class Jsii$Pojo implements MethodSettingProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _cacheDataEncrypted;

            public java.lang.Object getCacheDataEncrypted() {
                return this._cacheDataEncrypted;
            }
            public void setCacheDataEncrypted(final java.lang.Boolean value) {
                this._cacheDataEncrypted = value;
            }
            public void setCacheDataEncrypted(final software.amazon.awscdk.Token value) {
                this._cacheDataEncrypted = value;
            }

            protected java.lang.Object _cacheTtlInSeconds;

            public java.lang.Object getCacheTtlInSeconds() {
                return this._cacheTtlInSeconds;
            }
            public void setCacheTtlInSeconds(final java.lang.Number value) {
                this._cacheTtlInSeconds = value;
            }
            public void setCacheTtlInSeconds(final software.amazon.awscdk.Token value) {
                this._cacheTtlInSeconds = value;
            }

            protected java.lang.Object _cachingEnabled;

            public java.lang.Object getCachingEnabled() {
                return this._cachingEnabled;
            }
            public void setCachingEnabled(final java.lang.Boolean value) {
                this._cachingEnabled = value;
            }
            public void setCachingEnabled(final software.amazon.awscdk.Token value) {
                this._cachingEnabled = value;
            }

            protected java.lang.Object _dataTraceEnabled;

            public java.lang.Object getDataTraceEnabled() {
                return this._dataTraceEnabled;
            }
            public void setDataTraceEnabled(final java.lang.Boolean value) {
                this._dataTraceEnabled = value;
            }
            public void setDataTraceEnabled(final software.amazon.awscdk.Token value) {
                this._dataTraceEnabled = value;
            }

            protected java.lang.Object _httpMethod;

            public java.lang.Object getHttpMethod() {
                return this._httpMethod;
            }
            public void setHttpMethod(final java.lang.String value) {
                this._httpMethod = value;
            }
            public void setHttpMethod(final software.amazon.awscdk.Token value) {
                this._httpMethod = value;
            }

            protected java.lang.Object _loggingLevel;

            public java.lang.Object getLoggingLevel() {
                return this._loggingLevel;
            }
            public void setLoggingLevel(final java.lang.String value) {
                this._loggingLevel = value;
            }
            public void setLoggingLevel(final software.amazon.awscdk.Token value) {
                this._loggingLevel = value;
            }

            protected java.lang.Object _metricsEnabled;

            public java.lang.Object getMetricsEnabled() {
                return this._metricsEnabled;
            }
            public void setMetricsEnabled(final java.lang.Boolean value) {
                this._metricsEnabled = value;
            }
            public void setMetricsEnabled(final software.amazon.awscdk.Token value) {
                this._metricsEnabled = value;
            }

            protected java.lang.Object _resourcePath;

            public java.lang.Object getResourcePath() {
                return this._resourcePath;
            }
            public void setResourcePath(final java.lang.String value) {
                this._resourcePath = value;
            }
            public void setResourcePath(final software.amazon.awscdk.Token value) {
                this._resourcePath = value;
            }

            protected java.lang.Object _throttlingBurstLimit;

            public java.lang.Object getThrottlingBurstLimit() {
                return this._throttlingBurstLimit;
            }
            public void setThrottlingBurstLimit(final java.lang.Number value) {
                this._throttlingBurstLimit = value;
            }
            public void setThrottlingBurstLimit(final software.amazon.awscdk.Token value) {
                this._throttlingBurstLimit = value;
            }

            protected java.lang.Object _throttlingRateLimit;

            public java.lang.Object getThrottlingRateLimit() {
                return this._throttlingRateLimit;
            }
            public void setThrottlingRateLimit(final java.lang.Number value) {
                this._throttlingRateLimit = value;
            }
            public void setThrottlingRateLimit(final software.amazon.awscdk.Token value) {
                this._throttlingRateLimit = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.StageResource.MethodSettingProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheDataEncrypted() {
                return this.jsiiGet("cacheDataEncrypted", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheDataEncrypted``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachedataencrypted
             */
            public void setCacheDataEncrypted(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheDataEncrypted", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            @javax.annotation.Nullable
            public java.lang.Object getCacheTtlInSeconds() {
                return this.jsiiGet("cacheTtlInSeconds", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.CacheTtlInSeconds``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachettlinseconds
             */
            public void setCacheTtlInSeconds(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cacheTtlInSeconds", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getCachingEnabled() {
                return this.jsiiGet("cachingEnabled", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.CachingEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-cachingenabled
             */
            public void setCachingEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("cachingEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getDataTraceEnabled() {
                return this.jsiiGet("dataTraceEnabled", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.DataTraceEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-datatraceenabled
             */
            public void setDataTraceEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("dataTraceEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            @javax.annotation.Nullable
            public java.lang.Object getHttpMethod() {
                return this.jsiiGet("httpMethod", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            public void setHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("httpMethod", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.HttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-httpmethod
             */
            public void setHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("httpMethod", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            @javax.annotation.Nullable
            public java.lang.Object getLoggingLevel() {
                return this.jsiiGet("loggingLevel", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.LoggingLevel``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-logginglevel
             */
            public void setLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("loggingLevel", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            @javax.annotation.Nullable
            public java.lang.Object getMetricsEnabled() {
                return this.jsiiGet("metricsEnabled", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.MetricsEnabled``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-metricsenabled
             */
            public void setMetricsEnabled(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("metricsEnabled", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            @javax.annotation.Nullable
            public java.lang.Object getResourcePath() {
                return this.jsiiGet("resourcePath", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            public void setResourcePath(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("resourcePath", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ResourcePath``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-resourcepath
             */
            public void setResourcePath(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("resourcePath", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingBurstLimit() {
                return this.jsiiGet("throttlingBurstLimit", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingBurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingburstlimit
             */
            public void setThrottlingBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingBurstLimit", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getThrottlingRateLimit() {
                return this.jsiiGet("throttlingRateLimit", java.lang.Object.class);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
            /**
             * ``StageResource.MethodSettingProperty.ThrottlingRateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-stage-methodsetting.html#cfn-apigateway-stage-methodsetting-throttlingratelimit
             */
            public void setThrottlingRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("throttlingRateLimit", value);
            }
        }
    }
}
