package software.amazon.awscdk.services.apigateway.cloudformation;
/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-usageplan.html
 */
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.UsagePlanResource")
public class UsagePlanResource extends software.amazon.awscdk.Resource {
    protected UsagePlanResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.UsagePlanResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::UsagePlan``.
     * @param parent the ``cdk.Construct`` this ``UsagePlanResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``UsagePlanResource``
     */
    public UsagePlanResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, @javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.cloudformation.UsagePlanResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(properties)).toArray());
    }
    /**
     * Creates a new ``AWS::ApiGateway::UsagePlan``.
     * @param parent the ``cdk.Construct`` this ``UsagePlanResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     */
    public UsagePlanResource(final software.amazon.awscdk.Construct parent, final java.lang.String name) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))).toArray());
    }
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html
     */
    public static interface ApiStageProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``UsagePlanResource.ApiStageProperty.ApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
         */
        java.lang.Object getApiId();
        /**
         * ``UsagePlanResource.ApiStageProperty.ApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
         */
        void setApiId(final java.lang.String value);
        /**
         * ``UsagePlanResource.ApiStageProperty.ApiId``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
         */
        void setApiId(final software.amazon.awscdk.Token value);
        /**
         * ``UsagePlanResource.ApiStageProperty.Stage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
         */
        java.lang.Object getStage();
        /**
         * ``UsagePlanResource.ApiStageProperty.Stage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
         */
        void setStage(final java.lang.String value);
        /**
         * ``UsagePlanResource.ApiStageProperty.Stage``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
         */
        void setStage(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ApiStageProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``UsagePlanResource.ApiStageProperty.ApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
             */
            public Builder withApiId(final java.lang.String value) {
                this.instance._apiId = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.ApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
             */
            public Builder withApiId(final software.amazon.awscdk.Token value) {
                this.instance._apiId = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.Stage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
             */
            public Builder withStage(final java.lang.String value) {
                this.instance._stage = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.Stage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
             */
            public Builder withStage(final software.amazon.awscdk.Token value) {
                this.instance._stage = value;
                return this;
            }
            public ApiStageProperty build() {
                ApiStageProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ApiStageProperty}.
         */
        final class Jsii$Pojo implements ApiStageProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _apiId;

            public java.lang.Object getApiId() {
                return this._apiId;
            }
            public void setApiId(final java.lang.String value) {
                this._apiId = value;
            }
            public void setApiId(final software.amazon.awscdk.Token value) {
                this._apiId = value;
            }

            protected java.lang.Object _stage;

            public java.lang.Object getStage() {
                return this._stage;
            }
            public void setStage(final java.lang.String value) {
                this._stage = value;
            }
            public void setStage(final software.amazon.awscdk.Token value) {
                this._stage = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.UsagePlanResource.ApiStageProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.ApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
             */
            @javax.annotation.Nullable
            public java.lang.Object getApiId() {
                return this.jsiiGet("apiId", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.ApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
             */
            public void setApiId(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("apiId", value);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.ApiId``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-apiid
             */
            public void setApiId(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("apiId", value);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.Stage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
             */
            @javax.annotation.Nullable
            public java.lang.Object getStage() {
                return this.jsiiGet("stage", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.Stage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
             */
            public void setStage(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("stage", value);
            }
            /**
             * ``UsagePlanResource.ApiStageProperty.Stage``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-apistage.html#cfn-apigateway-usageplan-apistage-stage
             */
            public void setStage(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("stage", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html
     */
    public static interface QuotaSettingsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Limit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
         */
        java.lang.Object getLimit();
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Limit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
         */
        void setLimit(final java.lang.Number value);
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Limit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
         */
        void setLimit(final software.amazon.awscdk.Token value);
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Offset``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
         */
        java.lang.Object getOffset();
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Offset``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
         */
        void setOffset(final java.lang.Number value);
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Offset``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
         */
        void setOffset(final software.amazon.awscdk.Token value);
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Period``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
         */
        java.lang.Object getPeriod();
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Period``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
         */
        void setPeriod(final java.lang.String value);
        /**
         * ``UsagePlanResource.QuotaSettingsProperty.Period``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
         */
        void setPeriod(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link QuotaSettingsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Limit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
             */
            public Builder withLimit(final java.lang.Number value) {
                this.instance._limit = value;
                return this;
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Limit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
             */
            public Builder withLimit(final software.amazon.awscdk.Token value) {
                this.instance._limit = value;
                return this;
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Offset``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
             */
            public Builder withOffset(final java.lang.Number value) {
                this.instance._offset = value;
                return this;
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Offset``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
             */
            public Builder withOffset(final software.amazon.awscdk.Token value) {
                this.instance._offset = value;
                return this;
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Period``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
             */
            public Builder withPeriod(final java.lang.String value) {
                this.instance._period = value;
                return this;
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Period``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
             */
            public Builder withPeriod(final software.amazon.awscdk.Token value) {
                this.instance._period = value;
                return this;
            }
            public QuotaSettingsProperty build() {
                QuotaSettingsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link QuotaSettingsProperty}.
         */
        final class Jsii$Pojo implements QuotaSettingsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _limit;

            public java.lang.Object getLimit() {
                return this._limit;
            }
            public void setLimit(final java.lang.Number value) {
                this._limit = value;
            }
            public void setLimit(final software.amazon.awscdk.Token value) {
                this._limit = value;
            }

            protected java.lang.Object _offset;

            public java.lang.Object getOffset() {
                return this._offset;
            }
            public void setOffset(final java.lang.Number value) {
                this._offset = value;
            }
            public void setOffset(final software.amazon.awscdk.Token value) {
                this._offset = value;
            }

            protected java.lang.Object _period;

            public java.lang.Object getPeriod() {
                return this._period;
            }
            public void setPeriod(final java.lang.String value) {
                this._period = value;
            }
            public void setPeriod(final software.amazon.awscdk.Token value) {
                this._period = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.UsagePlanResource.QuotaSettingsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Limit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
             */
            @javax.annotation.Nullable
            public java.lang.Object getLimit() {
                return this.jsiiGet("limit", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Limit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
             */
            public void setLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("limit", value);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Limit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-limit
             */
            public void setLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("limit", value);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Offset``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
             */
            @javax.annotation.Nullable
            public java.lang.Object getOffset() {
                return this.jsiiGet("offset", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Offset``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
             */
            public void setOffset(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("offset", value);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Offset``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-offset
             */
            public void setOffset(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("offset", value);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Period``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
             */
            @javax.annotation.Nullable
            public java.lang.Object getPeriod() {
                return this.jsiiGet("period", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Period``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
             */
            public void setPeriod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("period", value);
            }
            /**
             * ``UsagePlanResource.QuotaSettingsProperty.Period``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-quotasettings.html#cfn-apigateway-usageplan-quotasettings-period
             */
            public void setPeriod(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("period", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html
     */
    public static interface ThrottleSettingsProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
         */
        java.lang.Object getBurstLimit();
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
         */
        void setBurstLimit(final java.lang.Number value);
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
         */
        void setBurstLimit(final software.amazon.awscdk.Token value);
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
         */
        java.lang.Object getRateLimit();
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
         */
        void setRateLimit(final java.lang.Number value);
        /**
         * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
         */
        void setRateLimit(final software.amazon.awscdk.Token value);

        // ==================================================================
        // Builder
        // ==================================================================

        static Builder builder() {
            return new Builder();
        }

        /**
         * A fluent builder class for {@link ThrottleSettingsProperty}.
         */
        public static final class Builder {
            private Jsii$Pojo instance = new Jsii$Pojo();

            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
             */
            public Builder withBurstLimit(final java.lang.Number value) {
                this.instance._burstLimit = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
             */
            public Builder withBurstLimit(final software.amazon.awscdk.Token value) {
                this.instance._burstLimit = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
             */
            public Builder withRateLimit(final java.lang.Number value) {
                this.instance._rateLimit = value;
                return this;
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
             */
            public Builder withRateLimit(final software.amazon.awscdk.Token value) {
                this.instance._rateLimit = value;
                return this;
            }
            public ThrottleSettingsProperty build() {
                ThrottleSettingsProperty result = this.instance;
                this.instance = new Jsii$Pojo();
                return result;
            }
        }

        /**
         * A PoJo (plain-old-java-object) class that implements {@link ThrottleSettingsProperty}.
         */
        final class Jsii$Pojo implements ThrottleSettingsProperty {

            /**
             * Constructor used by builders.
             */
            protected Jsii$Pojo() { }


            protected java.lang.Object _burstLimit;

            public java.lang.Object getBurstLimit() {
                return this._burstLimit;
            }
            public void setBurstLimit(final java.lang.Number value) {
                this._burstLimit = value;
            }
            public void setBurstLimit(final software.amazon.awscdk.Token value) {
                this._burstLimit = value;
            }

            protected java.lang.Object _rateLimit;

            public java.lang.Object getRateLimit() {
                return this._rateLimit;
            }
            public void setRateLimit(final java.lang.Number value) {
                this._rateLimit = value;
            }
            public void setRateLimit(final software.amazon.awscdk.Token value) {
                this._rateLimit = value;
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.UsagePlanResource.ThrottleSettingsProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getBurstLimit() {
                return this.jsiiGet("burstLimit", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
             */
            public void setBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("burstLimit", value);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.BurstLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-burstlimit
             */
            public void setBurstLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("burstLimit", value);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
             */
            @javax.annotation.Nullable
            public java.lang.Object getRateLimit() {
                return this.jsiiGet("rateLimit", java.lang.Object.class);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
             */
            public void setRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
                this.jsiiSet("rateLimit", value);
            }
            /**
             * ``UsagePlanResource.ThrottleSettingsProperty.RateLimit``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigateway-usageplan-throttlesettings.html#cfn-apigateway-usageplan-throttlesettings-ratelimit
             */
            public void setRateLimit(@javax.annotation.Nullable final software.amazon.awscdk.Token value) {
                this.jsiiSet("rateLimit", value);
            }
        }
    }
}
