package software.amazon.awscdk.services.apigateway.cloudformation;

/**
 * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.7.4 (build e80a889)", date = "2018-09-11T09:51:59.293Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.cloudformation.MethodResource")
public class MethodResource extends software.amazon.awscdk.Resource {
    protected MethodResource(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
        super(mode);
    }
    static {
        RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.class, "resourceTypeName", java.lang.String.class);
    }
    /**
     * Creates a new ``AWS::ApiGateway::Method``.
     * @param parent the ``cdk.Construct`` this ``MethodResource`` is a part of
     * @param name the name of the resource in the ``cdk.Construct`` tree
     * @param properties the properties of this ``MethodResource``
     */
    public MethodResource(final software.amazon.awscdk.Construct parent, final java.lang.String name, final software.amazon.awscdk.services.apigateway.cloudformation.MethodResourceProps properties) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.Jsii);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, java.util.stream.Stream.concat(java.util.stream.Stream.concat(java.util.stream.Stream.of(java.util.Objects.requireNonNull(parent, "parent is required")), java.util.stream.Stream.of(java.util.Objects.requireNonNull(name, "name is required"))), java.util.stream.Stream.of(java.util.Objects.requireNonNull(properties, "properties is required"))).toArray());
    }

    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties() {
        return this.jsiiCall("renderProperties", java.util.Map.class);
    }
    /**
     * The CloudFormation resource type name for this resource class.
     */
    public final static java.lang.String RESOURCE_TYPE_NAME;

    public software.amazon.awscdk.services.apigateway.MethodId getRef() {
        return this.jsiiGet("ref", software.amazon.awscdk.services.apigateway.MethodId.class);
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     */
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        java.lang.Object getCacheKeyParameters();
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        void setCacheKeyParameters(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.CacheKeyParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        void setCacheKeyParameters(final java.util.List<java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        java.lang.Object getCacheNamespace();
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        void setCacheNamespace(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.CacheNamespace``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        void setCacheNamespace(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        java.lang.Object getContentHandling();
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        void setContentHandling(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        void setContentHandling(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        java.lang.Object getCredentials();
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        void setCredentials(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Credentials``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        void setCredentials(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        java.lang.Object getIntegrationHttpMethod();
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        void setIntegrationHttpMethod(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        void setIntegrationHttpMethod(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        java.lang.Object getIntegrationResponses();
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        void setIntegrationResponses(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.IntegrationResponses``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        void setIntegrationResponses(final java.util.List<java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        java.lang.Object getPassthroughBehavior();
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        void setPassthroughBehavior(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.PassthroughBehavior``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        void setPassthroughBehavior(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        java.lang.Object getRequestParameters();
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        void setRequestParameters(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.RequestParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        java.lang.Object getRequestTemplates();
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        void setRequestTemplates(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.RequestTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        void setRequestTemplates(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        java.lang.Object getType();
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        void setType(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Type``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        void setType(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        java.lang.Object getUri();
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        void setUri(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationProperty.Uri``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        void setUri(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IntegrationProperty}
         */
        final class Builder {
            @javax.annotation.Nullable
            private java.lang.Object _cacheKeyParameters;
            @javax.annotation.Nullable
            private java.lang.Object _cacheNamespace;
            @javax.annotation.Nullable
            private java.lang.Object _contentHandling;
            @javax.annotation.Nullable
            private java.lang.Object _credentials;
            @javax.annotation.Nullable
            private java.lang.Object _integrationHttpMethod;
            @javax.annotation.Nullable
            private java.lang.Object _integrationResponses;
            @javax.annotation.Nullable
            private java.lang.Object _passthroughBehavior;
            @javax.annotation.Nullable
            private java.lang.Object _requestParameters;
            @javax.annotation.Nullable
            private java.lang.Object _requestTemplates;
            @javax.annotation.Nullable
            private java.lang.Object _type;
            @javax.annotation.Nullable
            private java.lang.Object _uri;

            /**
             * Sets the value of CacheKeyParameters
             * @param value ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @return {@code this}
             */
            public Builder withCacheKeyParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._cacheKeyParameters = value;
                return this;
            }
            /**
             * Sets the value of CacheKeyParameters
             * @param value ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @return {@code this}
             */
            public Builder withCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._cacheKeyParameters = value;
                return this;
            }
            /**
             * Sets the value of CacheNamespace
             * @param value ``MethodResource.IntegrationProperty.CacheNamespace``
             * @return {@code this}
             */
            public Builder withCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                this._cacheNamespace = value;
                return this;
            }
            /**
             * Sets the value of CacheNamespace
             * @param value ``MethodResource.IntegrationProperty.CacheNamespace``
             * @return {@code this}
             */
            public Builder withCacheNamespace(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._cacheNamespace = value;
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value ``MethodResource.IntegrationProperty.ContentHandling``
             * @return {@code this}
             */
            public Builder withContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value ``MethodResource.IntegrationProperty.ContentHandling``
             * @return {@code this}
             */
            public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of Credentials
             * @param value ``MethodResource.IntegrationProperty.Credentials``
             * @return {@code this}
             */
            public Builder withCredentials(@javax.annotation.Nullable final java.lang.String value) {
                this._credentials = value;
                return this;
            }
            /**
             * Sets the value of Credentials
             * @param value ``MethodResource.IntegrationProperty.Credentials``
             * @return {@code this}
             */
            public Builder withCredentials(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._credentials = value;
                return this;
            }
            /**
             * Sets the value of IntegrationHttpMethod
             * @param value ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @return {@code this}
             */
            public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this._integrationHttpMethod = value;
                return this;
            }
            /**
             * Sets the value of IntegrationHttpMethod
             * @param value ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @return {@code this}
             */
            public Builder withIntegrationHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._integrationHttpMethod = value;
                return this;
            }
            /**
             * Sets the value of IntegrationResponses
             * @param value ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @return {@code this}
             */
            public Builder withIntegrationResponses(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._integrationResponses = value;
                return this;
            }
            /**
             * Sets the value of IntegrationResponses
             * @param value ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @return {@code this}
             */
            public Builder withIntegrationResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this._integrationResponses = value;
                return this;
            }
            /**
             * Sets the value of PassthroughBehavior
             * @param value ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @return {@code this}
             */
            public Builder withPassthroughBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this._passthroughBehavior = value;
                return this;
            }
            /**
             * Sets the value of PassthroughBehavior
             * @param value ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @return {@code this}
             */
            public Builder withPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._passthroughBehavior = value;
                return this;
            }
            /**
             * Sets the value of RequestParameters
             * @param value ``MethodResource.IntegrationProperty.RequestParameters``
             * @return {@code this}
             */
            public Builder withRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._requestParameters = value;
                return this;
            }
            /**
             * Sets the value of RequestParameters
             * @param value ``MethodResource.IntegrationProperty.RequestParameters``
             * @return {@code this}
             */
            public Builder withRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._requestParameters = value;
                return this;
            }
            /**
             * Sets the value of RequestTemplates
             * @param value ``MethodResource.IntegrationProperty.RequestTemplates``
             * @return {@code this}
             */
            public Builder withRequestTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._requestTemplates = value;
                return this;
            }
            /**
             * Sets the value of RequestTemplates
             * @param value ``MethodResource.IntegrationProperty.RequestTemplates``
             * @return {@code this}
             */
            public Builder withRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._requestTemplates = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``MethodResource.IntegrationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final java.lang.String value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Type
             * @param value ``MethodResource.IntegrationProperty.Type``
             * @return {@code this}
             */
            public Builder withType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._type = value;
                return this;
            }
            /**
             * Sets the value of Uri
             * @param value ``MethodResource.IntegrationProperty.Uri``
             * @return {@code this}
             */
            public Builder withUri(@javax.annotation.Nullable final java.lang.String value) {
                this._uri = value;
                return this;
            }
            /**
             * Sets the value of Uri
             * @param value ``MethodResource.IntegrationProperty.Uri``
             * @return {@code this}
             */
            public Builder withUri(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._uri = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IntegrationProperty build() {
                return new IntegrationProperty() {
                    @javax.annotation.Nullable
                    private java.lang.Object $cacheKeyParameters = _cacheKeyParameters;
                    @javax.annotation.Nullable
                    private java.lang.Object $cacheNamespace = _cacheNamespace;
                    @javax.annotation.Nullable
                    private java.lang.Object $contentHandling = _contentHandling;
                    @javax.annotation.Nullable
                    private java.lang.Object $credentials = _credentials;
                    @javax.annotation.Nullable
                    private java.lang.Object $integrationHttpMethod = _integrationHttpMethod;
                    @javax.annotation.Nullable
                    private java.lang.Object $integrationResponses = _integrationResponses;
                    @javax.annotation.Nullable
                    private java.lang.Object $passthroughBehavior = _passthroughBehavior;
                    @javax.annotation.Nullable
                    private java.lang.Object $requestParameters = _requestParameters;
                    @javax.annotation.Nullable
                    private java.lang.Object $requestTemplates = _requestTemplates;
                    @javax.annotation.Nullable
                    private java.lang.Object $type = _type;
                    @javax.annotation.Nullable
                    private java.lang.Object $uri = _uri;

                    @Override
                    public java.lang.Object getCacheKeyParameters() {
                        return this.$cacheKeyParameters;
                    }

                    @Override
                    public void setCacheKeyParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$cacheKeyParameters = value;
                    }

                    @Override
                    public void setCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$cacheKeyParameters = value;
                    }

                    @Override
                    public java.lang.Object getCacheNamespace() {
                        return this.$cacheNamespace;
                    }

                    @Override
                    public void setCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                        this.$cacheNamespace = value;
                    }

                    @Override
                    public void setCacheNamespace(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$cacheNamespace = value;
                    }

                    @Override
                    public java.lang.Object getContentHandling() {
                        return this.$contentHandling;
                    }

                    @Override
                    public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                        this.$contentHandling = value;
                    }

                    @Override
                    public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$contentHandling = value;
                    }

                    @Override
                    public java.lang.Object getCredentials() {
                        return this.$credentials;
                    }

                    @Override
                    public void setCredentials(@javax.annotation.Nullable final java.lang.String value) {
                        this.$credentials = value;
                    }

                    @Override
                    public void setCredentials(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$credentials = value;
                    }

                    @Override
                    public java.lang.Object getIntegrationHttpMethod() {
                        return this.$integrationHttpMethod;
                    }

                    @Override
                    public void setIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                        this.$integrationHttpMethod = value;
                    }

                    @Override
                    public void setIntegrationHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$integrationHttpMethod = value;
                    }

                    @Override
                    public java.lang.Object getIntegrationResponses() {
                        return this.$integrationResponses;
                    }

                    @Override
                    public void setIntegrationResponses(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$integrationResponses = value;
                    }

                    @Override
                    public void setIntegrationResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                        this.$integrationResponses = value;
                    }

                    @Override
                    public java.lang.Object getPassthroughBehavior() {
                        return this.$passthroughBehavior;
                    }

                    @Override
                    public void setPassthroughBehavior(@javax.annotation.Nullable final java.lang.String value) {
                        this.$passthroughBehavior = value;
                    }

                    @Override
                    public void setPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$passthroughBehavior = value;
                    }

                    @Override
                    public java.lang.Object getRequestParameters() {
                        return this.$requestParameters;
                    }

                    @Override
                    public void setRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$requestParameters = value;
                    }

                    @Override
                    public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$requestParameters = value;
                    }

                    @Override
                    public java.lang.Object getRequestTemplates() {
                        return this.$requestTemplates;
                    }

                    @Override
                    public void setRequestTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$requestTemplates = value;
                    }

                    @Override
                    public void setRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$requestTemplates = value;
                    }

                    @Override
                    public java.lang.Object getType() {
                        return this.$type;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final java.lang.String value) {
                        this.$type = value;
                    }

                    @Override
                    public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$type = value;
                    }

                    @Override
                    public java.lang.Object getUri() {
                        return this.$uri;
                    }

                    @Override
                    public void setUri(@javax.annotation.Nullable final java.lang.String value) {
                        this.$uri = value;
                    }

                    @Override
                    public void setUri(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$uri = value;
                    }

                };
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheKeyParameters() {
                return this.jsiiGet("cacheKeyParameters", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            @Override
            public void setCacheKeyParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("cacheKeyParameters", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheKeyParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
             */
            @Override
            public void setCacheKeyParameters(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("cacheKeyParameters", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCacheNamespace() {
                return this.jsiiGet("cacheNamespace", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            @Override
            public void setCacheNamespace(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("cacheNamespace", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.CacheNamespace``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
             */
            @Override
            public void setCacheNamespace(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("cacheNamespace", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            @Override
            public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("contentHandling", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
             */
            @Override
            public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("contentHandling", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getCredentials() {
                return this.jsiiGet("credentials", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            @Override
            public void setCredentials(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("credentials", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Credentials``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
             */
            @Override
            public void setCredentials(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("credentials", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIntegrationHttpMethod() {
                return this.jsiiGet("integrationHttpMethod", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            @Override
            public void setIntegrationHttpMethod(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("integrationHttpMethod", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationHttpMethod``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
             */
            @Override
            public void setIntegrationHttpMethod(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("integrationHttpMethod", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getIntegrationResponses() {
                return this.jsiiGet("integrationResponses", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            @Override
            public void setIntegrationResponses(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("integrationResponses", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.IntegrationResponses``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
             */
            @Override
            public void setIntegrationResponses(@javax.annotation.Nullable final java.util.List<java.lang.Object> value) {
                this.jsiiSet("integrationResponses", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getPassthroughBehavior() {
                return this.jsiiGet("passthroughBehavior", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            @Override
            public void setPassthroughBehavior(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("passthroughBehavior", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.PassthroughBehavior``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
             */
            @Override
            public void setPassthroughBehavior(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("passthroughBehavior", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRequestParameters() {
                return this.jsiiGet("requestParameters", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            @Override
            public void setRequestParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("requestParameters", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
             */
            @Override
            public void setRequestParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("requestParameters", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getRequestTemplates() {
                return this.jsiiGet("requestTemplates", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            @Override
            public void setRequestTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("requestTemplates", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.RequestTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
             */
            @Override
            public void setRequestTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("requestTemplates", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getType() {
                return this.jsiiGet("type", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Type``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
             */
            @Override
            public void setType(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("type", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getUri() {
                return this.jsiiGet("uri", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            @Override
            public void setUri(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("uri", value);
            }

            /**
             * ``MethodResource.IntegrationProperty.Uri``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
             */
            @Override
            public void setUri(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("uri", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     */
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        java.lang.Object getContentHandling();
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        void setContentHandling(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ContentHandling``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        void setContentHandling(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        java.lang.Object getResponseParameters();
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        void setResponseParameters(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        java.lang.Object getResponseTemplates();
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        void setResponseTemplates(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        void setResponseTemplates(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        java.lang.Object getSelectionPattern();
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        void setSelectionPattern(final java.lang.String value);
        /**
         * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        void setSelectionPattern(final software.amazon.awscdk.CloudFormationToken value);

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        final class Builder {
            private java.lang.Object _statusCode;
            @javax.annotation.Nullable
            private java.lang.Object _contentHandling;
            @javax.annotation.Nullable
            private java.lang.Object _responseParameters;
            @javax.annotation.Nullable
            private java.lang.Object _responseTemplates;
            @javax.annotation.Nullable
            private java.lang.Object _selectionPattern;

            /**
             * Sets the value of StatusCode
             * @param value ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of StatusCode
             * @param value ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @return {@code this}
             */
            public Builder withContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of ContentHandling
             * @param value ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @return {@code this}
             */
            public Builder withContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._contentHandling = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @return {@code this}
             */
            public Builder withResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @return {@code this}
             */
            public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseTemplates
             * @param value ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @return {@code this}
             */
            public Builder withResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._responseTemplates = value;
                return this;
            }
            /**
             * Sets the value of ResponseTemplates
             * @param value ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @return {@code this}
             */
            public Builder withResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseTemplates = value;
                return this;
            }
            /**
             * Sets the value of SelectionPattern
             * @param value ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @return {@code this}
             */
            public Builder withSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
                this._selectionPattern = value;
                return this;
            }
            /**
             * Sets the value of SelectionPattern
             * @param value ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @return {@code this}
             */
            public Builder withSelectionPattern(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._selectionPattern = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public IntegrationResponseProperty build() {
                return new IntegrationResponseProperty() {
                    private java.lang.Object $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $contentHandling = _contentHandling;
                    @javax.annotation.Nullable
                    private java.lang.Object $responseParameters = _responseParameters;
                    @javax.annotation.Nullable
                    private java.lang.Object $responseTemplates = _responseTemplates;
                    @javax.annotation.Nullable
                    private java.lang.Object $selectionPattern = _selectionPattern;

                    @Override
                    public java.lang.Object getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public void setStatusCode(final java.lang.String value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public void setStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public java.lang.Object getContentHandling() {
                        return this.$contentHandling;
                    }

                    @Override
                    public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                        this.$contentHandling = value;
                    }

                    @Override
                    public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$contentHandling = value;
                    }

                    @Override
                    public java.lang.Object getResponseParameters() {
                        return this.$responseParameters;
                    }

                    @Override
                    public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$responseParameters = value;
                    }

                    @Override
                    public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$responseParameters = value;
                    }

                    @Override
                    public java.lang.Object getResponseTemplates() {
                        return this.$responseTemplates;
                    }

                    @Override
                    public void setResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$responseTemplates = value;
                    }

                    @Override
                    public void setResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$responseTemplates = value;
                    }

                    @Override
                    public java.lang.Object getSelectionPattern() {
                        return this.$selectionPattern;
                    }

                    @Override
                    public void setSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
                        this.$selectionPattern = value;
                    }

                    @Override
                    public void setSelectionPattern(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$selectionPattern = value;
                    }

                };
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.IntegrationResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            @Override
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            @Override
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
             */
            @Override
            public void setStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getContentHandling() {
                return this.jsiiGet("contentHandling", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            @Override
            public void setContentHandling(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("contentHandling", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ContentHandling``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
             */
            @Override
            public void setContentHandling(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("contentHandling", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            @Override
            public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("responseParameters", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
             */
            @Override
            public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseParameters", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResponseTemplates() {
                return this.jsiiGet("responseTemplates", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            @Override
            public void setResponseTemplates(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("responseTemplates", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.ResponseTemplates``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
             */
            @Override
            public void setResponseTemplates(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseTemplates", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getSelectionPattern() {
                return this.jsiiGet("selectionPattern", java.lang.Object.class);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            @Override
            public void setSelectionPattern(@javax.annotation.Nullable final java.lang.String value) {
                this.jsiiSet("selectionPattern", value);
            }

            /**
             * ``MethodResource.IntegrationResponseProperty.SelectionPattern``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
             */
            @Override
            public void setSelectionPattern(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("selectionPattern", value);
            }
        }
    }
    /**
     * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     */
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        java.lang.Object getStatusCode();
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        void setStatusCode(final java.lang.String value);
        /**
         * ``MethodResource.MethodResponseProperty.StatusCode``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        void setStatusCode(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        java.lang.Object getResponseModels();
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        void setResponseModels(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseModels``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        void setResponseModels(final java.util.Map<java.lang.String, java.lang.Object> value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        java.lang.Object getResponseParameters();
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        void setResponseParameters(final software.amazon.awscdk.CloudFormationToken value);
        /**
         * ``MethodResource.MethodResponseProperty.ResponseParameters``
         * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        void setResponseParameters(final java.util.Map<java.lang.String, java.lang.Object> value);

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        static Builder builder() {
            return new Builder();
        }

        /**
         * A builder for {@link MethodResponseProperty}
         */
        final class Builder {
            private java.lang.Object _statusCode;
            @javax.annotation.Nullable
            private java.lang.Object _responseModels;
            @javax.annotation.Nullable
            private java.lang.Object _responseParameters;

            /**
             * Sets the value of StatusCode
             * @param value ``MethodResource.MethodResponseProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final java.lang.String value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of StatusCode
             * @param value ``MethodResource.MethodResponseProperty.StatusCode``
             * @return {@code this}
             */
            public Builder withStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                this._statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                return this;
            }
            /**
             * Sets the value of ResponseModels
             * @param value ``MethodResource.MethodResponseProperty.ResponseModels``
             * @return {@code this}
             */
            public Builder withResponseModels(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._responseModels = value;
                return this;
            }
            /**
             * Sets the value of ResponseModels
             * @param value ``MethodResource.MethodResponseProperty.ResponseModels``
             * @return {@code this}
             */
            public Builder withResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseModels = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @return {@code this}
             */
            public Builder withResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this._responseParameters = value;
                return this;
            }
            /**
             * Sets the value of ResponseParameters
             * @param value ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @return {@code this}
             */
            public Builder withResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this._responseParameters = value;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            public MethodResponseProperty build() {
                return new MethodResponseProperty() {
                    private java.lang.Object $statusCode = java.util.Objects.requireNonNull(_statusCode, "statusCode is required");
                    @javax.annotation.Nullable
                    private java.lang.Object $responseModels = _responseModels;
                    @javax.annotation.Nullable
                    private java.lang.Object $responseParameters = _responseParameters;

                    @Override
                    public java.lang.Object getStatusCode() {
                        return this.$statusCode;
                    }

                    @Override
                    public void setStatusCode(final java.lang.String value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public void setStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                        this.$statusCode = java.util.Objects.requireNonNull(value, "statusCode is required");
                    }

                    @Override
                    public java.lang.Object getResponseModels() {
                        return this.$responseModels;
                    }

                    @Override
                    public void setResponseModels(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$responseModels = value;
                    }

                    @Override
                    public void setResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$responseModels = value;
                    }

                    @Override
                    public java.lang.Object getResponseParameters() {
                        return this.$responseParameters;
                    }

                    @Override
                    public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                        this.$responseParameters = value;
                    }

                    @Override
                    public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                        this.$responseParameters = value;
                    }

                };
            }
        }

        /**
         * A proxy class which for javascript object literal which adhere to this interface.
         */
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.cloudformation.MethodResource.MethodResponseProperty {
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
                super(mode);
            }

            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            @Override
            public java.lang.Object getStatusCode() {
                return this.jsiiGet("statusCode", java.lang.Object.class);
            }

            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            @Override
            public void setStatusCode(final java.lang.String value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``MethodResource.MethodResponseProperty.StatusCode``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
             */
            @Override
            public void setStatusCode(final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("statusCode", java.util.Objects.requireNonNull(value, "statusCode is required"));
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResponseModels() {
                return this.jsiiGet("responseModels", java.lang.Object.class);
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            @Override
            public void setResponseModels(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("responseModels", value);
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseModels``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
             */
            @Override
            public void setResponseModels(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseModels", value);
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            @Override
            @javax.annotation.Nullable
            public java.lang.Object getResponseParameters() {
                return this.jsiiGet("responseParameters", java.lang.Object.class);
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            @Override
            public void setResponseParameters(@javax.annotation.Nullable final software.amazon.awscdk.CloudFormationToken value) {
                this.jsiiSet("responseParameters", value);
            }

            /**
             * ``MethodResource.MethodResponseProperty.ResponseParameters``
             * @link http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
             */
            @Override
            public void setResponseParameters(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.Object> value) {
                this.jsiiSet("responseParameters", value);
            }
        }
    }
}
