package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:19:33.721Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DomainNameProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.DomainNameOptions {
    /**
     * If specified, all requests to this domain will be mapped to the production deployment of this API.
     * 
     * If you wish to map this domain to multiple APIs
     * with different base paths, don't specify this option and use
     * `addBasePathMapping`.
     * 
     * Default: - you will have to call `addBasePathMapping` to map this domain to
     * API endpoints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IRestApi getMapping();

    /**
     * @return a {@link Builder} of {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link DomainNameProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.IRestApi _mapping;
        private software.amazon.awscdk.services.certificatemanager.ICertificate _certificate;
        private java.lang.String _domainName;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.EndpointType _endpointType;

        /**
         * Sets the value of Mapping
         * @param value If specified, all requests to this domain will be mapped to the production deployment of this API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMapping(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.IRestApi value) {
            this._mapping = value;
            return this;
        }
        /**
         * Sets the value of Certificate
         * @param value The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCertificate(final software.amazon.awscdk.services.certificatemanager.ICertificate value) {
            this._certificate = java.util.Objects.requireNonNull(value, "certificate is required");
            return this;
        }
        /**
         * Sets the value of DomainName
         * @param value The custom domain name for your API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDomainName(final java.lang.String value) {
            this._domainName = java.util.Objects.requireNonNull(value, "domainName is required");
            return this;
        }
        /**
         * Sets the value of EndpointType
         * @param value The type of endpoint for this DomainName.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withEndpointType(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.EndpointType value) {
            this._endpointType = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DomainNameProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public DomainNameProps build() {
            return new DomainNameProps() {
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.IRestApi $mapping = _mapping;
                private final software.amazon.awscdk.services.certificatemanager.ICertificate $certificate = java.util.Objects.requireNonNull(_certificate, "certificate is required");
                private final java.lang.String $domainName = java.util.Objects.requireNonNull(_domainName, "domainName is required");
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.EndpointType $endpointType = _endpointType;

                @Override
                public software.amazon.awscdk.services.apigateway.IRestApi getMapping() {
                    return this.$mapping;
                }

                @Override
                public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
                    return this.$certificate;
                }

                @Override
                public java.lang.String getDomainName() {
                    return this.$domainName;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
                    return this.$endpointType;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    if (this.getMapping() != null) {
                        obj.set("mapping", om.valueToTree(this.getMapping()));
                    }
                    obj.set("certificate", om.valueToTree(this.getCertificate()));
                    obj.set("domainName", om.valueToTree(this.getDomainName()));
                    if (this.getEndpointType() != null) {
                        obj.set("endpointType", om.valueToTree(this.getEndpointType()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.DomainNameProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * If specified, all requests to this domain will be mapped to the production deployment of this API.
         * 
         * If you wish to map this domain to multiple APIs
         * with different base paths, don't specify this option and use
         * `addBasePathMapping`.
         * 
         * Default: - you will have to call `addBasePathMapping` to map this domain to
         * API endpoints.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.IRestApi getMapping() {
            return this.jsiiGet("mapping", software.amazon.awscdk.services.apigateway.IRestApi.class);
        }

        /**
         * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
         * 
         * For "EDGE" domain names, the certificate
         * needs to be in the US East (N. Virginia) region.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.certificatemanager.ICertificate getCertificate() {
            return this.jsiiGet("certificate", software.amazon.awscdk.services.certificatemanager.ICertificate.class);
        }

        /**
         * The custom domain name for your API.
         * 
         * Uppercase letters are not supported.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public java.lang.String getDomainName() {
            return this.jsiiGet("domainName", java.lang.String.class);
        }

        /**
         * The type of endpoint for this DomainName.
         * 
         * Default: REGIONAL
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.EndpointType getEndpointType() {
            return this.jsiiGet("endpointType", software.amazon.awscdk.services.apigateway.EndpointType.class);
        }
    }
}
