package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.14.0 (build a586a1a)", date = "2019-07-11T14:19:33.747Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface StageProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.StageOptions {
    /**
     * The deployment that this stage points to [disable-awslint:ref-via-interface].
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.Deployment getDeployment();

    /**
     * @return a {@link Builder} of {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }

    /**
     * A builder for {@link StageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Builder {
        private software.amazon.awscdk.services.apigateway.Deployment _deployment;
        @javax.annotation.Nullable
        private java.lang.Boolean _cacheClusterEnabled;
        @javax.annotation.Nullable
        private java.lang.String _cacheClusterSize;
        @javax.annotation.Nullable
        private java.lang.String _clientCertificateId;
        @javax.annotation.Nullable
        private java.lang.String _description;
        @javax.annotation.Nullable
        private java.lang.String _documentationVersion;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> _methodOptions;
        @javax.annotation.Nullable
        private java.lang.String _stageName;
        @javax.annotation.Nullable
        private java.lang.Boolean _tracingEnabled;
        @javax.annotation.Nullable
        private java.util.Map<java.lang.String, java.lang.String> _variables;
        @javax.annotation.Nullable
        private java.lang.Boolean _cacheDataEncrypted;
        @javax.annotation.Nullable
        private software.amazon.awscdk.core.Duration _cacheTtl;
        @javax.annotation.Nullable
        private java.lang.Boolean _cachingEnabled;
        @javax.annotation.Nullable
        private java.lang.Boolean _dataTraceEnabled;
        @javax.annotation.Nullable
        private software.amazon.awscdk.services.apigateway.MethodLoggingLevel _loggingLevel;
        @javax.annotation.Nullable
        private java.lang.Boolean _metricsEnabled;
        @javax.annotation.Nullable
        private java.lang.Number _throttlingBurstLimit;
        @javax.annotation.Nullable
        private java.lang.Number _throttlingRateLimit;

        /**
         * Sets the value of Deployment
         * @param value The deployment that this stage points to [disable-awslint:ref-via-interface].
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDeployment(final software.amazon.awscdk.services.apigateway.Deployment value) {
            this._deployment = java.util.Objects.requireNonNull(value, "deployment is required");
            return this;
        }
        /**
         * Sets the value of CacheClusterEnabled
         * @param value Indicates whether cache clustering is enabled for the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheClusterEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cacheClusterEnabled = value;
            return this;
        }
        /**
         * Sets the value of CacheClusterSize
         * @param value The stage's cache cluster size.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheClusterSize(@javax.annotation.Nullable final java.lang.String value) {
            this._cacheClusterSize = value;
            return this;
        }
        /**
         * Sets the value of ClientCertificateId
         * @param value The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withClientCertificateId(@javax.annotation.Nullable final java.lang.String value) {
            this._clientCertificateId = value;
            return this;
        }
        /**
         * Sets the value of Description
         * @param value A description of the purpose of the stage.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDescription(@javax.annotation.Nullable final java.lang.String value) {
            this._description = value;
            return this;
        }
        /**
         * Sets the value of DocumentationVersion
         * @param value The version identifier of the API documentation snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDocumentationVersion(@javax.annotation.Nullable final java.lang.String value) {
            this._documentationVersion = value;
            return this;
        }
        /**
         * Sets the value of MethodOptions
         * @param value Method deployment options for specific resources/methods.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMethodOptions(@javax.annotation.Nullable final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> value) {
            this._methodOptions = value;
            return this;
        }
        /**
         * Sets the value of StageName
         * @param value The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withStageName(@javax.annotation.Nullable final java.lang.String value) {
            this._stageName = value;
            return this;
        }
        /**
         * Sets the value of TracingEnabled
         * @param value Specifies whether Amazon X-Ray tracing is enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withTracingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._tracingEnabled = value;
            return this;
        }
        /**
         * Sets the value of Variables
         * @param value A map that defines the stage variables.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withVariables(@javax.annotation.Nullable final java.util.Map<java.lang.String, java.lang.String> value) {
            this._variables = value;
            return this;
        }
        /**
         * Sets the value of CacheDataEncrypted
         * @param value Indicates whether the cached responses are encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheDataEncrypted(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cacheDataEncrypted = value;
            return this;
        }
        /**
         * Sets the value of CacheTtl
         * @param value Specifies the time to live (TTL), in seconds, for cached responses.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCacheTtl(@javax.annotation.Nullable final software.amazon.awscdk.core.Duration value) {
            this._cacheTtl = value;
            return this;
        }
        /**
         * Sets the value of CachingEnabled
         * @param value Specifies whether responses should be cached and returned for requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withCachingEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._cachingEnabled = value;
            return this;
        }
        /**
         * Sets the value of DataTraceEnabled
         * @param value Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withDataTraceEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._dataTraceEnabled = value;
            return this;
        }
        /**
         * Sets the value of LoggingLevel
         * @param value Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withLoggingLevel(@javax.annotation.Nullable final software.amazon.awscdk.services.apigateway.MethodLoggingLevel value) {
            this._loggingLevel = value;
            return this;
        }
        /**
         * Sets the value of MetricsEnabled
         * @param value Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withMetricsEnabled(@javax.annotation.Nullable final java.lang.Boolean value) {
            this._metricsEnabled = value;
            return this;
        }
        /**
         * Sets the value of ThrottlingBurstLimit
         * @param value Specifies the throttling burst limit. The total rate of all requests in your AWS account is limited to 5,000 requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withThrottlingBurstLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._throttlingBurstLimit = value;
            return this;
        }
        /**
         * Sets the value of ThrottlingRateLimit
         * @param value Specifies the throttling rate limit. The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder withThrottlingRateLimit(@javax.annotation.Nullable final java.lang.Number value) {
            this._throttlingRateLimit = value;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link StageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public StageProps build() {
            return new StageProps() {
                private final software.amazon.awscdk.services.apigateway.Deployment $deployment = java.util.Objects.requireNonNull(_deployment, "deployment is required");
                @javax.annotation.Nullable
                private final java.lang.Boolean $cacheClusterEnabled = _cacheClusterEnabled;
                @javax.annotation.Nullable
                private final java.lang.String $cacheClusterSize = _cacheClusterSize;
                @javax.annotation.Nullable
                private final java.lang.String $clientCertificateId = _clientCertificateId;
                @javax.annotation.Nullable
                private final java.lang.String $description = _description;
                @javax.annotation.Nullable
                private final java.lang.String $documentationVersion = _documentationVersion;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> $methodOptions = _methodOptions;
                @javax.annotation.Nullable
                private final java.lang.String $stageName = _stageName;
                @javax.annotation.Nullable
                private final java.lang.Boolean $tracingEnabled = _tracingEnabled;
                @javax.annotation.Nullable
                private final java.util.Map<java.lang.String, java.lang.String> $variables = _variables;
                @javax.annotation.Nullable
                private final java.lang.Boolean $cacheDataEncrypted = _cacheDataEncrypted;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.core.Duration $cacheTtl = _cacheTtl;
                @javax.annotation.Nullable
                private final java.lang.Boolean $cachingEnabled = _cachingEnabled;
                @javax.annotation.Nullable
                private final java.lang.Boolean $dataTraceEnabled = _dataTraceEnabled;
                @javax.annotation.Nullable
                private final software.amazon.awscdk.services.apigateway.MethodLoggingLevel $loggingLevel = _loggingLevel;
                @javax.annotation.Nullable
                private final java.lang.Boolean $metricsEnabled = _metricsEnabled;
                @javax.annotation.Nullable
                private final java.lang.Number $throttlingBurstLimit = _throttlingBurstLimit;
                @javax.annotation.Nullable
                private final java.lang.Number $throttlingRateLimit = _throttlingRateLimit;

                @Override
                public software.amazon.awscdk.services.apigateway.Deployment getDeployment() {
                    return this.$deployment;
                }

                @Override
                public java.lang.Boolean getCacheClusterEnabled() {
                    return this.$cacheClusterEnabled;
                }

                @Override
                public java.lang.String getCacheClusterSize() {
                    return this.$cacheClusterSize;
                }

                @Override
                public java.lang.String getClientCertificateId() {
                    return this.$clientCertificateId;
                }

                @Override
                public java.lang.String getDescription() {
                    return this.$description;
                }

                @Override
                public java.lang.String getDocumentationVersion() {
                    return this.$documentationVersion;
                }

                @Override
                public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
                    return this.$methodOptions;
                }

                @Override
                public java.lang.String getStageName() {
                    return this.$stageName;
                }

                @Override
                public java.lang.Boolean getTracingEnabled() {
                    return this.$tracingEnabled;
                }

                @Override
                public java.util.Map<java.lang.String, java.lang.String> getVariables() {
                    return this.$variables;
                }

                @Override
                public java.lang.Boolean getCacheDataEncrypted() {
                    return this.$cacheDataEncrypted;
                }

                @Override
                public software.amazon.awscdk.core.Duration getCacheTtl() {
                    return this.$cacheTtl;
                }

                @Override
                public java.lang.Boolean getCachingEnabled() {
                    return this.$cachingEnabled;
                }

                @Override
                public java.lang.Boolean getDataTraceEnabled() {
                    return this.$dataTraceEnabled;
                }

                @Override
                public software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
                    return this.$loggingLevel;
                }

                @Override
                public java.lang.Boolean getMetricsEnabled() {
                    return this.$metricsEnabled;
                }

                @Override
                public java.lang.Number getThrottlingBurstLimit() {
                    return this.$throttlingBurstLimit;
                }

                @Override
                public java.lang.Number getThrottlingRateLimit() {
                    return this.$throttlingRateLimit;
                }

                public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                    com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                    com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                    obj.set("deployment", om.valueToTree(this.getDeployment()));
                    if (this.getCacheClusterEnabled() != null) {
                        obj.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
                    }
                    if (this.getCacheClusterSize() != null) {
                        obj.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
                    }
                    if (this.getClientCertificateId() != null) {
                        obj.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree(this.getDescription()));
                    }
                    if (this.getDocumentationVersion() != null) {
                        obj.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
                    }
                    if (this.getMethodOptions() != null) {
                        obj.set("methodOptions", om.valueToTree(this.getMethodOptions()));
                    }
                    if (this.getStageName() != null) {
                        obj.set("stageName", om.valueToTree(this.getStageName()));
                    }
                    if (this.getTracingEnabled() != null) {
                        obj.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
                    }
                    if (this.getVariables() != null) {
                        obj.set("variables", om.valueToTree(this.getVariables()));
                    }
                    if (this.getCacheDataEncrypted() != null) {
                        obj.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
                    }
                    if (this.getCacheTtl() != null) {
                        obj.set("cacheTtl", om.valueToTree(this.getCacheTtl()));
                    }
                    if (this.getCachingEnabled() != null) {
                        obj.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
                    }
                    if (this.getDataTraceEnabled() != null) {
                        obj.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
                    }
                    if (this.getLoggingLevel() != null) {
                        obj.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
                    }
                    if (this.getMetricsEnabled() != null) {
                        obj.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
                    }
                    if (this.getThrottlingBurstLimit() != null) {
                        obj.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
                    }
                    if (this.getThrottlingRateLimit() != null) {
                        obj.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
                    }
                    return obj;
                }

            };
        }
    }

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    final static class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigateway.StageProps {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObject.InitializationMode mode) {
            super(mode);
        }

        /**
         * The deployment that this stage points to [disable-awslint:ref-via-interface].
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public software.amazon.awscdk.services.apigateway.Deployment getDeployment() {
            return this.jsiiGet("deployment", software.amazon.awscdk.services.apigateway.Deployment.class);
        }

        /**
         * Indicates whether cache clustering is enabled for the stage.
         * 
         * Default: - Disabled for the stage.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getCacheClusterEnabled() {
            return this.jsiiGet("cacheClusterEnabled", java.lang.Boolean.class);
        }

        /**
         * The stage's cache cluster size.
         * 
         * Default: 0.5
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getCacheClusterSize() {
            return this.jsiiGet("cacheClusterSize", java.lang.String.class);
        }

        /**
         * The identifier of the client certificate that API Gateway uses to call your integration endpoints in the stage.
         * 
         * Default: - None.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getClientCertificateId() {
            return this.jsiiGet("clientCertificateId", java.lang.String.class);
        }

        /**
         * A description of the purpose of the stage.
         * 
         * Default: - No description.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDescription() {
            return this.jsiiGet("description", java.lang.String.class);
        }

        /**
         * The version identifier of the API documentation snapshot.
         * 
         * Default: - No documentation version.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getDocumentationVersion() {
            return this.jsiiGet("documentationVersion", java.lang.String.class);
        }

        /**
         * Method deployment options for specific resources/methods.
         * 
         * These will
         * override common options defined in `StageOptions#methodOptions`.
         * 
         * Default: - Common options will be used.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.MethodDeploymentOptions> getMethodOptions() {
            return this.jsiiGet("methodOptions", java.util.Map.class);
        }

        /**
         * The name of the stage, which API Gateway uses as the first path segment in the invoked Uniform Resource Identifier (URI).
         * 
         * Default: - "prod"
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.String getStageName() {
            return this.jsiiGet("stageName", java.lang.String.class);
        }

        /**
         * Specifies whether Amazon X-Ray tracing is enabled for this method.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getTracingEnabled() {
            return this.jsiiGet("tracingEnabled", java.lang.Boolean.class);
        }

        /**
         * A map that defines the stage variables.
         * 
         * Variable names must consist of
         * alphanumeric characters, and the values must match the following regular
         * expression: [A-Za-z0-9-._~:/?#&amp;=,]+.
         * 
         * Default: - No stage variables.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.util.Map<java.lang.String, java.lang.String> getVariables() {
            return this.jsiiGet("variables", java.util.Map.class);
        }

        /**
         * Indicates whether the cached responses are encrypted.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getCacheDataEncrypted() {
            return this.jsiiGet("cacheDataEncrypted", java.lang.Boolean.class);
        }

        /**
         * Specifies the time to live (TTL), in seconds, for cached responses.
         * 
         * The
         * higher the TTL, the longer the response will be cached.
         * 
         * Default: Duration.minutes(5)
         * 
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.core.Duration getCacheTtl() {
            return this.jsiiGet("cacheTtl", software.amazon.awscdk.core.Duration.class);
        }

        /**
         * Specifies whether responses should be cached and returned for requests.
         * 
         * A
         * cache cluster must be enabled on the stage for responses to be cached.
         * 
         * Default: - Caching is Disabled.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getCachingEnabled() {
            return this.jsiiGet("cachingEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getDataTraceEnabled() {
            return this.jsiiGet("dataTraceEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * 
         * Default: - Off
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
            return this.jsiiGet("loggingLevel", software.amazon.awscdk.services.apigateway.MethodLoggingLevel.class);
        }

        /**
         * Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * 
         * Default: false
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Boolean getMetricsEnabled() {
            return this.jsiiGet("metricsEnabled", java.lang.Boolean.class);
        }

        /**
         * Specifies the throttling burst limit. The total rate of all requests in your AWS account is limited to 5,000 requests.
         * 
         * Default: - No additional restriction.
         * 
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getThrottlingBurstLimit() {
            return this.jsiiGet("throttlingBurstLimit", java.lang.Number.class);
        }

        /**
         * Specifies the throttling rate limit. The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
         * 
         * Default: - No additional restriction.
         * 
         * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @javax.annotation.Nullable
        public java.lang.Number getThrottlingRateLimit() {
            return this.jsiiGet("throttlingRateLimit", java.lang.Number.class);
        }
    }
}
