/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Objects;
import javax.annotation.Nullable;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.apigateway.CfnStageV2;
import software.amazon.jsii.JsiiObjectMapper;
import software.amazon.jsii.JsiiSerializable;

public interface CfnStageV2Props
extends JsiiSerializable {
    public String getApiId();

    public String getDeploymentId();

    public String getStageName();

    public Object getAccessLogSettings();

    public String getClientCertificateId();

    public Object getDefaultRouteSettings();

    public String getDescription();

    public Object getRouteSettings();

    public Object getStageVariables();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String _apiId;
        private String _deploymentId;
        private String _stageName;
        @Nullable
        private Object _accessLogSettings;
        @Nullable
        private String _clientCertificateId;
        @Nullable
        private Object _defaultRouteSettings;
        @Nullable
        private String _description;
        @Nullable
        private Object _routeSettings;
        @Nullable
        private Object _stageVariables;

        public Builder withApiId(String value) {
            this._apiId = Objects.requireNonNull(value, "apiId is required");
            return this;
        }

        public Builder withDeploymentId(String value) {
            this._deploymentId = Objects.requireNonNull(value, "deploymentId is required");
            return this;
        }

        public Builder withStageName(String value) {
            this._stageName = Objects.requireNonNull(value, "stageName is required");
            return this;
        }

        public Builder withAccessLogSettings(@Nullable IResolvable value) {
            this._accessLogSettings = value;
            return this;
        }

        public Builder withAccessLogSettings(@Nullable CfnStageV2.AccessLogSettingsProperty value) {
            this._accessLogSettings = value;
            return this;
        }

        public Builder withClientCertificateId(@Nullable String value) {
            this._clientCertificateId = value;
            return this;
        }

        public Builder withDefaultRouteSettings(@Nullable IResolvable value) {
            this._defaultRouteSettings = value;
            return this;
        }

        public Builder withDefaultRouteSettings(@Nullable CfnStageV2.RouteSettingsProperty value) {
            this._defaultRouteSettings = value;
            return this;
        }

        public Builder withDescription(@Nullable String value) {
            this._description = value;
            return this;
        }

        public Builder withRouteSettings(@Nullable Object value) {
            this._routeSettings = value;
            return this;
        }

        public Builder withStageVariables(@Nullable Object value) {
            this._stageVariables = value;
            return this;
        }

        public CfnStageV2Props build() {
            return new CfnStageV2Props(){
                private final String $apiId;
                private final String $deploymentId;
                private final String $stageName;
                @Nullable
                private final Object $accessLogSettings;
                @Nullable
                private final String $clientCertificateId;
                @Nullable
                private final Object $defaultRouteSettings;
                @Nullable
                private final String $description;
                @Nullable
                private final Object $routeSettings;
                @Nullable
                private final Object $stageVariables;
                {
                    this.$apiId = Objects.requireNonNull(_apiId, "apiId is required");
                    this.$deploymentId = Objects.requireNonNull(_deploymentId, "deploymentId is required");
                    this.$stageName = Objects.requireNonNull(_stageName, "stageName is required");
                    this.$accessLogSettings = _accessLogSettings;
                    this.$clientCertificateId = _clientCertificateId;
                    this.$defaultRouteSettings = _defaultRouteSettings;
                    this.$description = _description;
                    this.$routeSettings = _routeSettings;
                    this.$stageVariables = _stageVariables;
                }

                @Override
                public String getApiId() {
                    return this.$apiId;
                }

                @Override
                public String getDeploymentId() {
                    return this.$deploymentId;
                }

                @Override
                public String getStageName() {
                    return this.$stageName;
                }

                @Override
                public Object getAccessLogSettings() {
                    return this.$accessLogSettings;
                }

                @Override
                public String getClientCertificateId() {
                    return this.$clientCertificateId;
                }

                @Override
                public Object getDefaultRouteSettings() {
                    return this.$defaultRouteSettings;
                }

                @Override
                public String getDescription() {
                    return this.$description;
                }

                @Override
                public Object getRouteSettings() {
                    return this.$routeSettings;
                }

                @Override
                public Object getStageVariables() {
                    return this.$stageVariables;
                }

                public JsonNode $jsii$toJson() {
                    ObjectMapper om = JsiiObjectMapper.INSTANCE;
                    ObjectNode obj = JsonNodeFactory.instance.objectNode();
                    obj.set("apiId", om.valueToTree((Object)this.getApiId()));
                    obj.set("deploymentId", om.valueToTree((Object)this.getDeploymentId()));
                    obj.set("stageName", om.valueToTree((Object)this.getStageName()));
                    if (this.getAccessLogSettings() != null) {
                        obj.set("accessLogSettings", om.valueToTree(this.getAccessLogSettings()));
                    }
                    if (this.getClientCertificateId() != null) {
                        obj.set("clientCertificateId", om.valueToTree((Object)this.getClientCertificateId()));
                    }
                    if (this.getDefaultRouteSettings() != null) {
                        obj.set("defaultRouteSettings", om.valueToTree(this.getDefaultRouteSettings()));
                    }
                    if (this.getDescription() != null) {
                        obj.set("description", om.valueToTree((Object)this.getDescription()));
                    }
                    if (this.getRouteSettings() != null) {
                        obj.set("routeSettings", om.valueToTree(this.getRouteSettings()));
                    }
                    if (this.getStageVariables() != null) {
                        obj.set("stageVariables", om.valueToTree(this.getStageVariables()));
                    }
                    return obj;
                }
            };
        }
    }
}

