package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::BasePathMapping`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:39:26.057Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnBasePathMappingProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::BasePathMapping.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDomainName();

    /**
     * `AWS::ApiGateway::BasePathMapping.BasePath`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-basepath
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getBasePath();

    /**
     * `AWS::ApiGateway::BasePathMapping.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRestApiId();

    /**
     * `AWS::ApiGateway::BasePathMapping.Stage`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-basepathmapping.html#cfn-apigateway-basepathmapping-stage
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getStage();

    /**
     * @return a {@link Builder} of {@link CfnBasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String domainName;
        private java.lang.String basePath;
        private java.lang.String restApiId;
        private java.lang.String stage;

        /**
         * Sets the value of DomainName
         * @param domainName `AWS::ApiGateway::BasePathMapping.DomainName`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of BasePath
         * @param basePath `AWS::ApiGateway::BasePathMapping.BasePath`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder basePath(java.lang.String basePath) {
            this.basePath = basePath;
            return this;
        }

        /**
         * Sets the value of RestApiId
         * @param restApiId `AWS::ApiGateway::BasePathMapping.RestApiId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of Stage
         * @param stage `AWS::ApiGateway::BasePathMapping.Stage`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stage(java.lang.String stage) {
            this.stage = stage;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBasePathMappingProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnBasePathMappingProps build() {
            return new Jsii$Proxy(domainName, basePath, restApiId, stage);
        }
    }

    /**
     * An implementation for {@link CfnBasePathMappingProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBasePathMappingProps {
        private final java.lang.String domainName;
        private final java.lang.String basePath;
        private final java.lang.String restApiId;
        private final java.lang.String stage;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.domainName = this.jsiiGet("domainName", java.lang.String.class);
            this.basePath = this.jsiiGet("basePath", java.lang.String.class);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            this.stage = this.jsiiGet("stage", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String domainName, java.lang.String basePath, java.lang.String restApiId, java.lang.String stage) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.domainName = java.util.Objects.requireNonNull(domainName, "domainName is required");
            this.basePath = basePath;
            this.restApiId = restApiId;
            this.stage = stage;
        }

        @Override
        public java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public java.lang.String getBasePath() {
            return this.basePath;
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public java.lang.String getStage() {
            return this.stage;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("domainName", om.valueToTree(this.getDomainName()));
            if (this.getBasePath() != null) {
                obj.set("basePath", om.valueToTree(this.getBasePath()));
            }
            if (this.getRestApiId() != null) {
                obj.set("restApiId", om.valueToTree(this.getRestApiId()));
            }
            if (this.getStage() != null) {
                obj.set("stage", om.valueToTree(this.getStage()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBasePathMappingProps.Jsii$Proxy that = (CfnBasePathMappingProps.Jsii$Proxy) o;

            if (!domainName.equals(that.domainName)) return false;
            if (this.basePath != null ? !this.basePath.equals(that.basePath) : that.basePath != null) return false;
            if (this.restApiId != null ? !this.restApiId.equals(that.restApiId) : that.restApiId != null) return false;
            return this.stage != null ? this.stage.equals(that.stage) : that.stage == null;
        }

        @Override
        public int hashCode() {
            int result = this.domainName.hashCode();
            result = 31 * result + (this.basePath != null ? this.basePath.hashCode() : 0);
            result = 31 * result + (this.restApiId != null ? this.restApiId.hashCode() : 0);
            result = 31 * result + (this.stage != null ? this.stage.hashCode() : 0);
            return result;
        }
    }
}
