package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::Deployment`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:39:26.063Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnDeploymentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::Deployment.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRestApiId();

    /**
     * `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-deploymentcanarysettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getDeploymentCanarySettings();

    /**
     * `AWS::ApiGateway::Deployment.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::ApiGateway::Deployment.StageDescription`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagedescription
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getStageDescription();

    /**
     * `AWS::ApiGateway::Deployment.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-deployment.html#cfn-apigateway-deployment-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getStageName();

    /**
     * @return a {@link Builder} of {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String restApiId;
        private java.lang.Object deploymentCanarySettings;
        private java.lang.String description;
        private java.lang.Object stageDescription;
        private java.lang.String stageName;

        /**
         * Sets the value of RestApiId
         * @param restApiId `AWS::ApiGateway::Deployment.RestApiId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of DeploymentCanarySettings
         * @param deploymentCanarySettings `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deploymentCanarySettings(software.amazon.awscdk.core.IResolvable deploymentCanarySettings) {
            this.deploymentCanarySettings = deploymentCanarySettings;
            return this;
        }

        /**
         * Sets the value of DeploymentCanarySettings
         * @param deploymentCanarySettings `AWS::ApiGateway::Deployment.DeploymentCanarySettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deploymentCanarySettings(software.amazon.awscdk.services.apigateway.CfnDeployment.DeploymentCanarySettingsProperty deploymentCanarySettings) {
            this.deploymentCanarySettings = deploymentCanarySettings;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ApiGateway::Deployment.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of StageDescription
         * @param stageDescription `AWS::ApiGateway::Deployment.StageDescription`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageDescription(software.amazon.awscdk.core.IResolvable stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        /**
         * Sets the value of StageDescription
         * @param stageDescription `AWS::ApiGateway::Deployment.StageDescription`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageDescription(software.amazon.awscdk.services.apigateway.CfnDeployment.StageDescriptionProperty stageDescription) {
            this.stageDescription = stageDescription;
            return this;
        }

        /**
         * Sets the value of StageName
         * @param stageName `AWS::ApiGateway::Deployment.StageName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDeploymentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnDeploymentProps build() {
            return new Jsii$Proxy(restApiId, deploymentCanarySettings, description, stageDescription, stageName);
        }
    }

    /**
     * An implementation for {@link CfnDeploymentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDeploymentProps {
        private final java.lang.String restApiId;
        private final java.lang.Object deploymentCanarySettings;
        private final java.lang.String description;
        private final java.lang.Object stageDescription;
        private final java.lang.String stageName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            this.deploymentCanarySettings = this.jsiiGet("deploymentCanarySettings", java.lang.Object.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.stageDescription = this.jsiiGet("stageDescription", java.lang.Object.class);
            this.stageName = this.jsiiGet("stageName", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String restApiId, java.lang.Object deploymentCanarySettings, java.lang.String description, java.lang.Object stageDescription, java.lang.String stageName) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(restApiId, "restApiId is required");
            this.deploymentCanarySettings = deploymentCanarySettings;
            this.description = description;
            this.stageDescription = stageDescription;
            this.stageName = stageName;
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public java.lang.Object getDeploymentCanarySettings() {
            return this.deploymentCanarySettings;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.Object getStageDescription() {
            return this.stageDescription;
        }

        @Override
        public java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getDeploymentCanarySettings() != null) {
                obj.set("deploymentCanarySettings", om.valueToTree(this.getDeploymentCanarySettings()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getStageDescription() != null) {
                obj.set("stageDescription", om.valueToTree(this.getStageDescription()));
            }
            if (this.getStageName() != null) {
                obj.set("stageName", om.valueToTree(this.getStageName()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDeploymentProps.Jsii$Proxy that = (CfnDeploymentProps.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            if (this.deploymentCanarySettings != null ? !this.deploymentCanarySettings.equals(that.deploymentCanarySettings) : that.deploymentCanarySettings != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.stageDescription != null ? !this.stageDescription.equals(that.stageDescription) : that.stageDescription != null) return false;
            return this.stageName != null ? this.stageName.equals(that.stageName) : that.stageName == null;
        }

        @Override
        public int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.deploymentCanarySettings != null ? this.deploymentCanarySettings.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.stageDescription != null ? this.stageDescription.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            return result;
        }
    }
}
