package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::Method`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-09-30T08:39:26.071Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnMethod")
public class CfnMethod extends software.amazon.awscdk.core.CfnResource {

    protected CfnMethod(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnMethod(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnMethod.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGateway::Method`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnMethod(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnMethodProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getHttpMethod() {
        return this.jsiiGet("httpMethod", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.HttpMethod`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-httpmethod
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setHttpMethod(final java.lang.String value) {
        this.jsiiSet("httpMethod", java.util.Objects.requireNonNull(value, "httpMethod is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getResourceId() {
        return this.jsiiGet("resourceId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.ResourceId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-resourceid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setResourceId(final java.lang.String value) {
        this.jsiiSet("resourceId", java.util.Objects.requireNonNull(value, "resourceId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRestApiId() {
        return this.jsiiGet("restApiId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRestApiId(final java.lang.String value) {
        this.jsiiSet("restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getApiKeyRequired() {
        return this.jsiiGet("apiKeyRequired", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(final java.lang.Boolean value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.ApiKeyRequired`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-apikeyrequired
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setApiKeyRequired(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("apiKeyRequired", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.util.List<java.lang.String> getAuthorizationScopes() {
        return java.util.Collections.unmodifiableList(this.jsiiGet("authorizationScopes", java.util.List.class));
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationScopes`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationscopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationScopes(final java.util.List<java.lang.String> value) {
        this.jsiiSet("authorizationScopes", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAuthorizationType() {
        return this.jsiiGet("authorizationType", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizationType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizationtype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizationType(final java.lang.String value) {
        this.jsiiSet("authorizationType", value);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAuthorizerId() {
        return this.jsiiGet("authorizerId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.AuthorizerId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-authorizerid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setAuthorizerId(final java.lang.String value) {
        this.jsiiSet("authorizerId", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getIntegration() {
        return this.jsiiGet("integration", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.Integration`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-integration
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setIntegration(final software.amazon.awscdk.services.apigateway.CfnMethod.IntegrationProperty value) {
        this.jsiiSet("integration", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getMethodResponses() {
        return this.jsiiGet("methodResponses", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.MethodResponses`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-methodresponses
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setMethodResponses(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("methodResponses", value);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getOperationName() {
        return this.jsiiGet("operationName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.OperationName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-operationname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setOperationName(final java.lang.String value) {
        this.jsiiSet("operationName", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRequestModels() {
        return this.jsiiGet("requestModels", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestModels`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestmodels
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestModels(final java.util.Map<java.lang.String, java.lang.String> value) {
        this.jsiiSet("requestModels", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getRequestParameters() {
        return this.jsiiGet("requestParameters", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestParameters(final java.util.Map<java.lang.String, java.lang.Object> value) {
        this.jsiiSet("requestParameters", value);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getRequestValidatorId() {
        return this.jsiiGet("requestValidatorId", java.lang.String.class);
    }

    /**
     * `AWS::ApiGateway::Method.RequestValidatorId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-method.html#cfn-apigateway-method-requestvalidatorid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setRequestValidatorId(final java.lang.String value) {
        this.jsiiSet("requestValidatorId", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.IntegrationProperty.CacheKeyParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachekeyparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.util.List<java.lang.String> getCacheKeyParameters();

        /**
         * `CfnMethod.IntegrationProperty.CacheNamespace`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-cachenamespace
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCacheNamespace();

        /**
         * `CfnMethod.IntegrationProperty.ConnectionId`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectionid
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConnectionId();

        /**
         * `CfnMethod.IntegrationProperty.ConnectionType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-connectiontype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getConnectionType();

        /**
         * `CfnMethod.IntegrationProperty.ContentHandling`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getContentHandling();

        /**
         * `CfnMethod.IntegrationProperty.Credentials`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-credentials
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCredentials();

        /**
         * `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationhttpmethod
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getIntegrationHttpMethod();

        /**
         * `CfnMethod.IntegrationProperty.IntegrationResponses`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-integrationresponses
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getIntegrationResponses();

        /**
         * `CfnMethod.IntegrationProperty.PassthroughBehavior`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-passthroughbehavior
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getPassthroughBehavior();

        /**
         * `CfnMethod.IntegrationProperty.RequestParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requestparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRequestParameters();

        /**
         * `CfnMethod.IntegrationProperty.RequestTemplates`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-requesttemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getRequestTemplates();

        /**
         * `CfnMethod.IntegrationProperty.TimeoutInMillis`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-timeoutinmillis
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Number getTimeoutInMillis();

        /**
         * `CfnMethod.IntegrationProperty.Type`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-type
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getType();

        /**
         * `CfnMethod.IntegrationProperty.Uri`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration.html#cfn-apigateway-method-integration-uri
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getUri();

        /**
         * @return a {@link Builder} of {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.util.List<java.lang.String> cacheKeyParameters;
            private java.lang.String cacheNamespace;
            private java.lang.String connectionId;
            private java.lang.String connectionType;
            private java.lang.String contentHandling;
            private java.lang.String credentials;
            private java.lang.String integrationHttpMethod;
            private java.lang.Object integrationResponses;
            private java.lang.String passthroughBehavior;
            private java.lang.Object requestParameters;
            private java.lang.Object requestTemplates;
            private java.lang.Number timeoutInMillis;
            private java.lang.String type;
            private java.lang.String uri;

            /**
             * Sets the value of CacheKeyParameters
             * @param cacheKeyParameters `CfnMethod.IntegrationProperty.CacheKeyParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheKeyParameters(java.util.List<java.lang.String> cacheKeyParameters) {
                this.cacheKeyParameters = cacheKeyParameters;
                return this;
            }

            /**
             * Sets the value of CacheNamespace
             * @param cacheNamespace `CfnMethod.IntegrationProperty.CacheNamespace`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder cacheNamespace(java.lang.String cacheNamespace) {
                this.cacheNamespace = cacheNamespace;
                return this;
            }

            /**
             * Sets the value of ConnectionId
             * @param connectionId `CfnMethod.IntegrationProperty.ConnectionId`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder connectionId(java.lang.String connectionId) {
                this.connectionId = connectionId;
                return this;
            }

            /**
             * Sets the value of ConnectionType
             * @param connectionType `CfnMethod.IntegrationProperty.ConnectionType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder connectionType(java.lang.String connectionType) {
                this.connectionType = connectionType;
                return this;
            }

            /**
             * Sets the value of ContentHandling
             * @param contentHandling `CfnMethod.IntegrationProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of Credentials
             * @param credentials `CfnMethod.IntegrationProperty.Credentials`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder credentials(java.lang.String credentials) {
                this.credentials = credentials;
                return this;
            }

            /**
             * Sets the value of IntegrationHttpMethod
             * @param integrationHttpMethod `CfnMethod.IntegrationProperty.IntegrationHttpMethod`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
                this.integrationHttpMethod = integrationHttpMethod;
                return this;
            }

            /**
             * Sets the value of IntegrationResponses
             * @param integrationResponses `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationResponses(software.amazon.awscdk.core.IResolvable integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of IntegrationResponses
             * @param integrationResponses `CfnMethod.IntegrationProperty.IntegrationResponses`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder integrationResponses(java.util.List<java.lang.Object> integrationResponses) {
                this.integrationResponses = integrationResponses;
                return this;
            }

            /**
             * Sets the value of PassthroughBehavior
             * @param passthroughBehavior `CfnMethod.IntegrationProperty.PassthroughBehavior`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder passthroughBehavior(java.lang.String passthroughBehavior) {
                this.passthroughBehavior = passthroughBehavior;
                return this;
            }

            /**
             * Sets the value of RequestParameters
             * @param requestParameters `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestParameters(software.amazon.awscdk.core.IResolvable requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of RequestParameters
             * @param requestParameters `CfnMethod.IntegrationProperty.RequestParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestParameters(java.util.Map<java.lang.String, java.lang.String> requestParameters) {
                this.requestParameters = requestParameters;
                return this;
            }

            /**
             * Sets the value of RequestTemplates
             * @param requestTemplates `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestTemplates(software.amazon.awscdk.core.IResolvable requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of RequestTemplates
             * @param requestTemplates `CfnMethod.IntegrationProperty.RequestTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder requestTemplates(java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
                this.requestTemplates = requestTemplates;
                return this;
            }

            /**
             * Sets the value of TimeoutInMillis
             * @param timeoutInMillis `CfnMethod.IntegrationProperty.TimeoutInMillis`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder timeoutInMillis(java.lang.Number timeoutInMillis) {
                this.timeoutInMillis = timeoutInMillis;
                return this;
            }

            /**
             * Sets the value of Type
             * @param type `CfnMethod.IntegrationProperty.Type`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of Uri
             * @param uri `CfnMethod.IntegrationProperty.Uri`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder uri(java.lang.String uri) {
                this.uri = uri;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationProperty build() {
                return new Jsii$Proxy(cacheKeyParameters, cacheNamespace, connectionId, connectionType, contentHandling, credentials, integrationHttpMethod, integrationResponses, passthroughBehavior, requestParameters, requestTemplates, timeoutInMillis, type, uri);
            }
        }

        /**
         * An implementation for {@link IntegrationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProperty {
            private final java.util.List<java.lang.String> cacheKeyParameters;
            private final java.lang.String cacheNamespace;
            private final java.lang.String connectionId;
            private final java.lang.String connectionType;
            private final java.lang.String contentHandling;
            private final java.lang.String credentials;
            private final java.lang.String integrationHttpMethod;
            private final java.lang.Object integrationResponses;
            private final java.lang.String passthroughBehavior;
            private final java.lang.Object requestParameters;
            private final java.lang.Object requestTemplates;
            private final java.lang.Number timeoutInMillis;
            private final java.lang.String type;
            private final java.lang.String uri;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.cacheKeyParameters = this.jsiiGet("cacheKeyParameters", java.util.List.class);
                this.cacheNamespace = this.jsiiGet("cacheNamespace", java.lang.String.class);
                this.connectionId = this.jsiiGet("connectionId", java.lang.String.class);
                this.connectionType = this.jsiiGet("connectionType", java.lang.String.class);
                this.contentHandling = this.jsiiGet("contentHandling", java.lang.String.class);
                this.credentials = this.jsiiGet("credentials", java.lang.String.class);
                this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
                this.integrationResponses = this.jsiiGet("integrationResponses", java.lang.Object.class);
                this.passthroughBehavior = this.jsiiGet("passthroughBehavior", java.lang.String.class);
                this.requestParameters = this.jsiiGet("requestParameters", java.lang.Object.class);
                this.requestTemplates = this.jsiiGet("requestTemplates", java.lang.Object.class);
                this.timeoutInMillis = this.jsiiGet("timeoutInMillis", java.lang.Number.class);
                this.type = this.jsiiGet("type", java.lang.String.class);
                this.uri = this.jsiiGet("uri", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.util.List<java.lang.String> cacheKeyParameters, java.lang.String cacheNamespace, java.lang.String connectionId, java.lang.String connectionType, java.lang.String contentHandling, java.lang.String credentials, java.lang.String integrationHttpMethod, java.lang.Object integrationResponses, java.lang.String passthroughBehavior, java.lang.Object requestParameters, java.lang.Object requestTemplates, java.lang.Number timeoutInMillis, java.lang.String type, java.lang.String uri) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.cacheKeyParameters = cacheKeyParameters;
                this.cacheNamespace = cacheNamespace;
                this.connectionId = connectionId;
                this.connectionType = connectionType;
                this.contentHandling = contentHandling;
                this.credentials = credentials;
                this.integrationHttpMethod = integrationHttpMethod;
                this.integrationResponses = integrationResponses;
                this.passthroughBehavior = passthroughBehavior;
                this.requestParameters = requestParameters;
                this.requestTemplates = requestTemplates;
                this.timeoutInMillis = timeoutInMillis;
                this.type = type;
                this.uri = uri;
            }

            @Override
            public java.util.List<java.lang.String> getCacheKeyParameters() {
                return this.cacheKeyParameters;
            }

            @Override
            public java.lang.String getCacheNamespace() {
                return this.cacheNamespace;
            }

            @Override
            public java.lang.String getConnectionId() {
                return this.connectionId;
            }

            @Override
            public java.lang.String getConnectionType() {
                return this.connectionType;
            }

            @Override
            public java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public java.lang.String getCredentials() {
                return this.credentials;
            }

            @Override
            public java.lang.String getIntegrationHttpMethod() {
                return this.integrationHttpMethod;
            }

            @Override
            public java.lang.Object getIntegrationResponses() {
                return this.integrationResponses;
            }

            @Override
            public java.lang.String getPassthroughBehavior() {
                return this.passthroughBehavior;
            }

            @Override
            public java.lang.Object getRequestParameters() {
                return this.requestParameters;
            }

            @Override
            public java.lang.Object getRequestTemplates() {
                return this.requestTemplates;
            }

            @Override
            public java.lang.Number getTimeoutInMillis() {
                return this.timeoutInMillis;
            }

            @Override
            public java.lang.String getType() {
                return this.type;
            }

            @Override
            public java.lang.String getUri() {
                return this.uri;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCacheKeyParameters() != null) {
                    obj.set("cacheKeyParameters", om.valueToTree(this.getCacheKeyParameters()));
                }
                if (this.getCacheNamespace() != null) {
                    obj.set("cacheNamespace", om.valueToTree(this.getCacheNamespace()));
                }
                if (this.getConnectionId() != null) {
                    obj.set("connectionId", om.valueToTree(this.getConnectionId()));
                }
                if (this.getConnectionType() != null) {
                    obj.set("connectionType", om.valueToTree(this.getConnectionType()));
                }
                if (this.getContentHandling() != null) {
                    obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getCredentials() != null) {
                    obj.set("credentials", om.valueToTree(this.getCredentials()));
                }
                if (this.getIntegrationHttpMethod() != null) {
                    obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
                }
                if (this.getIntegrationResponses() != null) {
                    obj.set("integrationResponses", om.valueToTree(this.getIntegrationResponses()));
                }
                if (this.getPassthroughBehavior() != null) {
                    obj.set("passthroughBehavior", om.valueToTree(this.getPassthroughBehavior()));
                }
                if (this.getRequestParameters() != null) {
                    obj.set("requestParameters", om.valueToTree(this.getRequestParameters()));
                }
                if (this.getRequestTemplates() != null) {
                    obj.set("requestTemplates", om.valueToTree(this.getRequestTemplates()));
                }
                if (this.getTimeoutInMillis() != null) {
                    obj.set("timeoutInMillis", om.valueToTree(this.getTimeoutInMillis()));
                }
                if (this.getType() != null) {
                    obj.set("type", om.valueToTree(this.getType()));
                }
                if (this.getUri() != null) {
                    obj.set("uri", om.valueToTree(this.getUri()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationProperty.Jsii$Proxy that = (IntegrationProperty.Jsii$Proxy) o;

                if (this.cacheKeyParameters != null ? !this.cacheKeyParameters.equals(that.cacheKeyParameters) : that.cacheKeyParameters != null) return false;
                if (this.cacheNamespace != null ? !this.cacheNamespace.equals(that.cacheNamespace) : that.cacheNamespace != null) return false;
                if (this.connectionId != null ? !this.connectionId.equals(that.connectionId) : that.connectionId != null) return false;
                if (this.connectionType != null ? !this.connectionType.equals(that.connectionType) : that.connectionType != null) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
                if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
                if (this.integrationResponses != null ? !this.integrationResponses.equals(that.integrationResponses) : that.integrationResponses != null) return false;
                if (this.passthroughBehavior != null ? !this.passthroughBehavior.equals(that.passthroughBehavior) : that.passthroughBehavior != null) return false;
                if (this.requestParameters != null ? !this.requestParameters.equals(that.requestParameters) : that.requestParameters != null) return false;
                if (this.requestTemplates != null ? !this.requestTemplates.equals(that.requestTemplates) : that.requestTemplates != null) return false;
                if (this.timeoutInMillis != null ? !this.timeoutInMillis.equals(that.timeoutInMillis) : that.timeoutInMillis != null) return false;
                if (this.type != null ? !this.type.equals(that.type) : that.type != null) return false;
                return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
            }

            @Override
            public int hashCode() {
                int result = this.cacheKeyParameters != null ? this.cacheKeyParameters.hashCode() : 0;
                result = 31 * result + (this.cacheNamespace != null ? this.cacheNamespace.hashCode() : 0);
                result = 31 * result + (this.connectionId != null ? this.connectionId.hashCode() : 0);
                result = 31 * result + (this.connectionType != null ? this.connectionType.hashCode() : 0);
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
                result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
                result = 31 * result + (this.integrationResponses != null ? this.integrationResponses.hashCode() : 0);
                result = 31 * result + (this.passthroughBehavior != null ? this.passthroughBehavior.hashCode() : 0);
                result = 31 * result + (this.requestParameters != null ? this.requestParameters.hashCode() : 0);
                result = 31 * result + (this.requestTemplates != null ? this.requestTemplates.hashCode() : 0);
                result = 31 * result + (this.timeoutInMillis != null ? this.timeoutInMillis.hashCode() : 0);
                result = 31 * result + (this.type != null ? this.type.hashCode() : 0);
                result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface IntegrationResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.IntegrationResponseProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();

        /**
         * `CfnMethod.IntegrationResponseProperty.ContentHandling`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integrationresponse-contenthandling
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getContentHandling();

        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseParameters();

        /**
         * `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-responsetemplates
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseTemplates();

        /**
         * `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-integration-integrationresponse.html#cfn-apigateway-method-integration-integrationresponse-selectionpattern
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getSelectionPattern();

        /**
         * @return a {@link Builder} of {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.String contentHandling;
            private java.lang.Object responseParameters;
            private java.lang.Object responseTemplates;
            private java.lang.String selectionPattern;

            /**
             * Sets the value of StatusCode
             * @param statusCode `CfnMethod.IntegrationResponseProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of ContentHandling
             * @param contentHandling `CfnMethod.IntegrationResponseProperty.ContentHandling`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder contentHandling(java.lang.String contentHandling) {
                this.contentHandling = contentHandling;
                return this;
            }

            /**
             * Sets the value of ResponseParameters
             * @param responseParameters `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of ResponseParameters
             * @param responseParameters `CfnMethod.IntegrationResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of ResponseTemplates
             * @param responseTemplates `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseTemplates(software.amazon.awscdk.core.IResolvable responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of ResponseTemplates
             * @param responseTemplates `CfnMethod.IntegrationResponseProperty.ResponseTemplates`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
                this.responseTemplates = responseTemplates;
                return this;
            }

            /**
             * Sets the value of SelectionPattern
             * @param selectionPattern `CfnMethod.IntegrationResponseProperty.SelectionPattern`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder selectionPattern(java.lang.String selectionPattern) {
                this.selectionPattern = selectionPattern;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link IntegrationResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public IntegrationResponseProperty build() {
                return new Jsii$Proxy(statusCode, contentHandling, responseParameters, responseTemplates, selectionPattern);
            }
        }

        /**
         * An implementation for {@link IntegrationResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.String contentHandling;
            private final java.lang.Object responseParameters;
            private final java.lang.Object responseTemplates;
            private final java.lang.String selectionPattern;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.contentHandling = this.jsiiGet("contentHandling", java.lang.String.class);
                this.responseParameters = this.jsiiGet("responseParameters", java.lang.Object.class);
                this.responseTemplates = this.jsiiGet("responseTemplates", java.lang.Object.class);
                this.selectionPattern = this.jsiiGet("selectionPattern", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String statusCode, java.lang.String contentHandling, java.lang.Object responseParameters, java.lang.Object responseTemplates, java.lang.String selectionPattern) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.contentHandling = contentHandling;
                this.responseParameters = responseParameters;
                this.responseTemplates = responseTemplates;
                this.selectionPattern = selectionPattern;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.String getContentHandling() {
                return this.contentHandling;
            }

            @Override
            public java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public java.lang.Object getResponseTemplates() {
                return this.responseTemplates;
            }

            @Override
            public java.lang.String getSelectionPattern() {
                return this.selectionPattern;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getContentHandling() != null) {
                    obj.set("contentHandling", om.valueToTree(this.getContentHandling()));
                }
                if (this.getResponseParameters() != null) {
                    obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }
                if (this.getResponseTemplates() != null) {
                    obj.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
                }
                if (this.getSelectionPattern() != null) {
                    obj.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                IntegrationResponseProperty.Jsii$Proxy that = (IntegrationResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
                if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
                if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
                return this.selectionPattern != null ? this.selectionPattern.equals(that.selectionPattern) : that.selectionPattern == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
                result = 31 * result + (this.selectionPattern != null ? this.selectionPattern.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface MethodResponseProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnMethod.MethodResponseProperty.StatusCode`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-statuscode
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getStatusCode();

        /**
         * `CfnMethod.MethodResponseProperty.ResponseModels`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responsemodels
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseModels();

        /**
         * `CfnMethod.MethodResponseProperty.ResponseParameters`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apitgateway-method-methodresponse.html#cfn-apigateway-method-methodresponse-responseparameters
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.Object getResponseParameters();

        /**
         * @return a {@link Builder} of {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String statusCode;
            private java.lang.Object responseModels;
            private java.lang.Object responseParameters;

            /**
             * Sets the value of StatusCode
             * @param statusCode `CfnMethod.MethodResponseProperty.StatusCode`. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder statusCode(java.lang.String statusCode) {
                this.statusCode = statusCode;
                return this;
            }

            /**
             * Sets the value of ResponseModels
             * @param responseModels `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseModels(software.amazon.awscdk.core.IResolvable responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of ResponseModels
             * @param responseModels `CfnMethod.MethodResponseProperty.ResponseModels`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseModels(java.util.Map<java.lang.String, java.lang.String> responseModels) {
                this.responseModels = responseModels;
                return this;
            }

            /**
             * Sets the value of ResponseParameters
             * @param responseParameters `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Sets the value of ResponseParameters
             * @param responseParameters `CfnMethod.MethodResponseProperty.ResponseParameters`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder responseParameters(java.util.Map<java.lang.String, java.lang.Object> responseParameters) {
                this.responseParameters = responseParameters;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MethodResponseProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public MethodResponseProperty build() {
                return new Jsii$Proxy(statusCode, responseModels, responseParameters);
            }
        }

        /**
         * An implementation for {@link MethodResponseProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponseProperty {
            private final java.lang.String statusCode;
            private final java.lang.Object responseModels;
            private final java.lang.Object responseParameters;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
                this.responseModels = this.jsiiGet("responseModels", java.lang.Object.class);
                this.responseParameters = this.jsiiGet("responseParameters", java.lang.Object.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String statusCode, java.lang.Object responseModels, java.lang.Object responseParameters) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
                this.responseModels = responseModels;
                this.responseParameters = responseParameters;
            }

            @Override
            public java.lang.String getStatusCode() {
                return this.statusCode;
            }

            @Override
            public java.lang.Object getResponseModels() {
                return this.responseModels;
            }

            @Override
            public java.lang.Object getResponseParameters() {
                return this.responseParameters;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("statusCode", om.valueToTree(this.getStatusCode()));
                if (this.getResponseModels() != null) {
                    obj.set("responseModels", om.valueToTree(this.getResponseModels()));
                }
                if (this.getResponseParameters() != null) {
                    obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MethodResponseProperty.Jsii$Proxy that = (MethodResponseProperty.Jsii$Proxy) o;

                if (!statusCode.equals(that.statusCode)) return false;
                if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
                return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
            }

            @Override
            public int hashCode() {
                int result = this.statusCode.hashCode();
                result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
                result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
                return result;
            }
        }
    }
}
