package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGatewayV2::DomainName`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:42:52.091Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnDomainNameV2")
public class CfnDomainNameV2 extends software.amazon.awscdk.core.CfnResource {

    protected CfnDomainNameV2(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnDomainNameV2(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnDomainNameV2.class, "CFN_RESOURCE_TYPE_NAME", java.lang.String.class);
    }

    /**
     * Create a new `AWS::ApiGatewayV2::DomainName`.
     * 
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public CfnDomainNameV2(final software.amazon.awscdk.core.Construct scope, final java.lang.String id, final software.amazon.awscdk.services.apigateway.CfnDomainNameV2Props props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    @Override
    protected java.util.Map<java.lang.String, java.lang.Object> renderProperties(final java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(this.jsiiCall("renderProperties", java.util.Map.class, new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrRegionalDomainName() {
        return this.jsiiGet("attrRegionalDomainName", java.lang.String.class);
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getAttrRegionalHostedZoneId() {
        return this.jsiiGet("attrRegionalHostedZoneId", java.lang.String.class);
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    protected java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(this.jsiiGet("cfnProperties", java.util.Map.class));
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public software.amazon.awscdk.core.TagManager getTags() {
        return this.jsiiGet("tags", software.amazon.awscdk.core.TagManager.class);
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.String getDomainName() {
        return this.jsiiGet("domainName", java.lang.String.class);
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.DomainName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainname
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainName(final java.lang.String value) {
        this.jsiiSet("domainName", java.util.Objects.requireNonNull(value, "domainName is required"));
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.DomainNameConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public java.lang.Object getDomainNameConfigurations() {
        return this.jsiiGet("domainNameConfigurations", java.lang.Object.class);
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.DomainNameConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainNameConfigurations(final software.amazon.awscdk.core.IResolvable value) {
        this.jsiiSet("domainNameConfigurations", value);
    }

    /**
     * `AWS::ApiGatewayV2::DomainName.DomainNameConfigurations`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-domainname.html#cfn-apigatewayv2-domainname-domainnameconfigurations
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public void setDomainNameConfigurations(final java.util.List<java.lang.Object> value) {
        this.jsiiSet("domainNameConfigurations", value);
    }
    /**
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static interface DomainNameConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * `CfnDomainNameV2.DomainNameConfigurationProperty.CertificateArn`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatearn
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCertificateArn();

        /**
         * `CfnDomainNameV2.DomainNameConfigurationProperty.CertificateName`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-certificatename
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getCertificateName();

        /**
         * `CfnDomainNameV2.DomainNameConfigurationProperty.EndpointType`.
         * 
         * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-apigatewayv2-domainname-domainnameconfiguration.html#cfn-apigatewayv2-domainname-domainnameconfiguration-endpointtype
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        java.lang.String getEndpointType();

        /**
         * @return a {@link Builder} of {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public static final class Builder {
            private java.lang.String certificateArn;
            private java.lang.String certificateName;
            private java.lang.String endpointType;

            /**
             * Sets the value of CertificateArn
             * @param certificateArn `CfnDomainNameV2.DomainNameConfigurationProperty.CertificateArn`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder certificateArn(java.lang.String certificateArn) {
                this.certificateArn = certificateArn;
                return this;
            }

            /**
             * Sets the value of CertificateName
             * @param certificateName `CfnDomainNameV2.DomainNameConfigurationProperty.CertificateName`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder certificateName(java.lang.String certificateName) {
                this.certificateName = certificateName;
                return this;
            }

            /**
             * Sets the value of EndpointType
             * @param endpointType `CfnDomainNameV2.DomainNameConfigurationProperty.EndpointType`.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public Builder endpointType(java.lang.String endpointType) {
                this.endpointType = endpointType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DomainNameConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
            public DomainNameConfigurationProperty build() {
                return new Jsii$Proxy(certificateArn, certificateName, endpointType);
            }
        }

        /**
         * An implementation for {@link DomainNameConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DomainNameConfigurationProperty {
            private final java.lang.String certificateArn;
            private final java.lang.String certificateName;
            private final java.lang.String endpointType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.setObjRef(objRef);
                this.certificateArn = this.jsiiGet("certificateArn", java.lang.String.class);
                this.certificateName = this.jsiiGet("certificateName", java.lang.String.class);
                this.endpointType = this.jsiiGet("endpointType", java.lang.String.class);
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            private Jsii$Proxy(java.lang.String certificateArn, java.lang.String certificateName, java.lang.String endpointType) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.certificateArn = certificateArn;
                this.certificateName = certificateName;
                this.endpointType = endpointType;
            }

            @Override
            public java.lang.String getCertificateArn() {
                return this.certificateArn;
            }

            @Override
            public java.lang.String getCertificateName() {
                return this.certificateName;
            }

            @Override
            public java.lang.String getEndpointType() {
                return this.endpointType;
            }

            @Override
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                if (this.getCertificateArn() != null) {
                    obj.set("certificateArn", om.valueToTree(this.getCertificateArn()));
                }
                if (this.getCertificateName() != null) {
                    obj.set("certificateName", om.valueToTree(this.getCertificateName()));
                }
                if (this.getEndpointType() != null) {
                    obj.set("endpointType", om.valueToTree(this.getEndpointType()));
                }
                return obj;
            }

            @Override
            public boolean equals(Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DomainNameConfigurationProperty.Jsii$Proxy that = (DomainNameConfigurationProperty.Jsii$Proxy) o;

                if (this.certificateArn != null ? !this.certificateArn.equals(that.certificateArn) : that.certificateArn != null) return false;
                if (this.certificateName != null ? !this.certificateName.equals(that.certificateName) : that.certificateName != null) return false;
                return this.endpointType != null ? this.endpointType.equals(that.endpointType) : that.endpointType == null;
            }

            @Override
            public int hashCode() {
                int result = this.certificateArn != null ? this.certificateArn.hashCode() : 0;
                result = 31 * result + (this.certificateName != null ? this.certificateName.hashCode() : 0);
                result = 31 * result + (this.endpointType != null ? this.endpointType.hashCode() : 0);
                return result;
            }
        }
    }
}
