package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::GatewayResponse`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:42:52.092Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnGatewayResponseProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getResponseType();

    /**
     * `AWS::ApiGateway::GatewayResponse.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRestApiId();

    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseParameters`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responseparameters
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getResponseParameters();

    /**
     * `AWS::ApiGateway::GatewayResponse.ResponseTemplates`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-responsetemplates
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getResponseTemplates();

    /**
     * `AWS::ApiGateway::GatewayResponse.StatusCode`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-gatewayresponse.html#cfn-apigateway-gatewayresponse-statuscode
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getStatusCode();

    /**
     * @return a {@link Builder} of {@link CfnGatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnGatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String responseType;
        private java.lang.String restApiId;
        private java.lang.Object responseParameters;
        private java.lang.Object responseTemplates;
        private java.lang.String statusCode;

        /**
         * Sets the value of ResponseType
         * @param responseType `AWS::ApiGateway::GatewayResponse.ResponseType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder responseType(java.lang.String responseType) {
            this.responseType = responseType;
            return this;
        }

        /**
         * Sets the value of RestApiId
         * @param restApiId `AWS::ApiGateway::GatewayResponse.RestApiId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of ResponseParameters
         * @param responseParameters `AWS::ApiGateway::GatewayResponse.ResponseParameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder responseParameters(software.amazon.awscdk.core.IResolvable responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Sets the value of ResponseParameters
         * @param responseParameters `AWS::ApiGateway::GatewayResponse.ResponseParameters`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Sets the value of ResponseTemplates
         * @param responseTemplates `AWS::ApiGateway::GatewayResponse.ResponseTemplates`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder responseTemplates(software.amazon.awscdk.core.IResolvable responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        /**
         * Sets the value of ResponseTemplates
         * @param responseTemplates `AWS::ApiGateway::GatewayResponse.ResponseTemplates`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        /**
         * Sets the value of StatusCode
         * @param statusCode `AWS::ApiGateway::GatewayResponse.StatusCode`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnGatewayResponseProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnGatewayResponseProps build() {
            return new Jsii$Proxy(responseType, restApiId, responseParameters, responseTemplates, statusCode);
        }
    }

    /**
     * An implementation for {@link CfnGatewayResponseProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnGatewayResponseProps {
        private final java.lang.String responseType;
        private final java.lang.String restApiId;
        private final java.lang.Object responseParameters;
        private final java.lang.Object responseTemplates;
        private final java.lang.String statusCode;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.responseType = this.jsiiGet("responseType", java.lang.String.class);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            this.responseParameters = this.jsiiGet("responseParameters", java.lang.Object.class);
            this.responseTemplates = this.jsiiGet("responseTemplates", java.lang.Object.class);
            this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String responseType, java.lang.String restApiId, java.lang.Object responseParameters, java.lang.Object responseTemplates, java.lang.String statusCode) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.responseType = java.util.Objects.requireNonNull(responseType, "responseType is required");
            this.restApiId = java.util.Objects.requireNonNull(restApiId, "restApiId is required");
            this.responseParameters = responseParameters;
            this.responseTemplates = responseTemplates;
            this.statusCode = statusCode;
        }

        @Override
        public java.lang.String getResponseType() {
            return this.responseType;
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public java.lang.Object getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public java.lang.Object getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("responseType", om.valueToTree(this.getResponseType()));
            obj.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getResponseParameters() != null) {
                obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }
            if (this.getResponseTemplates() != null) {
                obj.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
            }
            if (this.getStatusCode() != null) {
                obj.set("statusCode", om.valueToTree(this.getStatusCode()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnGatewayResponseProps.Jsii$Proxy that = (CfnGatewayResponseProps.Jsii$Proxy) o;

            if (!responseType.equals(that.responseType)) return false;
            if (!restApiId.equals(that.restApiId)) return false;
            if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
            if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
            return this.statusCode != null ? this.statusCode.equals(that.statusCode) : that.statusCode == null;
        }

        @Override
        public int hashCode() {
            int result = this.responseType.hashCode();
            result = 31 * result + (this.restApiId.hashCode());
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
            result = 31 * result + (this.statusCode != null ? this.statusCode.hashCode() : 0);
            return result;
        }
    }
}
