package software.amazon.awscdk.services.apigateway;

/**
 * Integrates an AWS Lambda function to an API Gateway method.
 * 
 * Example:
 * 
 *    const handler = new lambda.Function(this, 'MyFunction', ...);
 *    api.addMethod('GET', new LambdaIntegration(handler));
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.17.0 (build 7d5d104)", date = "2019-10-01T14:42:52.132Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.LambdaIntegration")
public class LambdaIntegration extends software.amazon.awscdk.services.apigateway.AwsIntegration {

    protected LambdaIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param handler This parameter is required.
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final software.amazon.awscdk.services.lambda.IFunction handler, final software.amazon.awscdk.services.apigateway.LambdaIntegrationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required"), options }));
    }

    /**
     * @param handler This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public LambdaIntegration(final software.amazon.awscdk.services.lambda.IFunction handler) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        this.setObjRef(software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(handler, "handler is required") }));
    }

    /**
     * Can be overridden by subclasses to allow the integration to interact with the method being integrated, access the REST API object, method ARNs, etc.
     * 
     * @param method This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void bind(final software.amazon.awscdk.services.apigateway.Method method) {
        this.jsiiCall("bind", Void.class, new Object[] { java.util.Objects.requireNonNull(method, "method is required") });
    }
}
