/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import java.util.Map;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.apigateway.CfnMethod;
import software.amazon.awscdk.services.apigateway.CfnMethodProps;
import software.amazon.jsii.JsiiSerializable;

public interface CfnMethodProps
extends JsiiSerializable {
    public String getHttpMethod();

    public String getResourceId();

    public String getRestApiId();

    public Object getApiKeyRequired();

    public List<String> getAuthorizationScopes();

    public String getAuthorizationType();

    public String getAuthorizerId();

    public Object getIntegration();

    public Object getMethodResponses();

    public String getOperationName();

    public Object getRequestModels();

    public Object getRequestParameters();

    public String getRequestValidatorId();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String httpMethod;
        private String resourceId;
        private String restApiId;
        private Object apiKeyRequired;
        private List<String> authorizationScopes;
        private String authorizationType;
        private String authorizerId;
        private Object integration;
        private Object methodResponses;
        private String operationName;
        private Object requestModels;
        private Object requestParameters;
        private String requestValidatorId;

        public Builder httpMethod(String httpMethod) {
            this.httpMethod = httpMethod;
            return this;
        }

        public Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public Builder restApiId(String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public Builder apiKeyRequired(IResolvable apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public Builder authorizationScopes(List<String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        public Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public Builder integration(IResolvable integration) {
            this.integration = integration;
            return this;
        }

        public Builder integration(CfnMethod.IntegrationProperty integration) {
            this.integration = integration;
            return this;
        }

        public Builder methodResponses(IResolvable methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        public Builder methodResponses(List<Object> methodResponses) {
            this.methodResponses = methodResponses;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder requestModels(IResolvable requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        public Builder requestModels(Map<String, String> requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        public Builder requestParameters(IResolvable requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder requestParameters(Map<String, Object> requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder requestValidatorId(String requestValidatorId) {
            this.requestValidatorId = requestValidatorId;
            return this;
        }

        public CfnMethodProps build() {
            return new Jsii.Proxy(this.httpMethod, this.resourceId, this.restApiId, this.apiKeyRequired, this.authorizationScopes, this.authorizationType, this.authorizerId, this.integration, this.methodResponses, this.operationName, this.requestModels, this.requestParameters, this.requestValidatorId, null);
        }
    }
}

