/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.List;
import software.amazon.awscdk.core.IResolvable;
import software.amazon.awscdk.services.apigateway.CfnRouteV2Props;
import software.amazon.jsii.JsiiSerializable;

public interface CfnRouteV2Props
extends JsiiSerializable {
    public String getApiId();

    public String getRouteKey();

    public Object getApiKeyRequired();

    public List<String> getAuthorizationScopes();

    public String getAuthorizationType();

    public String getAuthorizerId();

    public String getModelSelectionExpression();

    public String getOperationName();

    public Object getRequestModels();

    public Object getRequestParameters();

    public String getRouteResponseSelectionExpression();

    public String getTarget();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String apiId;
        private String routeKey;
        private Object apiKeyRequired;
        private List<String> authorizationScopes;
        private String authorizationType;
        private String authorizerId;
        private String modelSelectionExpression;
        private String operationName;
        private Object requestModels;
        private Object requestParameters;
        private String routeResponseSelectionExpression;
        private String target;

        public Builder apiId(String apiId) {
            this.apiId = apiId;
            return this;
        }

        public Builder routeKey(String routeKey) {
            this.routeKey = routeKey;
            return this;
        }

        public Builder apiKeyRequired(Boolean apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public Builder apiKeyRequired(IResolvable apiKeyRequired) {
            this.apiKeyRequired = apiKeyRequired;
            return this;
        }

        public Builder authorizationScopes(List<String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        public Builder authorizationType(String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        public Builder authorizerId(String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        public Builder modelSelectionExpression(String modelSelectionExpression) {
            this.modelSelectionExpression = modelSelectionExpression;
            return this;
        }

        public Builder operationName(String operationName) {
            this.operationName = operationName;
            return this;
        }

        public Builder requestModels(Object requestModels) {
            this.requestModels = requestModels;
            return this;
        }

        public Builder requestParameters(Object requestParameters) {
            this.requestParameters = requestParameters;
            return this;
        }

        public Builder routeResponseSelectionExpression(String routeResponseSelectionExpression) {
            this.routeResponseSelectionExpression = routeResponseSelectionExpression;
            return this;
        }

        public Builder target(String target) {
            this.target = target;
            return this;
        }

        public CfnRouteV2Props build() {
            return new Jsii.Proxy(this.apiId, this.routeKey, this.apiKeyRequired, this.authorizationScopes, this.authorizationType, this.authorizerId, this.modelSelectionExpression, this.operationName, this.requestModels, this.requestParameters, this.routeResponseSelectionExpression, this.target, null);
        }
    }
}

