package software.amazon.awscdk.services.apigateway;

/**
 * The endpoint configuration of a REST API, including VPCs and endpoint types.
 * <p>
 * EndpointConfiguration is a property of the AWS::ApiGateway::RestApi resource.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.29.0 (build 41df200)", date = "2021-05-19T10:18:47.245Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.EndpointConfiguration")
@software.amazon.jsii.Jsii.Proxy(EndpointConfiguration.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EndpointConfiguration extends software.amazon.jsii.JsiiSerializable {

    /**
     * A list of endpoint types of an API or its custom domain name.
     * <p>
     * Default: EndpointType.EDGE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getTypes();

    /**
     * A list of VPC Endpoints against which to create Route53 ALIASes.
     * <p>
     * Default: - no ALIASes are created for the endpoint.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> getVpcEndpoints() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EndpointConfiguration> {
        private java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> types;
        private java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints;

        /**
         * Sets the value of {@link EndpointConfiguration#getTypes}
         * @param types A list of endpoint types of an API or its custom domain name. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder types(java.util.List<? extends software.amazon.awscdk.services.apigateway.EndpointType> types) {
            this.types = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)types;
            return this;
        }

        /**
         * Sets the value of {@link EndpointConfiguration#getVpcEndpoints}
         * @param vpcEndpoints A list of VPC Endpoints against which to create Route53 ALIASes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder vpcEndpoints(java.util.List<? extends software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints) {
            this.vpcEndpoints = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint>)vpcEndpoints;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EndpointConfiguration}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EndpointConfiguration build() {
            return new Jsii$Proxy(types, vpcEndpoints);
        }
    }

    /**
     * An implementation for {@link EndpointConfiguration}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EndpointConfiguration {
        private final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> types;
        private final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.types = software.amazon.jsii.Kernel.get(this, "types", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.EndpointType.class)));
            this.vpcEndpoints = software.amazon.jsii.Kernel.get(this, "vpcEndpoints", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpcEndpoint.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.apigateway.EndpointType> types, final java.util.List<? extends software.amazon.awscdk.services.ec2.IVpcEndpoint> vpcEndpoints) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.types = (java.util.List<software.amazon.awscdk.services.apigateway.EndpointType>)java.util.Objects.requireNonNull(types, "types is required");
            this.vpcEndpoints = (java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint>)vpcEndpoints;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.apigateway.EndpointType> getTypes() {
            return this.types;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.IVpcEndpoint> getVpcEndpoints() {
            return this.vpcEndpoints;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("types", om.valueToTree(this.getTypes()));
            if (this.getVpcEndpoints() != null) {
                data.set("vpcEndpoints", om.valueToTree(this.getVpcEndpoints()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.EndpointConfiguration"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EndpointConfiguration.Jsii$Proxy that = (EndpointConfiguration.Jsii$Proxy) o;

            if (!types.equals(that.types)) return false;
            return this.vpcEndpoints != null ? this.vpcEndpoints.equals(that.vpcEndpoints) : that.vpcEndpoints == null;
        }

        @Override
        public final int hashCode() {
            int result = this.types.hashCode();
            result = 31 * result + (this.vpcEndpoints != null ? this.vpcEndpoints.hashCode() : 0);
            return result;
        }
    }
}
