package software.amazon.awscdk.services.apigateway;

/**
 * Properties for CognitoUserPoolsAuthorizer.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-28T21:14:37.550Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CognitoUserPoolsAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(CognitoUserPoolsAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CognitoUserPoolsAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The user pools to associate with this authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.cognito.IUserPool> getCognitoUserPools();

    /**
     * An optional human friendly name for the authorizer.
     * <p>
     * Note that, this is not the primary identifier of the authorizer.
     * <p>
     * Default: - the unique construct ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * The request header mapping expression for the bearer token.
     * <p>
     * This is typically passed as part of the header, in which case
     * this should be <code>method.request.header.Authorizer</code> where Authorizer is the header containing the bearer token.
     * <p>
     * Default: `IdentitySource.header('Authorization')`
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/api-reference/link-relation/authorizer-create/#identitySource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getIdentitySource() {
        return null;
    }

    /**
     * How long APIGateway should cache the results.
     * <p>
     * Max 1 hour.
     * Disable caching by setting this to 0.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getResultsCacheTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CognitoUserPoolsAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CognitoUserPoolsAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CognitoUserPoolsAuthorizerProps> {
        private java.util.List<software.amazon.awscdk.services.cognito.IUserPool> cognitoUserPools;
        private java.lang.String authorizerName;
        private java.lang.String identitySource;
        private software.amazon.awscdk.core.Duration resultsCacheTtl;

        /**
         * Sets the value of {@link CognitoUserPoolsAuthorizerProps#getCognitoUserPools}
         * @param cognitoUserPools The user pools to associate with this authorizer. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder cognitoUserPools(java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPool> cognitoUserPools) {
            this.cognitoUserPools = (java.util.List<software.amazon.awscdk.services.cognito.IUserPool>)cognitoUserPools;
            return this;
        }

        /**
         * Sets the value of {@link CognitoUserPoolsAuthorizerProps#getAuthorizerName}
         * @param authorizerName An optional human friendly name for the authorizer.
         *                       Note that, this is not the primary identifier of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link CognitoUserPoolsAuthorizerProps#getIdentitySource}
         * @param identitySource The request header mapping expression for the bearer token.
         *                       This is typically passed as part of the header, in which case
         *                       this should be <code>method.request.header.Authorizer</code> where Authorizer is the header containing the bearer token.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(java.lang.String identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of {@link CognitoUserPoolsAuthorizerProps#getResultsCacheTtl}
         * @param resultsCacheTtl How long APIGateway should cache the results.
         *                        Max 1 hour.
         *                        Disable caching by setting this to 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(software.amazon.awscdk.core.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CognitoUserPoolsAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CognitoUserPoolsAuthorizerProps build() {
            return new Jsii$Proxy(cognitoUserPools, authorizerName, identitySource, resultsCacheTtl);
        }
    }

    /**
     * An implementation for {@link CognitoUserPoolsAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CognitoUserPoolsAuthorizerProps {
        private final java.util.List<software.amazon.awscdk.services.cognito.IUserPool> cognitoUserPools;
        private final java.lang.String authorizerName;
        private final java.lang.String identitySource;
        private final software.amazon.awscdk.core.Duration resultsCacheTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cognitoUserPools = software.amazon.jsii.Kernel.get(this, "cognitoUserPools", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cognito.IUserPool.class)));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.identitySource = software.amazon.jsii.Kernel.get(this, "identitySource", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final java.util.List<? extends software.amazon.awscdk.services.cognito.IUserPool> cognitoUserPools, final java.lang.String authorizerName, final java.lang.String identitySource, final software.amazon.awscdk.core.Duration resultsCacheTtl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cognitoUserPools = (java.util.List<software.amazon.awscdk.services.cognito.IUserPool>)java.util.Objects.requireNonNull(cognitoUserPools, "cognitoUserPools is required");
            this.authorizerName = authorizerName;
            this.identitySource = identitySource;
            this.resultsCacheTtl = resultsCacheTtl;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cognito.IUserPool> getCognitoUserPools() {
            return this.cognitoUserPools;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final java.lang.String getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("cognitoUserPools", om.valueToTree(this.getCognitoUserPools()));
            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getIdentitySource() != null) {
                data.set("identitySource", om.valueToTree(this.getIdentitySource()));
            }
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.CognitoUserPoolsAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CognitoUserPoolsAuthorizerProps.Jsii$Proxy that = (CognitoUserPoolsAuthorizerProps.Jsii$Proxy) o;

            if (!cognitoUserPools.equals(that.cognitoUserPools)) return false;
            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            if (this.identitySource != null ? !this.identitySource.equals(that.identitySource) : that.identitySource != null) return false;
            return this.resultsCacheTtl != null ? this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cognitoUserPools.hashCode();
            result = 31 * result + (this.authorizerName != null ? this.authorizerName.hashCode() : 0);
            result = 31 * result + (this.identitySource != null ? this.identitySource.hashCode() : 0);
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            return result;
        }
    }
}
