package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.30.0 (build adae23f)", date = "2021-06-28T21:14:37.586Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.MethodDeploymentOptions")
@software.amazon.jsii.Jsii.Proxy(MethodDeploymentOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MethodDeploymentOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether the cached responses are encrypted.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCacheDataEncrypted() {
        return null;
    }

    /**
     * Specifies the time to live (TTL), in seconds, for cached responses.
     * <p>
     * The
     * higher the TTL, the longer the response will be cached.
     * <p>
     * Default: Duration.minutes(5)
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-caching.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getCacheTtl() {
        return null;
    }

    /**
     * Specifies whether responses should be cached and returned for requests.
     * <p>
     * A
     * cache cluster must be enabled on the stage for responses to be cached.
     * <p>
     * Default: - Caching is Disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCachingEnabled() {
        return null;
    }

    /**
     * Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDataTraceEnabled() {
        return null;
    }

    /**
     * Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
     * <p>
     * Default: - Off
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
        return null;
    }

    /**
     * Specifies whether Amazon CloudWatch metrics are enabled for this method.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getMetricsEnabled() {
        return null;
    }

    /**
     * Specifies the throttling burst limit.
     * <p>
     * The total rate of all requests in your AWS account is limited to 5,000 requests.
     * <p>
     * Default: - No additional restriction.
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingBurstLimit() {
        return null;
    }

    /**
     * Specifies the throttling rate limit.
     * <p>
     * The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
     * <p>
     * Default: - No additional restriction.
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-request-throttling.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getThrottlingRateLimit() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link MethodDeploymentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MethodDeploymentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<MethodDeploymentOptions> {
        private java.lang.Boolean cacheDataEncrypted;
        private software.amazon.awscdk.core.Duration cacheTtl;
        private java.lang.Boolean cachingEnabled;
        private java.lang.Boolean dataTraceEnabled;
        private software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        private java.lang.Boolean metricsEnabled;
        private java.lang.Number throttlingBurstLimit;
        private java.lang.Number throttlingRateLimit;

        /**
         * Sets the value of {@link MethodDeploymentOptions#getCacheDataEncrypted}
         * @param cacheDataEncrypted Indicates whether the cached responses are encrypted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheDataEncrypted(java.lang.Boolean cacheDataEncrypted) {
            this.cacheDataEncrypted = cacheDataEncrypted;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getCacheTtl}
         * @param cacheTtl Specifies the time to live (TTL), in seconds, for cached responses.
         *                 The
         *                 higher the TTL, the longer the response will be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheTtl(software.amazon.awscdk.core.Duration cacheTtl) {
            this.cacheTtl = cacheTtl;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getCachingEnabled}
         * @param cachingEnabled Specifies whether responses should be cached and returned for requests.
         *                       A
         *                       cache cluster must be enabled on the stage for responses to be cached.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachingEnabled(java.lang.Boolean cachingEnabled) {
            this.cachingEnabled = cachingEnabled;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getDataTraceEnabled}
         * @param dataTraceEnabled Specifies whether data trace logging is enabled for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataTraceEnabled(java.lang.Boolean dataTraceEnabled) {
            this.dataTraceEnabled = dataTraceEnabled;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getLoggingLevel}
         * @param loggingLevel Specifies the logging level for this method, which effects the log entries pushed to Amazon CloudWatch Logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder loggingLevel(software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel) {
            this.loggingLevel = loggingLevel;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getMetricsEnabled}
         * @param metricsEnabled Specifies whether Amazon CloudWatch metrics are enabled for this method.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricsEnabled(java.lang.Boolean metricsEnabled) {
            this.metricsEnabled = metricsEnabled;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getThrottlingBurstLimit}
         * @param throttlingBurstLimit Specifies the throttling burst limit.
         *                             The total rate of all requests in your AWS account is limited to 5,000 requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingBurstLimit(java.lang.Number throttlingBurstLimit) {
            this.throttlingBurstLimit = throttlingBurstLimit;
            return this;
        }

        /**
         * Sets the value of {@link MethodDeploymentOptions#getThrottlingRateLimit}
         * @param throttlingRateLimit Specifies the throttling rate limit.
         *                            The total rate of all requests in your AWS account is limited to 10,000 requests per second (rps).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttlingRateLimit(java.lang.Number throttlingRateLimit) {
            this.throttlingRateLimit = throttlingRateLimit;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodDeploymentOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public MethodDeploymentOptions build() {
            return new Jsii$Proxy(cacheDataEncrypted, cacheTtl, cachingEnabled, dataTraceEnabled, loggingLevel, metricsEnabled, throttlingBurstLimit, throttlingRateLimit);
        }
    }

    /**
     * An implementation for {@link MethodDeploymentOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodDeploymentOptions {
        private final java.lang.Boolean cacheDataEncrypted;
        private final software.amazon.awscdk.core.Duration cacheTtl;
        private final java.lang.Boolean cachingEnabled;
        private final java.lang.Boolean dataTraceEnabled;
        private final software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel;
        private final java.lang.Boolean metricsEnabled;
        private final java.lang.Number throttlingBurstLimit;
        private final java.lang.Number throttlingRateLimit;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.cacheDataEncrypted = software.amazon.jsii.Kernel.get(this, "cacheDataEncrypted", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.cacheTtl = software.amazon.jsii.Kernel.get(this, "cacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
            this.cachingEnabled = software.amazon.jsii.Kernel.get(this, "cachingEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.dataTraceEnabled = software.amazon.jsii.Kernel.get(this, "dataTraceEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.loggingLevel = software.amazon.jsii.Kernel.get(this, "loggingLevel", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodLoggingLevel.class));
            this.metricsEnabled = software.amazon.jsii.Kernel.get(this, "metricsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.throttlingBurstLimit = software.amazon.jsii.Kernel.get(this, "throttlingBurstLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.throttlingRateLimit = software.amazon.jsii.Kernel.get(this, "throttlingRateLimit", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final java.lang.Boolean cacheDataEncrypted, final software.amazon.awscdk.core.Duration cacheTtl, final java.lang.Boolean cachingEnabled, final java.lang.Boolean dataTraceEnabled, final software.amazon.awscdk.services.apigateway.MethodLoggingLevel loggingLevel, final java.lang.Boolean metricsEnabled, final java.lang.Number throttlingBurstLimit, final java.lang.Number throttlingRateLimit) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.cacheDataEncrypted = cacheDataEncrypted;
            this.cacheTtl = cacheTtl;
            this.cachingEnabled = cachingEnabled;
            this.dataTraceEnabled = dataTraceEnabled;
            this.loggingLevel = loggingLevel;
            this.metricsEnabled = metricsEnabled;
            this.throttlingBurstLimit = throttlingBurstLimit;
            this.throttlingRateLimit = throttlingRateLimit;
        }

        @Override
        public final java.lang.Boolean getCacheDataEncrypted() {
            return this.cacheDataEncrypted;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getCacheTtl() {
            return this.cacheTtl;
        }

        @Override
        public final java.lang.Boolean getCachingEnabled() {
            return this.cachingEnabled;
        }

        @Override
        public final java.lang.Boolean getDataTraceEnabled() {
            return this.dataTraceEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MethodLoggingLevel getLoggingLevel() {
            return this.loggingLevel;
        }

        @Override
        public final java.lang.Boolean getMetricsEnabled() {
            return this.metricsEnabled;
        }

        @Override
        public final java.lang.Number getThrottlingBurstLimit() {
            return this.throttlingBurstLimit;
        }

        @Override
        public final java.lang.Number getThrottlingRateLimit() {
            return this.throttlingRateLimit;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCacheDataEncrypted() != null) {
                data.set("cacheDataEncrypted", om.valueToTree(this.getCacheDataEncrypted()));
            }
            if (this.getCacheTtl() != null) {
                data.set("cacheTtl", om.valueToTree(this.getCacheTtl()));
            }
            if (this.getCachingEnabled() != null) {
                data.set("cachingEnabled", om.valueToTree(this.getCachingEnabled()));
            }
            if (this.getDataTraceEnabled() != null) {
                data.set("dataTraceEnabled", om.valueToTree(this.getDataTraceEnabled()));
            }
            if (this.getLoggingLevel() != null) {
                data.set("loggingLevel", om.valueToTree(this.getLoggingLevel()));
            }
            if (this.getMetricsEnabled() != null) {
                data.set("metricsEnabled", om.valueToTree(this.getMetricsEnabled()));
            }
            if (this.getThrottlingBurstLimit() != null) {
                data.set("throttlingBurstLimit", om.valueToTree(this.getThrottlingBurstLimit()));
            }
            if (this.getThrottlingRateLimit() != null) {
                data.set("throttlingRateLimit", om.valueToTree(this.getThrottlingRateLimit()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.MethodDeploymentOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MethodDeploymentOptions.Jsii$Proxy that = (MethodDeploymentOptions.Jsii$Proxy) o;

            if (this.cacheDataEncrypted != null ? !this.cacheDataEncrypted.equals(that.cacheDataEncrypted) : that.cacheDataEncrypted != null) return false;
            if (this.cacheTtl != null ? !this.cacheTtl.equals(that.cacheTtl) : that.cacheTtl != null) return false;
            if (this.cachingEnabled != null ? !this.cachingEnabled.equals(that.cachingEnabled) : that.cachingEnabled != null) return false;
            if (this.dataTraceEnabled != null ? !this.dataTraceEnabled.equals(that.dataTraceEnabled) : that.dataTraceEnabled != null) return false;
            if (this.loggingLevel != null ? !this.loggingLevel.equals(that.loggingLevel) : that.loggingLevel != null) return false;
            if (this.metricsEnabled != null ? !this.metricsEnabled.equals(that.metricsEnabled) : that.metricsEnabled != null) return false;
            if (this.throttlingBurstLimit != null ? !this.throttlingBurstLimit.equals(that.throttlingBurstLimit) : that.throttlingBurstLimit != null) return false;
            return this.throttlingRateLimit != null ? this.throttlingRateLimit.equals(that.throttlingRateLimit) : that.throttlingRateLimit == null;
        }

        @Override
        public final int hashCode() {
            int result = this.cacheDataEncrypted != null ? this.cacheDataEncrypted.hashCode() : 0;
            result = 31 * result + (this.cacheTtl != null ? this.cacheTtl.hashCode() : 0);
            result = 31 * result + (this.cachingEnabled != null ? this.cachingEnabled.hashCode() : 0);
            result = 31 * result + (this.dataTraceEnabled != null ? this.dataTraceEnabled.hashCode() : 0);
            result = 31 * result + (this.loggingLevel != null ? this.loggingLevel.hashCode() : 0);
            result = 31 * result + (this.metricsEnabled != null ? this.metricsEnabled.hashCode() : 0);
            result = 31 * result + (this.throttlingBurstLimit != null ? this.throttlingBurstLimit.hashCode() : 0);
            result = 31 * result + (this.throttlingRateLimit != null ? this.throttlingRateLimit.hashCode() : 0);
            return result;
        }
    }
}
