package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:35:42.099Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsIntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the integrated AWS service (e.g. `s3`).
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getService();

    /**
     * The AWS action to perform in the integration.
     * 
     * Use `actionParams` to specify key-value params for the action.
     * 
     * Mutually exclusive with `path`.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getAction();

    /**
     * Parameters for the action.
     * 
     * `action` must be set, and `path` must be undefined.
     * The action params will be URL encoded.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.String> getActionParameters();

    /**
     * The integration's HTTP method type.
     * 
     * Default: POST
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getIntegrationHttpMethod();

    /**
     * Integration options, such as content handling, request/response mapping, etc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();

    /**
     * The path to use for path-base APIs.
     * 
     * For example, for S3 GET, you can set path to `bucket/key`.
     * For lambda, you can set path to `2015-03-31/functions/${function-arn}/invocations`
     * 
     * Mutually exclusive with the `action` options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getPath();

    /**
     * Use AWS_PROXY integration.
     * 
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Boolean getProxy();

    /**
     * A designated subdomain supported by certain AWS service for fast host-name lookup.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getSubdomain();

    /**
     * @return a {@link Builder} of {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String service;
        private java.lang.String action;
        private java.util.Map<java.lang.String, java.lang.String> actionParameters;
        private java.lang.String integrationHttpMethod;
        private software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private java.lang.String path;
        private java.lang.Boolean proxy;
        private java.lang.String subdomain;

        /**
         * Sets the value of Service
         * @param service The name of the integrated AWS service (e.g. `s3`). This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder service(java.lang.String service) {
            this.service = service;
            return this;
        }

        /**
         * Sets the value of Action
         * @param action The AWS action to perform in the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder action(java.lang.String action) {
            this.action = action;
            return this;
        }

        /**
         * Sets the value of ActionParameters
         * @param actionParameters Parameters for the action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionParameters(java.util.Map<java.lang.String, java.lang.String> actionParameters) {
            this.actionParameters = actionParameters;
            return this;
        }

        /**
         * Sets the value of IntegrationHttpMethod
         * @param integrationHttpMethod The integration's HTTP method type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of Options
         * @param options Integration options, such as content handling, request/response mapping, etc.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of Path
         * @param path The path to use for path-base APIs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder path(java.lang.String path) {
            this.path = path;
            return this;
        }

        /**
         * Sets the value of Proxy
         * @param proxy Use AWS_PROXY integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of Subdomain
         * @param subdomain A designated subdomain supported by certain AWS service for fast host-name lookup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subdomain(java.lang.String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsIntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public AwsIntegrationProps build() {
            return new Jsii$Proxy(service, action, actionParameters, integrationHttpMethod, options, path, proxy, subdomain);
        }
    }

    /**
     * An implementation for {@link AwsIntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsIntegrationProps {
        private final java.lang.String service;
        private final java.lang.String action;
        private final java.util.Map<java.lang.String, java.lang.String> actionParameters;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.String path;
        private final java.lang.Boolean proxy;
        private final java.lang.String subdomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.service = this.jsiiGet("service", java.lang.String.class);
            this.action = this.jsiiGet("action", java.lang.String.class);
            this.actionParameters = this.jsiiGet("actionParameters", java.util.Map.class);
            this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
            this.path = this.jsiiGet("path", java.lang.String.class);
            this.proxy = this.jsiiGet("proxy", java.lang.Boolean.class);
            this.subdomain = this.jsiiGet("subdomain", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String service, java.lang.String action, java.util.Map<java.lang.String, java.lang.String> actionParameters, java.lang.String integrationHttpMethod, software.amazon.awscdk.services.apigateway.IntegrationOptions options, java.lang.String path, java.lang.Boolean proxy, java.lang.String subdomain) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.service = java.util.Objects.requireNonNull(service, "service is required");
            this.action = action;
            this.actionParameters = actionParameters;
            this.integrationHttpMethod = integrationHttpMethod;
            this.options = options;
            this.path = path;
            this.proxy = proxy;
            this.subdomain = subdomain;
        }

        @Override
        public java.lang.String getService() {
            return this.service;
        }

        @Override
        public java.lang.String getAction() {
            return this.action;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.String> getActionParameters() {
            return this.actionParameters;
        }

        @Override
        public java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public java.lang.String getPath() {
            return this.path;
        }

        @Override
        public java.lang.Boolean getProxy() {
            return this.proxy;
        }

        @Override
        public java.lang.String getSubdomain() {
            return this.subdomain;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("service", om.valueToTree(this.getService()));
            if (this.getAction() != null) {
                obj.set("action", om.valueToTree(this.getAction()));
            }
            if (this.getActionParameters() != null) {
                obj.set("actionParameters", om.valueToTree(this.getActionParameters()));
            }
            if (this.getIntegrationHttpMethod() != null) {
                obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                obj.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getPath() != null) {
                obj.set("path", om.valueToTree(this.getPath()));
            }
            if (this.getProxy() != null) {
                obj.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getSubdomain() != null) {
                obj.set("subdomain", om.valueToTree(this.getSubdomain()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsIntegrationProps.Jsii$Proxy that = (AwsIntegrationProps.Jsii$Proxy) o;

            if (!service.equals(that.service)) return false;
            if (this.action != null ? !this.action.equals(that.action) : that.action != null) return false;
            if (this.actionParameters != null ? !this.actionParameters.equals(that.actionParameters) : that.actionParameters != null) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            if (this.path != null ? !this.path.equals(that.path) : that.path != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            return this.subdomain != null ? this.subdomain.equals(that.subdomain) : that.subdomain == null;
        }

        @Override
        public int hashCode() {
            int result = this.service.hashCode();
            result = 31 * result + (this.action != null ? this.action.hashCode() : 0);
            result = 31 * result + (this.actionParameters != null ? this.actionParameters.hashCode() : 0);
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.path != null ? this.path.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.subdomain != null ? this.subdomain.hashCode() : 0);
            return result;
        }
    }
}
