package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGateway::Stage`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:35:42.150Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnStageProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGateway::Stage.RestApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-restapiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getRestApiId();

    /**
     * `AWS::ApiGateway::Stage.AccessLogSetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-accesslogsetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getAccessLogSetting();

    /**
     * `AWS::ApiGateway::Stage.CacheClusterEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclusterenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCacheClusterEnabled();

    /**
     * `AWS::ApiGateway::Stage.CacheClusterSize`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-cacheclustersize
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getCacheClusterSize();

    /**
     * `AWS::ApiGateway::Stage.CanarySetting`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-canarysetting
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getCanarySetting();

    /**
     * `AWS::ApiGateway::Stage.ClientCertificateId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-clientcertificateid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getClientCertificateId();

    /**
     * `AWS::ApiGateway::Stage.DeploymentId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-deploymentid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDeploymentId();

    /**
     * `AWS::ApiGateway::Stage.Description`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-description
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDescription();

    /**
     * `AWS::ApiGateway::Stage.DocumentationVersion`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-documentationversion
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getDocumentationVersion();

    /**
     * `AWS::ApiGateway::Stage.MethodSettings`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-methodsettings
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getMethodSettings();

    /**
     * `AWS::ApiGateway::Stage.StageName`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-stagename
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getStageName();

    /**
     * `AWS::ApiGateway::Stage.Tags`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tags
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<software.amazon.awscdk.core.CfnTag> getTags();

    /**
     * `AWS::ApiGateway::Stage.TracingEnabled`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-tracingenabled
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getTracingEnabled();

    /**
     * `AWS::ApiGateway::Stage.Variables`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-stage.html#cfn-apigateway-stage-variables
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Object getVariables();

    /**
     * @return a {@link Builder} of {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String restApiId;
        private java.lang.Object accessLogSetting;
        private java.lang.Object cacheClusterEnabled;
        private java.lang.String cacheClusterSize;
        private java.lang.Object canarySetting;
        private java.lang.String clientCertificateId;
        private java.lang.String deploymentId;
        private java.lang.String description;
        private java.lang.String documentationVersion;
        private java.lang.Object methodSettings;
        private java.lang.String stageName;
        private java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private java.lang.Object tracingEnabled;
        private java.lang.Object variables;

        /**
         * Sets the value of RestApiId
         * @param restApiId `AWS::ApiGateway::Stage.RestApiId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder restApiId(java.lang.String restApiId) {
            this.restApiId = restApiId;
            return this;
        }

        /**
         * Sets the value of AccessLogSetting
         * @param accessLogSetting `AWS::ApiGateway::Stage.AccessLogSetting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(software.amazon.awscdk.core.IResolvable accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of AccessLogSetting
         * @param accessLogSetting `AWS::ApiGateway::Stage.AccessLogSetting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder accessLogSetting(software.amazon.awscdk.services.apigateway.CfnStage.AccessLogSettingProperty accessLogSetting) {
            this.accessLogSetting = accessLogSetting;
            return this;
        }

        /**
         * Sets the value of CacheClusterEnabled
         * @param cacheClusterEnabled `AWS::ApiGateway::Stage.CacheClusterEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(java.lang.Boolean cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of CacheClusterEnabled
         * @param cacheClusterEnabled `AWS::ApiGateway::Stage.CacheClusterEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterEnabled(software.amazon.awscdk.core.IResolvable cacheClusterEnabled) {
            this.cacheClusterEnabled = cacheClusterEnabled;
            return this;
        }

        /**
         * Sets the value of CacheClusterSize
         * @param cacheClusterSize `AWS::ApiGateway::Stage.CacheClusterSize`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder cacheClusterSize(java.lang.String cacheClusterSize) {
            this.cacheClusterSize = cacheClusterSize;
            return this;
        }

        /**
         * Sets the value of CanarySetting
         * @param canarySetting `AWS::ApiGateway::Stage.CanarySetting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder canarySetting(software.amazon.awscdk.core.IResolvable canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of CanarySetting
         * @param canarySetting `AWS::ApiGateway::Stage.CanarySetting`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder canarySetting(software.amazon.awscdk.services.apigateway.CfnStage.CanarySettingProperty canarySetting) {
            this.canarySetting = canarySetting;
            return this;
        }

        /**
         * Sets the value of ClientCertificateId
         * @param clientCertificateId `AWS::ApiGateway::Stage.ClientCertificateId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder clientCertificateId(java.lang.String clientCertificateId) {
            this.clientCertificateId = clientCertificateId;
            return this;
        }

        /**
         * Sets the value of DeploymentId
         * @param deploymentId `AWS::ApiGateway::Stage.DeploymentId`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder deploymentId(java.lang.String deploymentId) {
            this.deploymentId = deploymentId;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description `AWS::ApiGateway::Stage.Description`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of DocumentationVersion
         * @param documentationVersion `AWS::ApiGateway::Stage.DocumentationVersion`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder documentationVersion(java.lang.String documentationVersion) {
            this.documentationVersion = documentationVersion;
            return this;
        }

        /**
         * Sets the value of MethodSettings
         * @param methodSettings `AWS::ApiGateway::Stage.MethodSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(software.amazon.awscdk.core.IResolvable methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of MethodSettings
         * @param methodSettings `AWS::ApiGateway::Stage.MethodSettings`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder methodSettings(java.util.List<java.lang.Object> methodSettings) {
            this.methodSettings = methodSettings;
            return this;
        }

        /**
         * Sets the value of StageName
         * @param stageName `AWS::ApiGateway::Stage.StageName`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder stageName(java.lang.String stageName) {
            this.stageName = stageName;
            return this;
        }

        /**
         * Sets the value of Tags
         * @param tags `AWS::ApiGateway::Stage.Tags`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tags(java.util.List<software.amazon.awscdk.core.CfnTag> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of TracingEnabled
         * @param tracingEnabled `AWS::ApiGateway::Stage.TracingEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(java.lang.Boolean tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of TracingEnabled
         * @param tracingEnabled `AWS::ApiGateway::Stage.TracingEnabled`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder tracingEnabled(software.amazon.awscdk.core.IResolvable tracingEnabled) {
            this.tracingEnabled = tracingEnabled;
            return this;
        }

        /**
         * Sets the value of Variables
         * @param variables `AWS::ApiGateway::Stage.Variables`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(software.amazon.awscdk.core.IResolvable variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Sets the value of Variables
         * @param variables `AWS::ApiGateway::Stage.Variables`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder variables(java.util.Map<java.lang.String, java.lang.String> variables) {
            this.variables = variables;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnStageProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnStageProps build() {
            return new Jsii$Proxy(restApiId, accessLogSetting, cacheClusterEnabled, cacheClusterSize, canarySetting, clientCertificateId, deploymentId, description, documentationVersion, methodSettings, stageName, tags, tracingEnabled, variables);
        }
    }

    /**
     * An implementation for {@link CfnStageProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnStageProps {
        private final java.lang.String restApiId;
        private final java.lang.Object accessLogSetting;
        private final java.lang.Object cacheClusterEnabled;
        private final java.lang.String cacheClusterSize;
        private final java.lang.Object canarySetting;
        private final java.lang.String clientCertificateId;
        private final java.lang.String deploymentId;
        private final java.lang.String description;
        private final java.lang.String documentationVersion;
        private final java.lang.Object methodSettings;
        private final java.lang.String stageName;
        private final java.util.List<software.amazon.awscdk.core.CfnTag> tags;
        private final java.lang.Object tracingEnabled;
        private final java.lang.Object variables;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.restApiId = this.jsiiGet("restApiId", java.lang.String.class);
            this.accessLogSetting = this.jsiiGet("accessLogSetting", java.lang.Object.class);
            this.cacheClusterEnabled = this.jsiiGet("cacheClusterEnabled", java.lang.Object.class);
            this.cacheClusterSize = this.jsiiGet("cacheClusterSize", java.lang.String.class);
            this.canarySetting = this.jsiiGet("canarySetting", java.lang.Object.class);
            this.clientCertificateId = this.jsiiGet("clientCertificateId", java.lang.String.class);
            this.deploymentId = this.jsiiGet("deploymentId", java.lang.String.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.documentationVersion = this.jsiiGet("documentationVersion", java.lang.String.class);
            this.methodSettings = this.jsiiGet("methodSettings", java.lang.Object.class);
            this.stageName = this.jsiiGet("stageName", java.lang.String.class);
            this.tags = this.jsiiGet("tags", java.util.List.class);
            this.tracingEnabled = this.jsiiGet("tracingEnabled", java.lang.Object.class);
            this.variables = this.jsiiGet("variables", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String restApiId, java.lang.Object accessLogSetting, java.lang.Object cacheClusterEnabled, java.lang.String cacheClusterSize, java.lang.Object canarySetting, java.lang.String clientCertificateId, java.lang.String deploymentId, java.lang.String description, java.lang.String documentationVersion, java.lang.Object methodSettings, java.lang.String stageName, java.util.List<software.amazon.awscdk.core.CfnTag> tags, java.lang.Object tracingEnabled, java.lang.Object variables) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.restApiId = java.util.Objects.requireNonNull(restApiId, "restApiId is required");
            this.accessLogSetting = accessLogSetting;
            this.cacheClusterEnabled = cacheClusterEnabled;
            this.cacheClusterSize = cacheClusterSize;
            this.canarySetting = canarySetting;
            this.clientCertificateId = clientCertificateId;
            this.deploymentId = deploymentId;
            this.description = description;
            this.documentationVersion = documentationVersion;
            this.methodSettings = methodSettings;
            this.stageName = stageName;
            this.tags = tags;
            this.tracingEnabled = tracingEnabled;
            this.variables = variables;
        }

        @Override
        public java.lang.String getRestApiId() {
            return this.restApiId;
        }

        @Override
        public java.lang.Object getAccessLogSetting() {
            return this.accessLogSetting;
        }

        @Override
        public java.lang.Object getCacheClusterEnabled() {
            return this.cacheClusterEnabled;
        }

        @Override
        public java.lang.String getCacheClusterSize() {
            return this.cacheClusterSize;
        }

        @Override
        public java.lang.Object getCanarySetting() {
            return this.canarySetting;
        }

        @Override
        public java.lang.String getClientCertificateId() {
            return this.clientCertificateId;
        }

        @Override
        public java.lang.String getDeploymentId() {
            return this.deploymentId;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getDocumentationVersion() {
            return this.documentationVersion;
        }

        @Override
        public java.lang.Object getMethodSettings() {
            return this.methodSettings;
        }

        @Override
        public java.lang.String getStageName() {
            return this.stageName;
        }

        @Override
        public java.util.List<software.amazon.awscdk.core.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        public java.lang.Object getTracingEnabled() {
            return this.tracingEnabled;
        }

        @Override
        public java.lang.Object getVariables() {
            return this.variables;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("restApiId", om.valueToTree(this.getRestApiId()));
            if (this.getAccessLogSetting() != null) {
                obj.set("accessLogSetting", om.valueToTree(this.getAccessLogSetting()));
            }
            if (this.getCacheClusterEnabled() != null) {
                obj.set("cacheClusterEnabled", om.valueToTree(this.getCacheClusterEnabled()));
            }
            if (this.getCacheClusterSize() != null) {
                obj.set("cacheClusterSize", om.valueToTree(this.getCacheClusterSize()));
            }
            if (this.getCanarySetting() != null) {
                obj.set("canarySetting", om.valueToTree(this.getCanarySetting()));
            }
            if (this.getClientCertificateId() != null) {
                obj.set("clientCertificateId", om.valueToTree(this.getClientCertificateId()));
            }
            if (this.getDeploymentId() != null) {
                obj.set("deploymentId", om.valueToTree(this.getDeploymentId()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getDocumentationVersion() != null) {
                obj.set("documentationVersion", om.valueToTree(this.getDocumentationVersion()));
            }
            if (this.getMethodSettings() != null) {
                obj.set("methodSettings", om.valueToTree(this.getMethodSettings()));
            }
            if (this.getStageName() != null) {
                obj.set("stageName", om.valueToTree(this.getStageName()));
            }
            if (this.getTags() != null) {
                obj.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTracingEnabled() != null) {
                obj.set("tracingEnabled", om.valueToTree(this.getTracingEnabled()));
            }
            if (this.getVariables() != null) {
                obj.set("variables", om.valueToTree(this.getVariables()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnStageProps.Jsii$Proxy that = (CfnStageProps.Jsii$Proxy) o;

            if (!restApiId.equals(that.restApiId)) return false;
            if (this.accessLogSetting != null ? !this.accessLogSetting.equals(that.accessLogSetting) : that.accessLogSetting != null) return false;
            if (this.cacheClusterEnabled != null ? !this.cacheClusterEnabled.equals(that.cacheClusterEnabled) : that.cacheClusterEnabled != null) return false;
            if (this.cacheClusterSize != null ? !this.cacheClusterSize.equals(that.cacheClusterSize) : that.cacheClusterSize != null) return false;
            if (this.canarySetting != null ? !this.canarySetting.equals(that.canarySetting) : that.canarySetting != null) return false;
            if (this.clientCertificateId != null ? !this.clientCertificateId.equals(that.clientCertificateId) : that.clientCertificateId != null) return false;
            if (this.deploymentId != null ? !this.deploymentId.equals(that.deploymentId) : that.deploymentId != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.documentationVersion != null ? !this.documentationVersion.equals(that.documentationVersion) : that.documentationVersion != null) return false;
            if (this.methodSettings != null ? !this.methodSettings.equals(that.methodSettings) : that.methodSettings != null) return false;
            if (this.stageName != null ? !this.stageName.equals(that.stageName) : that.stageName != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            if (this.tracingEnabled != null ? !this.tracingEnabled.equals(that.tracingEnabled) : that.tracingEnabled != null) return false;
            return this.variables != null ? this.variables.equals(that.variables) : that.variables == null;
        }

        @Override
        public int hashCode() {
            int result = this.restApiId.hashCode();
            result = 31 * result + (this.accessLogSetting != null ? this.accessLogSetting.hashCode() : 0);
            result = 31 * result + (this.cacheClusterEnabled != null ? this.cacheClusterEnabled.hashCode() : 0);
            result = 31 * result + (this.cacheClusterSize != null ? this.cacheClusterSize.hashCode() : 0);
            result = 31 * result + (this.canarySetting != null ? this.canarySetting.hashCode() : 0);
            result = 31 * result + (this.clientCertificateId != null ? this.clientCertificateId.hashCode() : 0);
            result = 31 * result + (this.deploymentId != null ? this.deploymentId.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.documentationVersion != null ? this.documentationVersion.hashCode() : 0);
            result = 31 * result + (this.methodSettings != null ? this.methodSettings.hashCode() : 0);
            result = 31 * result + (this.stageName != null ? this.stageName.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.tracingEnabled != null ? this.tracingEnabled.hashCode() : 0);
            result = 31 * result + (this.variables != null ? this.variables.hashCode() : 0);
            return result;
        }
    }
}
