package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T12:35:42.193Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface UsagePlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * ApiKey to be associated with the usage plan.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IApiKey getApiKey();

    /**
     * API Stages to be associated which the usage plan.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages();

    /**
     * Represents usage plan purpose.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getDescription();

    /**
     * Name for this usage plan.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getName();

    /**
     * Number of requests clients can make in a given time period.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.QuotaSettings getQuota();

    /**
     * Overall throttle settings for the API.
     * 
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle();

    /**
     * @return a {@link Builder} of {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.apigateway.IApiKey apiKey;
        private java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        private java.lang.String description;
        private java.lang.String name;
        private software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        private software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Sets the value of ApiKey
         * @param apiKey ApiKey to be associated with the usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKey(software.amazon.awscdk.services.apigateway.IApiKey apiKey) {
            this.apiKey = apiKey;
            return this;
        }

        /**
         * Sets the value of ApiStages
         * @param apiStages API Stages to be associated which the usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiStages(java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages) {
            this.apiStages = apiStages;
            return this;
        }

        /**
         * Sets the value of Description
         * @param description Represents usage plan purpose.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name Name for this usage plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of Quota
         * @param quota Number of requests clients can make in a given time period.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder quota(software.amazon.awscdk.services.apigateway.QuotaSettings quota) {
            this.quota = quota;
            return this;
        }

        /**
         * Sets the value of Throttle
         * @param throttle Overall throttle settings for the API.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throttle(software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            this.throttle = throttle;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link UsagePlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public UsagePlanProps build() {
            return new Jsii$Proxy(apiKey, apiStages, description, name, quota, throttle);
        }
    }

    /**
     * An implementation for {@link UsagePlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements UsagePlanProps {
        private final software.amazon.awscdk.services.apigateway.IApiKey apiKey;
        private final java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages;
        private final java.lang.String description;
        private final java.lang.String name;
        private final software.amazon.awscdk.services.apigateway.QuotaSettings quota;
        private final software.amazon.awscdk.services.apigateway.ThrottleSettings throttle;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.apiKey = this.jsiiGet("apiKey", software.amazon.awscdk.services.apigateway.IApiKey.class);
            this.apiStages = this.jsiiGet("apiStages", java.util.List.class);
            this.description = this.jsiiGet("description", java.lang.String.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.quota = this.jsiiGet("quota", software.amazon.awscdk.services.apigateway.QuotaSettings.class);
            this.throttle = this.jsiiGet("throttle", software.amazon.awscdk.services.apigateway.ThrottleSettings.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.apigateway.IApiKey apiKey, java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> apiStages, java.lang.String description, java.lang.String name, software.amazon.awscdk.services.apigateway.QuotaSettings quota, software.amazon.awscdk.services.apigateway.ThrottleSettings throttle) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKey = apiKey;
            this.apiStages = apiStages;
            this.description = description;
            this.name = name;
            this.quota = quota;
            this.throttle = throttle;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IApiKey getApiKey() {
            return this.apiKey;
        }

        @Override
        public java.util.List<software.amazon.awscdk.services.apigateway.UsagePlanPerApiStage> getApiStages() {
            return this.apiStages;
        }

        @Override
        public java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.QuotaSettings getQuota() {
            return this.quota;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.ThrottleSettings getThrottle() {
            return this.throttle;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            if (this.getApiKey() != null) {
                obj.set("apiKey", om.valueToTree(this.getApiKey()));
            }
            if (this.getApiStages() != null) {
                obj.set("apiStages", om.valueToTree(this.getApiStages()));
            }
            if (this.getDescription() != null) {
                obj.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getName() != null) {
                obj.set("name", om.valueToTree(this.getName()));
            }
            if (this.getQuota() != null) {
                obj.set("quota", om.valueToTree(this.getQuota()));
            }
            if (this.getThrottle() != null) {
                obj.set("throttle", om.valueToTree(this.getThrottle()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            UsagePlanProps.Jsii$Proxy that = (UsagePlanProps.Jsii$Proxy) o;

            if (this.apiKey != null ? !this.apiKey.equals(that.apiKey) : that.apiKey != null) return false;
            if (this.apiStages != null ? !this.apiStages.equals(that.apiStages) : that.apiStages != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.name != null ? !this.name.equals(that.name) : that.name != null) return false;
            if (this.quota != null ? !this.quota.equals(that.quota) : that.quota != null) return false;
            return this.throttle != null ? this.throttle.equals(that.throttle) : that.throttle == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiKey != null ? this.apiKey.hashCode() : 0;
            result = 31 * result + (this.apiStages != null ? this.apiStages.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
            result = 31 * result + (this.quota != null ? this.quota.hashCode() : 0);
            result = 31 * result + (this.throttle != null ? this.throttle.hashCode() : 0);
            return result;
        }
    }
}
