package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T20:01:03.991Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies an API method integration type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationType getType();

    /**
     * The integration's HTTP method type. Required unless you use a MOCK integration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getIntegrationHttpMethod();

    /**
     * Integration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions();

    /**
     * The Uniform Resource Identifier (URI) for the integration.
     * 
     * - If you specify HTTP for the `type` property, specify the API endpoint URL.
     * - If you specify MOCK for the `type` property, don't specify this property.
     * - If you specify AWS for the `type` property, specify an AWS service that
     *    follows this form: `arn:aws:apigateway:region:subdomain.service|service:path|action/service_api.`
     *    For example, a Lambda function URI follows this form:
     *    arn:aws:apigateway:region:lambda:path/path. The path is usually in the
     *    form /2015-03-31/functions/LambdaFunctionARN/invocations.
     * 
     * @see https://docs.aws.amazon.com/apigateway/api-reference/resource/integration/#uri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.Object getUri();

    /**
     * @return a {@link Builder} of {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private software.amazon.awscdk.services.apigateway.IntegrationType type;
        private java.lang.String integrationHttpMethod;
        private software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private java.lang.Object uri;

        /**
         * Sets the value of Type
         * @param type Specifies an API method integration type. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder type(software.amazon.awscdk.services.apigateway.IntegrationType type) {
            this.type = type;
            return this;
        }

        /**
         * Sets the value of IntegrationHttpMethod
         * @param integrationHttpMethod The integration's HTTP method type. Required unless you use a MOCK integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationHttpMethod(java.lang.String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        /**
         * Sets the value of Options
         * @param options Integration options.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder options(software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
            this.options = options;
            return this;
        }

        /**
         * Sets the value of Uri
         * @param uri The Uniform Resource Identifier (URI) for the integration.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder uri(java.lang.Object uri) {
            this.uri = uri;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public IntegrationProps build() {
            return new Jsii$Proxy(type, integrationHttpMethod, options, uri);
        }
    }

    /**
     * An implementation for {@link IntegrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationProps {
        private final software.amazon.awscdk.services.apigateway.IntegrationType type;
        private final java.lang.String integrationHttpMethod;
        private final software.amazon.awscdk.services.apigateway.IntegrationOptions options;
        private final java.lang.Object uri;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.type = this.jsiiGet("type", software.amazon.awscdk.services.apigateway.IntegrationType.class);
            this.integrationHttpMethod = this.jsiiGet("integrationHttpMethod", java.lang.String.class);
            this.options = this.jsiiGet("options", software.amazon.awscdk.services.apigateway.IntegrationOptions.class);
            this.uri = this.jsiiGet("uri", java.lang.Object.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(software.amazon.awscdk.services.apigateway.IntegrationType type, java.lang.String integrationHttpMethod, software.amazon.awscdk.services.apigateway.IntegrationOptions options, java.lang.Object uri) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.type = java.util.Objects.requireNonNull(type, "type is required");
            this.integrationHttpMethod = integrationHttpMethod;
            this.options = options;
            this.uri = uri;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationType getType() {
            return this.type;
        }

        @Override
        public java.lang.String getIntegrationHttpMethod() {
            return this.integrationHttpMethod;
        }

        @Override
        public software.amazon.awscdk.services.apigateway.IntegrationOptions getOptions() {
            return this.options;
        }

        @Override
        public java.lang.Object getUri() {
            return this.uri;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("type", om.valueToTree(this.getType()));
            if (this.getIntegrationHttpMethod() != null) {
                obj.set("integrationHttpMethod", om.valueToTree(this.getIntegrationHttpMethod()));
            }
            if (this.getOptions() != null) {
                obj.set("options", om.valueToTree(this.getOptions()));
            }
            if (this.getUri() != null) {
                obj.set("uri", om.valueToTree(this.getUri()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationProps.Jsii$Proxy that = (IntegrationProps.Jsii$Proxy) o;

            if (!type.equals(that.type)) return false;
            if (this.integrationHttpMethod != null ? !this.integrationHttpMethod.equals(that.integrationHttpMethod) : that.integrationHttpMethod != null) return false;
            if (this.options != null ? !this.options.equals(that.options) : that.options != null) return false;
            return this.uri != null ? this.uri.equals(that.uri) : that.uri == null;
        }

        @Override
        public int hashCode() {
            int result = this.type.hashCode();
            result = 31 * result + (this.integrationHttpMethod != null ? this.integrationHttpMethod.hashCode() : 0);
            result = 31 * result + (this.options != null ? this.options.hashCode() : 0);
            result = 31 * result + (this.uri != null ? this.uri.hashCode() : 0);
            return result;
        }
    }
}
