package software.amazon.awscdk.services.apigateway;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-15T20:01:03.998Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface MethodResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * The method response's status code, which you map to an IntegrationResponse. Required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.lang.String getStatusCode();

    /**
     * The resources used for the response's content type.
     * 
     * Specify response models as
     * key-value pairs (string-to-string maps), with a content type as the key and a Model
     * resource name as the value.
     * 
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels();

    /**
     * Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required.
     * 
     * Default: None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters();

    /**
     * @return a {@link Builder} of {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder {
        private java.lang.String statusCode;
        private java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels;
        private java.util.Map<java.lang.String, java.lang.Boolean> responseParameters;

        /**
         * Sets the value of StatusCode
         * @param statusCode The method response's status code, which you map to an IntegrationResponse. Required. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of ResponseModels
         * @param responseModels The resources used for the response's content type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseModels(java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels) {
            this.responseModels = responseModels;
            return this;
        }

        /**
         * Sets the value of ResponseParameters
         * @param responseParameters Response parameters that API Gateway sends to the client that called a method. Specify response parameters as key-value pairs (string-to-Boolean maps), with a destination as the key and a Boolean as the value. Specify the destination using the following pattern: method.response.header.name, where the name is a valid, unique header name. The Boolean specifies whether a parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(java.util.Map<java.lang.String, java.lang.Boolean> responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link MethodResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public MethodResponse build() {
            return new Jsii$Proxy(statusCode, responseModels, responseParameters);
        }
    }

    /**
     * An implementation for {@link MethodResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MethodResponse {
        private final java.lang.String statusCode;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels;
        private final java.util.Map<java.lang.String, java.lang.Boolean> responseParameters;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.statusCode = this.jsiiGet("statusCode", java.lang.String.class);
            this.responseModels = this.jsiiGet("responseModels", java.util.Map.class);
            this.responseParameters = this.jsiiGet("responseParameters", java.util.Map.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String statusCode, java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> responseModels, java.util.Map<java.lang.String, java.lang.Boolean> responseParameters) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statusCode = java.util.Objects.requireNonNull(statusCode, "statusCode is required");
            this.responseModels = responseModels;
            this.responseParameters = responseParameters;
        }

        @Override
        public java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public java.util.Map<java.lang.String, software.amazon.awscdk.services.apigateway.IModel> getResponseModels() {
            return this.responseModels;
        }

        @Override
        public java.util.Map<java.lang.String, java.lang.Boolean> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("statusCode", om.valueToTree(this.getStatusCode()));
            if (this.getResponseModels() != null) {
                obj.set("responseModels", om.valueToTree(this.getResponseModels()));
            }
            if (this.getResponseParameters() != null) {
                obj.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            MethodResponse.Jsii$Proxy that = (MethodResponse.Jsii$Proxy) o;

            if (!statusCode.equals(that.statusCode)) return false;
            if (this.responseModels != null ? !this.responseModels.equals(that.responseModels) : that.responseModels != null) return false;
            return this.responseParameters != null ? this.responseParameters.equals(that.responseParameters) : that.responseParameters == null;
        }

        @Override
        public int hashCode() {
            int result = this.statusCode.hashCode();
            result = 31 * result + (this.responseModels != null ? this.responseModels.hashCode() : 0);
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            return result;
        }
    }
}
