/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.apigateway;

import java.util.Map;
import software.amazon.awscdk.services.apigateway.AwsIntegrationProps;
import software.amazon.awscdk.services.apigateway.IntegrationOptions;
import software.amazon.jsii.JsiiSerializable;

public interface AwsIntegrationProps
extends JsiiSerializable {
    public String getService();

    public String getAction();

    public Map<String, String> getActionParameters();

    public String getIntegrationHttpMethod();

    public IntegrationOptions getOptions();

    public String getPath();

    public Boolean getProxy();

    public String getSubdomain();

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private String service;
        private String action;
        private Map<String, String> actionParameters;
        private String integrationHttpMethod;
        private IntegrationOptions options;
        private String path;
        private Boolean proxy;
        private String subdomain;

        public Builder service(String service) {
            this.service = service;
            return this;
        }

        public Builder action(String action) {
            this.action = action;
            return this;
        }

        public Builder actionParameters(Map<String, String> actionParameters) {
            this.actionParameters = actionParameters;
            return this;
        }

        public Builder integrationHttpMethod(String integrationHttpMethod) {
            this.integrationHttpMethod = integrationHttpMethod;
            return this;
        }

        public Builder options(IntegrationOptions options) {
            this.options = options;
            return this;
        }

        public Builder path(String path) {
            this.path = path;
            return this;
        }

        public Builder proxy(Boolean proxy) {
            this.proxy = proxy;
            return this;
        }

        public Builder subdomain(String subdomain) {
            this.subdomain = subdomain;
            return this;
        }

        public AwsIntegrationProps build() {
            return new Jsii.Proxy(this.service, this.action, this.actionParameters, this.integrationHttpMethod, this.options, this.path, this.proxy, this.subdomain, null);
        }
    }
}

