package software.amazon.awscdk.services.apigateway;

/**
 * Base properties for all lambda authorizers.
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.42.0 (build 5f6b62c)", date = "2021-11-09T12:18:42.835Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.LambdaAuthorizerProps")
@software.amazon.jsii.Jsii.Proxy(LambdaAuthorizerProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface LambdaAuthorizerProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The handler for the authorizer lambda function.
     * <p>
     * The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
     * API Gateway has documented the handler's input specification
     * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
     * {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.lambda.IFunction getHandler();

    /**
     * An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
     * <p>
     * The IAM role must be
     * assumable by 'apigateway.amazonaws.com'.
     * <p>
     * Default: - A resource policy is added to the Lambda function allowing apigateway.amazonaws.com to invoke the function.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getAssumeRole() {
        return null;
    }

    /**
     * An optional human friendly name for the authorizer.
     * <p>
     * Note that, this is not the primary identifier of the authorizer.
     * <p>
     * Default: - the unique construcrt ID
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerName() {
        return null;
    }

    /**
     * How long APIGateway should cache the results.
     * <p>
     * Max 1 hour.
     * Disable caching by setting this to 0.
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.Duration getResultsCacheTtl() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link LambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link LambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<LambdaAuthorizerProps> {
        private software.amazon.awscdk.services.lambda.IFunction handler;
        private software.amazon.awscdk.services.iam.IRole assumeRole;
        private java.lang.String authorizerName;
        private software.amazon.awscdk.core.Duration resultsCacheTtl;

        /**
         * Sets the value of {@link LambdaAuthorizerProps#getHandler}
         * @param handler The handler for the authorizer lambda function. This parameter is required.
         *                The handler must follow a very specific protocol on the input it receives and the output it needs to produce.
         *                API Gateway has documented the handler's input specification
         *                {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-input.html | here} and output specification
         *                {&#64;link https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-lambda-authorizer-output.html | here}.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder handler(software.amazon.awscdk.services.lambda.IFunction handler) {
            this.handler = handler;
            return this;
        }

        /**
         * Sets the value of {@link LambdaAuthorizerProps#getAssumeRole}
         * @param assumeRole An optional IAM role for APIGateway to assume before calling the Lambda-based authorizer.
         *                   The IAM role must be
         *                   assumable by 'apigateway.amazonaws.com'.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assumeRole(software.amazon.awscdk.services.iam.IRole assumeRole) {
            this.assumeRole = assumeRole;
            return this;
        }

        /**
         * Sets the value of {@link LambdaAuthorizerProps#getAuthorizerName}
         * @param authorizerName An optional human friendly name for the authorizer.
         *                       Note that, this is not the primary identifier of the authorizer.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(java.lang.String authorizerName) {
            this.authorizerName = authorizerName;
            return this;
        }

        /**
         * Sets the value of {@link LambdaAuthorizerProps#getResultsCacheTtl}
         * @param resultsCacheTtl How long APIGateway should cache the results.
         *                        Max 1 hour.
         *                        Disable caching by setting this to 0.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultsCacheTtl(software.amazon.awscdk.core.Duration resultsCacheTtl) {
            this.resultsCacheTtl = resultsCacheTtl;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link LambdaAuthorizerProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public LambdaAuthorizerProps build() {
            return new Jsii$Proxy(handler, assumeRole, authorizerName, resultsCacheTtl);
        }
    }

    /**
     * An implementation for {@link LambdaAuthorizerProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaAuthorizerProps {
        private final software.amazon.awscdk.services.lambda.IFunction handler;
        private final software.amazon.awscdk.services.iam.IRole assumeRole;
        private final java.lang.String authorizerName;
        private final software.amazon.awscdk.core.Duration resultsCacheTtl;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.handler = software.amazon.jsii.Kernel.get(this, "handler", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.lambda.IFunction.class));
            this.assumeRole = software.amazon.jsii.Kernel.get(this, "assumeRole", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.authorizerName = software.amazon.jsii.Kernel.get(this, "authorizerName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.resultsCacheTtl = software.amazon.jsii.Kernel.get(this, "resultsCacheTtl", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.core.Duration.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final software.amazon.awscdk.services.lambda.IFunction handler, final software.amazon.awscdk.services.iam.IRole assumeRole, final java.lang.String authorizerName, final software.amazon.awscdk.core.Duration resultsCacheTtl) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.handler = java.util.Objects.requireNonNull(handler, "handler is required");
            this.assumeRole = assumeRole;
            this.authorizerName = authorizerName;
            this.resultsCacheTtl = resultsCacheTtl;
        }

        @Override
        public final software.amazon.awscdk.services.lambda.IFunction getHandler() {
            return this.handler;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getAssumeRole() {
            return this.assumeRole;
        }

        @Override
        public final java.lang.String getAuthorizerName() {
            return this.authorizerName;
        }

        @Override
        public final software.amazon.awscdk.core.Duration getResultsCacheTtl() {
            return this.resultsCacheTtl;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("handler", om.valueToTree(this.getHandler()));
            if (this.getAssumeRole() != null) {
                data.set("assumeRole", om.valueToTree(this.getAssumeRole()));
            }
            if (this.getAuthorizerName() != null) {
                data.set("authorizerName", om.valueToTree(this.getAuthorizerName()));
            }
            if (this.getResultsCacheTtl() != null) {
                data.set("resultsCacheTtl", om.valueToTree(this.getResultsCacheTtl()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.LambdaAuthorizerProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            LambdaAuthorizerProps.Jsii$Proxy that = (LambdaAuthorizerProps.Jsii$Proxy) o;

            if (!handler.equals(that.handler)) return false;
            if (this.assumeRole != null ? !this.assumeRole.equals(that.assumeRole) : that.assumeRole != null) return false;
            if (this.authorizerName != null ? !this.authorizerName.equals(that.authorizerName) : that.authorizerName != null) return false;
            return this.resultsCacheTtl != null ? this.resultsCacheTtl.equals(that.resultsCacheTtl) : that.resultsCacheTtl == null;
        }

        @Override
        public final int hashCode() {
            int result = this.handler.hashCode();
            result = 31 * result + (this.assumeRole != null ? this.assumeRole.hashCode() : 0);
            result = 31 * result + (this.authorizerName != null ? this.authorizerName.hashCode() : 0);
            result = 31 * result + (this.resultsCacheTtl != null ? this.resultsCacheTtl.hashCode() : 0);
            return result;
        }
    }
}
