package software.amazon.awscdk.services.apigateway;

/**
 * The options for creating an API Key.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * IApiKey key = api.addApiKey("ApiKey", ApiKeyOptions.builder()
 *         .apiKeyName("myApiKey1")
 *         .value("MyApiKeyThatIsAtLeast20Characters")
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:56.080Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.ApiKeyOptions")
@software.amazon.jsii.Jsii.Proxy(ApiKeyOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface ApiKeyOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.apigateway.ResourceOptions {

    /**
     * A name for the API key.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
     * <p>
     * Default: automically generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getApiKeyName() {
        return null;
    }

    /**
     * A description of the purpose of the API key.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The value of the API key.
     * <p>
     * Must be at least 20 characters long.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getValue() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link ApiKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link ApiKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<ApiKeyOptions> {
        java.lang.String apiKeyName;
        java.lang.String description;
        java.lang.String value;
        software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Sets the value of {@link ApiKeyOptions#getApiKeyName}
         * @param apiKeyName A name for the API key.
         *                   If you don't specify a name, AWS CloudFormation generates a unique physical ID and uses that ID for the API key name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiKeyName(java.lang.String apiKeyName) {
            this.apiKeyName = apiKeyName;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyOptions#getDescription}
         * @param description A description of the purpose of the API key.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyOptions#getValue}
         * @param value The value of the API key.
         *              Must be at least 20 characters long.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder value(java.lang.String value) {
            this.value = value;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyOptions#getDefaultCorsPreflightOptions}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources.
         *                                    You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.defaultCorsPreflightOptions = defaultCorsPreflightOptions;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyOptions#getDefaultIntegration}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.defaultIntegration = defaultIntegration;
            return this;
        }

        /**
         * Sets the value of {@link ApiKeyOptions#getDefaultMethodOptions}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.defaultMethodOptions = defaultMethodOptions;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link ApiKeyOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public ApiKeyOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link ApiKeyOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ApiKeyOptions {
        private final java.lang.String apiKeyName;
        private final java.lang.String description;
        private final java.lang.String value;
        private final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions;
        private final software.amazon.awscdk.services.apigateway.Integration defaultIntegration;
        private final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiKeyName = software.amazon.jsii.Kernel.get(this, "apiKeyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.value = software.amazon.jsii.Kernel.get(this, "value", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.defaultCorsPreflightOptions = software.amazon.jsii.Kernel.get(this, "defaultCorsPreflightOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CorsOptions.class));
            this.defaultIntegration = software.amazon.jsii.Kernel.get(this, "defaultIntegration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Integration.class));
            this.defaultMethodOptions = software.amazon.jsii.Kernel.get(this, "defaultMethodOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodOptions.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiKeyName = builder.apiKeyName;
            this.description = builder.description;
            this.value = builder.value;
            this.defaultCorsPreflightOptions = builder.defaultCorsPreflightOptions;
            this.defaultIntegration = builder.defaultIntegration;
            this.defaultMethodOptions = builder.defaultMethodOptions;
        }

        @Override
        public final java.lang.String getApiKeyName() {
            return this.apiKeyName;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getValue() {
            return this.value;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
            return this.defaultCorsPreflightOptions;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
            return this.defaultIntegration;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
            return this.defaultMethodOptions;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getApiKeyName() != null) {
                data.set("apiKeyName", om.valueToTree(this.getApiKeyName()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getValue() != null) {
                data.set("value", om.valueToTree(this.getValue()));
            }
            if (this.getDefaultCorsPreflightOptions() != null) {
                data.set("defaultCorsPreflightOptions", om.valueToTree(this.getDefaultCorsPreflightOptions()));
            }
            if (this.getDefaultIntegration() != null) {
                data.set("defaultIntegration", om.valueToTree(this.getDefaultIntegration()));
            }
            if (this.getDefaultMethodOptions() != null) {
                data.set("defaultMethodOptions", om.valueToTree(this.getDefaultMethodOptions()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.ApiKeyOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            ApiKeyOptions.Jsii$Proxy that = (ApiKeyOptions.Jsii$Proxy) o;

            if (this.apiKeyName != null ? !this.apiKeyName.equals(that.apiKeyName) : that.apiKeyName != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.value != null ? !this.value.equals(that.value) : that.value != null) return false;
            if (this.defaultCorsPreflightOptions != null ? !this.defaultCorsPreflightOptions.equals(that.defaultCorsPreflightOptions) : that.defaultCorsPreflightOptions != null) return false;
            if (this.defaultIntegration != null ? !this.defaultIntegration.equals(that.defaultIntegration) : that.defaultIntegration != null) return false;
            return this.defaultMethodOptions != null ? this.defaultMethodOptions.equals(that.defaultMethodOptions) : that.defaultMethodOptions == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiKeyName != null ? this.apiKeyName.hashCode() : 0;
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.value != null ? this.value.hashCode() : 0);
            result = 31 * result + (this.defaultCorsPreflightOptions != null ? this.defaultCorsPreflightOptions.hashCode() : 0);
            result = 31 * result + (this.defaultIntegration != null ? this.defaultIntegration.hashCode() : 0);
            result = 31 * result + (this.defaultMethodOptions != null ? this.defaultMethodOptions.hashCode() : 0);
            return result;
        }
    }
}
