package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * LambdaIntegration booksBackend;
 * RestApi api = RestApi.Builder.create(this, "books")
 *         .defaultIntegration(booksBackend)
 *         .build();
 * Resource books = api.root.addResource("books");
 * books.addMethod("GET"); // integrated with `booksBackend`
 * books.addMethod("POST"); // integrated with `booksBackend`
 * Resource book = books.addResource("{book_id}");
 * book.addMethod("GET");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-07T14:33:56.363Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.Resource")
public class Resource extends software.amazon.awscdk.services.apigateway.ResourceBase {

    protected Resource(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected Resource(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public Resource(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ResourceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import an existing resource.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IResource fromResourceAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.ResourceAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.Resource.class, "fromResourceAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * The rest API that this resource is part of.
     * <p>
     * The reason we need the RestApi object itself and not just the ID is because the model
     * is being tracked by the top-level RestApi object for the purpose of calculating it's
     * hash to determine the ID of the deployment. This allows us to automatically update
     * the deployment when the model of the REST API changes.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi getApi() {
        return software.amazon.jsii.Kernel.get(this, "api", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IRestApi.class));
    }

    /**
     * The full path of this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getPath() {
        return software.amazon.jsii.Kernel.get(this, "path", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The ID of the resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResourceId() {
        return software.amazon.jsii.Kernel.get(this, "resourceId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * (deprecated) The RestApi associated with this Resource.
     * <p>
     * @deprecated - Throws an error if this Resource is not associated with an instance of `RestApi`. Use `api` instead.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.RestApi getRestApi() {
        return software.amazon.jsii.Kernel.get(this, "restApi", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.RestApi.class));
    }

    /**
     * Default options for CORS preflight OPTIONS method.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.CorsOptions getDefaultCorsPreflightOptions() {
        return software.amazon.jsii.Kernel.get(this, "defaultCorsPreflightOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.CorsOptions.class));
    }

    /**
     * An integration to use as a default for all methods created within this API unless an integration is specified.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.Integration getDefaultIntegration() {
        return software.amazon.jsii.Kernel.get(this, "defaultIntegration", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.Integration.class));
    }

    /**
     * Method options to use as a default for all methods created within this API unless custom options are specified.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.MethodOptions getDefaultMethodOptions() {
        return software.amazon.jsii.Kernel.get(this, "defaultMethodOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.MethodOptions.class));
    }

    /**
     * The parent of this resource or undefined for the root resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IResource getParentResource() {
        return software.amazon.jsii.Kernel.get(this, "parentResource", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IResource.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.Resource}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.Resource> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.ResourceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.ResourceProps.Builder();
        }

        /**
         * Adds a CORS preflight OPTIONS method to this resource and all child resources.
         * <p>
         * You can add CORS at the resource-level using <code>addCorsPreflight</code>.
         * <p>
         * Default: - CORS is disabled
         * <p>
         * @return {@code this}
         * @param defaultCorsPreflightOptions Adds a CORS preflight OPTIONS method to this resource and all child resources. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCorsPreflightOptions(final software.amazon.awscdk.services.apigateway.CorsOptions defaultCorsPreflightOptions) {
            this.props.defaultCorsPreflightOptions(defaultCorsPreflightOptions);
            return this;
        }

        /**
         * An integration to use as a default for all methods created within this API unless an integration is specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultIntegration An integration to use as a default for all methods created within this API unless an integration is specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultIntegration(final software.amazon.awscdk.services.apigateway.Integration defaultIntegration) {
            this.props.defaultIntegration(defaultIntegration);
            return this;
        }

        /**
         * Method options to use as a default for all methods created within this API unless custom options are specified.
         * <p>
         * Default: - Inherited from parent.
         * <p>
         * @return {@code this}
         * @param defaultMethodOptions Method options to use as a default for all methods created within this API unless custom options are specified. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultMethodOptions(final software.amazon.awscdk.services.apigateway.MethodOptions defaultMethodOptions) {
            this.props.defaultMethodOptions(defaultMethodOptions);
            return this;
        }

        /**
         * The parent resource of this resource.
         * <p>
         * You can either pass another
         * <code>Resource</code> object or a <code>RestApi</code> object here.
         * <p>
         * @return {@code this}
         * @param parent The parent resource of this resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parent(final software.amazon.awscdk.services.apigateway.IResource parent) {
            this.props.parent(parent);
            return this;
        }

        /**
         * A path name for the resource.
         * <p>
         * @return {@code this}
         * @param pathPart A path name for the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathPart(final java.lang.String pathPart) {
            this.props.pathPart(pathPart);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.Resource}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.Resource build() {
            return new software.amazon.awscdk.services.apigateway.Resource(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
