package software.amazon.awscdk.services.apigateway;

/**
 * A CloudFormation `AWS::ApiGateway::GatewayResponse`.
 * <p>
 * The <code>AWS::ApiGateway::GatewayResponse</code> resource creates a gateway response for your API. For more information, see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/customize-gateway-responses.html#api-gateway-gatewayResponse-definition">API Gateway Responses</a> in the <em>API Gateway Developer Guide</em> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * CfnGatewayResponse cfnGatewayResponse = CfnGatewayResponse.Builder.create(this, "MyCfnGatewayResponse")
 *         .responseType("responseType")
 *         .restApiId("restApiId")
 *         // the properties below are optional
 *         .responseParameters(Map.of(
 *                 "responseParametersKey", "responseParameters"))
 *         .responseTemplates(Map.of(
 *                 "responseTemplatesKey", "responseTemplates"))
 *         .statusCode("statusCode")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-09T19:25:27.499Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.CfnGatewayResponse")
public class CfnGatewayResponse extends software.amazon.awscdk.core.CfnResource implements software.amazon.awscdk.core.IInspectable {

    protected CfnGatewayResponse(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnGatewayResponse(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.apigateway.CfnGatewayResponse.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Create a new `AWS::ApiGateway::GatewayResponse`.
     * <p>
     * @param scope - scope in which this resource is defined. This parameter is required.
     * @param id - scoped id of the resource. This parameter is required.
     * @param props - resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnGatewayResponse(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.CfnGatewayResponseProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector - tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.core.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The response type.
     * <p>
     * For valid values, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/gateway-response/">GatewayResponse</a> in the <em>API Gateway API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getResponseType() {
        return software.amazon.jsii.Kernel.get(this, "responseType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The response type.
     * <p>
     * For valid values, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/gateway-response/">GatewayResponse</a> in the <em>API Gateway API Reference</em> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseType(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "responseType", java.util.Objects.requireNonNull(value, "responseType is required"));
    }

    /**
     * The identifier of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getRestApiId() {
        return software.amazon.jsii.Kernel.get(this, "restApiId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The identifier of the API.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setRestApiId(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "restApiId", java.util.Objects.requireNonNull(value, "restApiId is required"));
    }

    /**
     * The response parameters (paths, query strings, and headers) for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResponseParameters() {
        return software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The response parameters (paths, query strings, and headers) for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseParameters(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "responseParameters", value);
    }

    /**
     * The response parameters (paths, query strings, and headers) for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseParameters(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "responseParameters", value);
    }

    /**
     * The response templates for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getResponseTemplates() {
        return software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The response templates for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseTemplates(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.core.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "responseTemplates", value);
    }

    /**
     * The response templates for the response.
     * <p>
     * Duplicates not allowed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setResponseTemplates(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "responseTemplates", value);
    }

    /**
     * The HTTP status code for the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getStatusCode() {
        return software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The HTTP status code for the response.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setStatusCode(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "statusCode", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.CfnGatewayResponse}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.CfnGatewayResponse> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope - scope in which this resource is defined. This parameter is required.
         * @param id - scoped id of the resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.amazon.awscdk.core.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.CfnGatewayResponseProps.Builder props;

        private Builder(final software.amazon.awscdk.core.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.CfnGatewayResponseProps.Builder();
        }

        /**
         * The response type.
         * <p>
         * For valid values, see <a href="https://docs.aws.amazon.com/apigateway/api-reference/resource/gateway-response/">GatewayResponse</a> in the <em>API Gateway API Reference</em> .
         * <p>
         * @return {@code this}
         * @param responseType The response type. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseType(final java.lang.String responseType) {
            this.props.responseType(responseType);
            return this;
        }

        /**
         * The identifier of the API.
         * <p>
         * @return {@code this}
         * @param restApiId The identifier of the API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder restApiId(final java.lang.String restApiId) {
            this.props.restApiId(restApiId);
            return this;
        }

        /**
         * The response parameters (paths, query strings, and headers) for the response.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @param responseParameters The response parameters (paths, query strings, and headers) for the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(final software.amazon.awscdk.core.IResolvable responseParameters) {
            this.props.responseParameters(responseParameters);
            return this;
        }
        /**
         * The response parameters (paths, query strings, and headers) for the response.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @param responseParameters The response parameters (paths, query strings, and headers) for the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(final java.util.Map<java.lang.String, java.lang.String> responseParameters) {
            this.props.responseParameters(responseParameters);
            return this;
        }

        /**
         * The response templates for the response.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @param responseTemplates The response templates for the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTemplates(final software.amazon.awscdk.core.IResolvable responseTemplates) {
            this.props.responseTemplates(responseTemplates);
            return this;
        }
        /**
         * The response templates for the response.
         * <p>
         * Duplicates not allowed.
         * <p>
         * @return {@code this}
         * @param responseTemplates The response templates for the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTemplates(final java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
            this.props.responseTemplates(responseTemplates);
            return this;
        }

        /**
         * The HTTP status code for the response.
         * <p>
         * @return {@code this}
         * @param statusCode The HTTP status code for the response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(final java.lang.String statusCode) {
            this.props.statusCode(statusCode);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.CfnGatewayResponse}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.CfnGatewayResponse build() {
            return new software.amazon.awscdk.services.apigateway.CfnGatewayResponse(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
