package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigateway.*;
 * IntegrationResponse integrationResponse = IntegrationResponse.builder()
 *         .statusCode("statusCode")
 *         // the properties below are optional
 *         .contentHandling(ContentHandling.CONVERT_TO_BINARY)
 *         .responseParameters(Map.of(
 *                 "responseParametersKey", "responseParameters"))
 *         .responseTemplates(Map.of(
 *                 "responseTemplatesKey", "responseTemplates"))
 *         .selectionPattern("selectionPattern")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-11T17:58:49.760Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.IntegrationResponse")
@software.amazon.jsii.Jsii.Proxy(IntegrationResponse.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IntegrationResponse extends software.amazon.jsii.JsiiSerializable {

    /**
     * The status code that API Gateway uses to map the integration response to a MethodResponse status code.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getStatusCode();

    /**
     * Specifies how to handle request payload content type conversions.
     * <p>
     * Default: none the request payload is passed through from the method
     * request to the integration request without modification.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
        return null;
    }

    /**
     * The response parameters from the backend response that API Gateway sends to the method response.
     * <p>
     * Use the destination as the key and the source as the value:
     * <p>
     * <ul>
     * <li>The destination must be an existing response parameter in the
     * MethodResponse property.</li>
     * <li>The source must be an existing method request parameter or a static
     * value. You must enclose static values in single quotation marks and
     * pre-encode these values based on the destination specified in the
     * request.</li>
     * </ul>
     * <p>
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/request-response-data-mappings.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
        return null;
    }

    /**
     * The templates that are used to transform the integration response body.
     * <p>
     * Specify templates as key-value pairs, with a content type as the key and
     * a template as the value.
     * <p>
     * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
        return null;
    }

    /**
     * Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
     * <p>
     * For example, if the success response returns nothing and the error response returns some string, you
     * could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any
     * newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error
     * header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
     * <p>
     * @see https://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-integration-settings-integration-response.html
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getSelectionPattern() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link IntegrationResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link IntegrationResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<IntegrationResponse> {
        java.lang.String statusCode;
        software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        java.util.Map<java.lang.String, java.lang.String> responseParameters;
        java.util.Map<java.lang.String, java.lang.String> responseTemplates;
        java.lang.String selectionPattern;

        /**
         * Sets the value of {@link IntegrationResponse#getStatusCode}
         * @param statusCode The status code that API Gateway uses to map the integration response to a MethodResponse status code. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder statusCode(java.lang.String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponse#getContentHandling}
         * @param contentHandling Specifies how to handle request payload content type conversions.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.contentHandling = contentHandling;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponse#getResponseParameters}
         * @param responseParameters The response parameters from the backend response that API Gateway sends to the method response.
         *                           Use the destination as the key and the source as the value:
         *                           <p>
         *                           <ul>
         *                           <li>The destination must be an existing response parameter in the
         *                           MethodResponse property.</li>
         *                           <li>The source must be an existing method request parameter or a static
         *                           value. You must enclose static values in single quotation marks and
         *                           pre-encode these values based on the destination specified in the
         *                           request.</li>
         *                           </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseParameters(java.util.Map<java.lang.String, java.lang.String> responseParameters) {
            this.responseParameters = responseParameters;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponse#getResponseTemplates}
         * @param responseTemplates The templates that are used to transform the integration response body.
         *                          Specify templates as key-value pairs, with a content type as the key and
         *                          a template as the value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseTemplates(java.util.Map<java.lang.String, java.lang.String> responseTemplates) {
            this.responseTemplates = responseTemplates;
            return this;
        }

        /**
         * Sets the value of {@link IntegrationResponse#getSelectionPattern}
         * @param selectionPattern Specifies the regular expression (regex) pattern used to choose an integration response based on the response from the back end.
         *                         For example, if the success response returns nothing and the error response returns some string, you
         *                         could use the <code>.+</code> regex to match error response. However, make sure that the error response does not contain any
         *                         newline (<code>\n</code>) character in such cases. If the back end is an AWS Lambda function, the AWS Lambda function error
         *                         header is matched. For all other HTTP and AWS back ends, the HTTP status code is matched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selectionPattern(java.lang.String selectionPattern) {
            this.selectionPattern = selectionPattern;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link IntegrationResponse}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public IntegrationResponse build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link IntegrationResponse}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements IntegrationResponse {
        private final java.lang.String statusCode;
        private final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling;
        private final java.util.Map<java.lang.String, java.lang.String> responseParameters;
        private final java.util.Map<java.lang.String, java.lang.String> responseTemplates;
        private final java.lang.String selectionPattern;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.statusCode = software.amazon.jsii.Kernel.get(this, "statusCode", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.contentHandling = software.amazon.jsii.Kernel.get(this, "contentHandling", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.ContentHandling.class));
            this.responseParameters = software.amazon.jsii.Kernel.get(this, "responseParameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.responseTemplates = software.amazon.jsii.Kernel.get(this, "responseTemplates", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.selectionPattern = software.amazon.jsii.Kernel.get(this, "selectionPattern", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.statusCode = java.util.Objects.requireNonNull(builder.statusCode, "statusCode is required");
            this.contentHandling = builder.contentHandling;
            this.responseParameters = builder.responseParameters;
            this.responseTemplates = builder.responseTemplates;
            this.selectionPattern = builder.selectionPattern;
        }

        @Override
        public final java.lang.String getStatusCode() {
            return this.statusCode;
        }

        @Override
        public final software.amazon.awscdk.services.apigateway.ContentHandling getContentHandling() {
            return this.contentHandling;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getResponseParameters() {
            return this.responseParameters;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getResponseTemplates() {
            return this.responseTemplates;
        }

        @Override
        public final java.lang.String getSelectionPattern() {
            return this.selectionPattern;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("statusCode", om.valueToTree(this.getStatusCode()));
            if (this.getContentHandling() != null) {
                data.set("contentHandling", om.valueToTree(this.getContentHandling()));
            }
            if (this.getResponseParameters() != null) {
                data.set("responseParameters", om.valueToTree(this.getResponseParameters()));
            }
            if (this.getResponseTemplates() != null) {
                data.set("responseTemplates", om.valueToTree(this.getResponseTemplates()));
            }
            if (this.getSelectionPattern() != null) {
                data.set("selectionPattern", om.valueToTree(this.getSelectionPattern()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("@aws-cdk/aws-apigateway.IntegrationResponse"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            IntegrationResponse.Jsii$Proxy that = (IntegrationResponse.Jsii$Proxy) o;

            if (!statusCode.equals(that.statusCode)) return false;
            if (this.contentHandling != null ? !this.contentHandling.equals(that.contentHandling) : that.contentHandling != null) return false;
            if (this.responseParameters != null ? !this.responseParameters.equals(that.responseParameters) : that.responseParameters != null) return false;
            if (this.responseTemplates != null ? !this.responseTemplates.equals(that.responseTemplates) : that.responseTemplates != null) return false;
            return this.selectionPattern != null ? this.selectionPattern.equals(that.selectionPattern) : that.selectionPattern == null;
        }

        @Override
        public final int hashCode() {
            int result = this.statusCode.hashCode();
            result = 31 * result + (this.contentHandling != null ? this.contentHandling.hashCode() : 0);
            result = 31 * result + (this.responseParameters != null ? this.responseParameters.hashCode() : 0);
            result = 31 * result + (this.responseTemplates != null ? this.responseTemplates.hashCode() : 0);
            result = 31 * result + (this.selectionPattern != null ? this.selectionPattern.hashCode() : 0);
            return result;
        }
    }
}
