package software.amazon.awscdk.services.apigateway;

/**
 * This type of integration lets API Gateway return a response without sending the request further to the backend.
 * <p>
 * This is useful for API testing because it
 * can be used to test the integration set up without incurring charges for
 * using the backend and to enable collaborative development of an API. In
 * collaborative development, a team can isolate their development effort by
 * setting up simulations of API components owned by other teams by using the
 * MOCK integrations. It is also used to return CORS-related headers to ensure
 * that the API method permits CORS access. In fact, the API Gateway console
 * integrates the OPTIONS method to support CORS with a mock integration.
 * Gateway responses are other examples of mock integrations.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import path.*;
 * import software.amazon.awscdk.services.lambda.*;
 * import software.amazon.awscdk.core.App;
 * import software.amazon.awscdk.core.Stack;
 * import software.amazon.awscdk.services.apigateway.MockIntegration;
 * import software.amazon.awscdk.services.apigateway.PassthroughBehavior;
 * import software.amazon.awscdk.services.apigateway.RestApi;
 * import software.amazon.awscdk.services.apigateway.RequestAuthorizer;
 * import software.amazon.awscdk.services.apigateway.IdentitySource;
 * // Against the RestApi endpoint from the stack output, run
 * // `curl -s -o /dev/null -w "%{http_code}" &lt;url&gt;` should return 401
 * // `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: deny' &lt;url&gt;?allow=yes` should return 403
 * // `curl -s -o /dev/null -w "%{http_code}" -H 'Authorization: allow' &lt;url&gt;?allow=yes` should return 200
 * App app = new App();
 * Stack stack = new Stack(app, "RequestAuthorizerInteg");
 * Function authorizerFn = Function.Builder.create(stack, "MyAuthorizerFunction")
 *         .runtime(Runtime.NODEJS_14_X)
 *         .handler("index.handler")
 *         .code(AssetCode.fromAsset(join(__dirname, "integ.request-authorizer.handler")))
 *         .build();
 * RestApi restapi = new RestApi(stack, "MyRestApi");
 * RequestAuthorizer authorizer = RequestAuthorizer.Builder.create(stack, "MyAuthorizer")
 *         .handler(authorizerFn)
 *         .identitySources(List.of(IdentitySource.header("Authorization"), IdentitySource.queryString("allow")))
 *         .build();
 * restapi.root.addMethod("ANY", MockIntegration.Builder.create()
 *         .integrationResponses(List.of(IntegrationResponse.builder().statusCode("200").build()))
 *         .passthroughBehavior(PassthroughBehavior.NEVER)
 *         .requestTemplates(Map.of(
 *                 "application/json", "{ \"statusCode\": 200 }"))
 *         .build(), MethodOptions.builder()
 *         .methodResponses(List.of(MethodResponse.builder().statusCode("200").build()))
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.50.0 (build d1830a4)", date = "2022-01-11T17:58:49.800Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.services.apigateway.$Module.class, fqn = "@aws-cdk/aws-apigateway.MockIntegration")
public class MockIntegration extends software.amazon.awscdk.services.apigateway.Integration {

    protected MockIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MockIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MockIntegration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.IntegrationOptions options) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { options });
    }

    /**
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public MockIntegration() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.MockIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.MockIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder options;

        private Builder() {
        }

        /**
         * A list of request parameters whose values are to be cached.
         * <p>
         * It determines
         * request parameters that will make it into the cache key.
         * <p>
         * @return {@code this}
         * @param cacheKeyParameters A list of request parameters whose values are to be cached. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheKeyParameters(final java.util.List<java.lang.String> cacheKeyParameters) {
            this.options().cacheKeyParameters(cacheKeyParameters);
            return this;
        }

        /**
         * An API-specific tag group of related cached parameters.
         * <p>
         * @return {@code this}
         * @param cacheNamespace An API-specific tag group of related cached parameters. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cacheNamespace(final java.lang.String cacheNamespace) {
            this.options().cacheNamespace(cacheNamespace);
            return this;
        }

        /**
         * The type of network connection to the integration endpoint.
         * <p>
         * Default: - ConnectionType.VPC_LINK if `vpcLink` property is configured; ConnectionType.Internet otherwise.
         * <p>
         * @return {@code this}
         * @param connectionType The type of network connection to the integration endpoint. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connectionType(final software.amazon.awscdk.services.apigateway.ConnectionType connectionType) {
            this.options().connectionType(connectionType);
            return this;
        }

        /**
         * Specifies how to handle request payload content type conversions.
         * <p>
         * Default: none if this property isn't defined, the request payload is passed
         * through from the method request to the integration request without
         * modification, provided that the `passthroughBehaviors` property is
         * configured to support payload pass-through.
         * <p>
         * @return {@code this}
         * @param contentHandling Specifies how to handle request payload content type conversions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder contentHandling(final software.amazon.awscdk.services.apigateway.ContentHandling contentHandling) {
            this.options().contentHandling(contentHandling);
            return this;
        }

        /**
         * Requires that the caller's identity be passed through from the request.
         * <p>
         * Default: Caller identity is not passed through
         * <p>
         * @return {@code this}
         * @param credentialsPassthrough Requires that the caller's identity be passed through from the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsPassthrough(final java.lang.Boolean credentialsPassthrough) {
            this.options().credentialsPassthrough(credentialsPassthrough);
            return this;
        }

        /**
         * An IAM role that API Gateway assumes.
         * <p>
         * Mutually exclusive with <code>credentialsPassThrough</code>.
         * <p>
         * Default: A role is not assumed
         * <p>
         * @return {@code this}
         * @param credentialsRole An IAM role that API Gateway assumes. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentialsRole(final software.amazon.awscdk.services.iam.IRole credentialsRole) {
            this.options().credentialsRole(credentialsRole);
            return this;
        }

        /**
         * The response that API Gateway provides after a method's backend completes processing a request.
         * <p>
         * API Gateway intercepts the response from the
         * backend so that you can control how API Gateway surfaces backend
         * responses. For example, you can map the backend status codes to codes
         * that you define.
         * <p>
         * @return {@code this}
         * @param integrationResponses The response that API Gateway provides after a method's backend completes processing a request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationResponses(final java.util.List<? extends software.amazon.awscdk.services.apigateway.IntegrationResponse> integrationResponses) {
            this.options().integrationResponses(integrationResponses);
            return this;
        }

        /**
         * Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource.
         * <p>
         * There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and
         * NEVER.
         * <p>
         * @return {@code this}
         * @param passthroughBehavior Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder passthroughBehavior(final software.amazon.awscdk.services.apigateway.PassthroughBehavior passthroughBehavior) {
            this.options().passthroughBehavior(passthroughBehavior);
            return this;
        }

        /**
         * The request parameters that API Gateway sends with the backend request.
         * <p>
         * Specify request parameters as key-value pairs (string-to-string
         * mappings), with a destination as the key and a source as the value.
         * <p>
         * Specify the destination by using the following pattern
         * integration.request.location.name, where location is querystring, path,
         * or header, and name is a valid, unique parameter name.
         * <p>
         * The source must be an existing method request parameter or a static
         * value. You must enclose static values in single quotation marks and
         * pre-encode these values based on their destination in the request.
         * <p>
         * @return {@code this}
         * @param requestParameters The request parameters that API Gateway sends with the backend request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestParameters(final java.util.Map<java.lang.String, java.lang.String> requestParameters) {
            this.options().requestParameters(requestParameters);
            return this;
        }

        /**
         * A map of Apache Velocity templates that are applied on the request payload.
         * <p>
         * The template that API Gateway uses is based on the value of the
         * Content-Type header that's sent by the client. The content type value is
         * the key, and the template is the value (specified as a string), such as
         * the following snippet:
         * <p>
         * <blockquote><pre>
         *    { "application/json": "{ \"statusCode\": 200 }" }
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @see http://docs.aws.amazon.com/apigateway/latest/developerguide/api-gateway-mapping-template-reference.html
         * @param requestTemplates A map of Apache Velocity templates that are applied on the request payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requestTemplates(final java.util.Map<java.lang.String, java.lang.String> requestTemplates) {
            this.options().requestTemplates(requestTemplates);
            return this;
        }

        /**
         * The maximum amount of time an integration will run before it returns without a response.
         * <p>
         * Must be between 50 milliseconds and 29 seconds.
         * <p>
         * Default: Duration.seconds(29)
         * <p>
         * @return {@code this}
         * @param timeout The maximum amount of time an integration will run before it returns without a response. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.core.Duration timeout) {
            this.options().timeout(timeout);
            return this;
        }

        /**
         * The VpcLink used for the integration.
         * <p>
         * Required if connectionType is VPC_LINK
         * <p>
         * @return {@code this}
         * @param vpcLink The VpcLink used for the integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcLink(final software.amazon.awscdk.services.apigateway.IVpcLink vpcLink) {
            this.options().vpcLink(vpcLink);
            return this;
        }

        /**
         * @returns a newly built instance of {@link software.amazon.awscdk.services.apigateway.MockIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.MockIntegration build() {
            return new software.amazon.awscdk.services.apigateway.MockIntegration(
                this.options != null ? this.options.build() : null
            );
        }

        private software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder options() {
            if (this.options == null) {
                this.options = new software.amazon.awscdk.services.apigateway.IntegrationOptions.Builder();
            }
            return this.options;
        }
    }
}
