package software.amazon.awscdk.services.apigateway;

/**
 * Properties for defining a `AWS::ApiGatewayV2::Authorizer`.
 * 
 * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html
 */
@javax.annotation.Generated(value = "jsii-pacmak/0.19.0 (build 7c562bc)", date = "2019-10-22T08:27:19.612Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
public interface CfnAuthorizerV2Props extends software.amazon.jsii.JsiiSerializable {

    /**
     * `AWS::ApiGatewayV2::Authorizer.ApiId`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-apiid
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getApiId();

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerType`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizertype
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAuthorizerType();

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizeruri
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAuthorizerUri();

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentitySource`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identitysource
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.util.List<java.lang.String> getIdentitySource();

    /**
     * `AWS::ApiGatewayV2::Authorizer.Name`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getName();

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizercredentialsarn
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getAuthorizerCredentialsArn();

    /**
     * `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-authorizerresultttlinseconds
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.Number getAuthorizerResultTtlInSeconds();

    /**
     * `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
     * 
     * @see http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigatewayv2-authorizer.html#cfn-apigatewayv2-authorizer-identityvalidationexpression
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    java.lang.String getIdentityValidationExpression();

    /**
     * @return a {@link Builder} of {@link CfnAuthorizerV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAuthorizerV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    public static final class Builder {
        private java.lang.String apiId;
        private java.lang.String authorizerType;
        private java.lang.String authorizerUri;
        private java.util.List<java.lang.String> identitySource;
        private java.lang.String name;
        private java.lang.String authorizerCredentialsArn;
        private java.lang.Number authorizerResultTtlInSeconds;
        private java.lang.String identityValidationExpression;

        /**
         * Sets the value of ApiId
         * @param apiId `AWS::ApiGatewayV2::Authorizer.ApiId`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder apiId(java.lang.String apiId) {
            this.apiId = apiId;
            return this;
        }

        /**
         * Sets the value of AuthorizerType
         * @param authorizerType `AWS::ApiGatewayV2::Authorizer.AuthorizerType`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerType(java.lang.String authorizerType) {
            this.authorizerType = authorizerType;
            return this;
        }

        /**
         * Sets the value of AuthorizerUri
         * @param authorizerUri `AWS::ApiGatewayV2::Authorizer.AuthorizerUri`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerUri(java.lang.String authorizerUri) {
            this.authorizerUri = authorizerUri;
            return this;
        }

        /**
         * Sets the value of IdentitySource
         * @param identitySource `AWS::ApiGatewayV2::Authorizer.IdentitySource`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder identitySource(java.util.List<java.lang.String> identitySource) {
            this.identitySource = identitySource;
            return this;
        }

        /**
         * Sets the value of Name
         * @param name `AWS::ApiGatewayV2::Authorizer.Name`. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of AuthorizerCredentialsArn
         * @param authorizerCredentialsArn `AWS::ApiGatewayV2::Authorizer.AuthorizerCredentialsArn`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerCredentialsArn(java.lang.String authorizerCredentialsArn) {
            this.authorizerCredentialsArn = authorizerCredentialsArn;
            return this;
        }

        /**
         * Sets the value of AuthorizerResultTtlInSeconds
         * @param authorizerResultTtlInSeconds `AWS::ApiGatewayV2::Authorizer.AuthorizerResultTtlInSeconds`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder authorizerResultTtlInSeconds(java.lang.Number authorizerResultTtlInSeconds) {
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            return this;
        }

        /**
         * Sets the value of IdentityValidationExpression
         * @param identityValidationExpression `AWS::ApiGatewayV2::Authorizer.IdentityValidationExpression`.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public Builder identityValidationExpression(java.lang.String identityValidationExpression) {
            this.identityValidationExpression = identityValidationExpression;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAuthorizerV2Props}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
        public CfnAuthorizerV2Props build() {
            return new Jsii$Proxy(apiId, authorizerType, authorizerUri, identitySource, name, authorizerCredentialsArn, authorizerResultTtlInSeconds, identityValidationExpression);
        }
    }

    /**
     * An implementation for {@link CfnAuthorizerV2Props}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.External)
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAuthorizerV2Props {
        private final java.lang.String apiId;
        private final java.lang.String authorizerType;
        private final java.lang.String authorizerUri;
        private final java.util.List<java.lang.String> identitySource;
        private final java.lang.String name;
        private final java.lang.String authorizerCredentialsArn;
        private final java.lang.Number authorizerResultTtlInSeconds;
        private final java.lang.String identityValidationExpression;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.setObjRef(objRef);
            this.apiId = this.jsiiGet("apiId", java.lang.String.class);
            this.authorizerType = this.jsiiGet("authorizerType", java.lang.String.class);
            this.authorizerUri = this.jsiiGet("authorizerUri", java.lang.String.class);
            this.identitySource = this.jsiiGet("identitySource", java.util.List.class);
            this.name = this.jsiiGet("name", java.lang.String.class);
            this.authorizerCredentialsArn = this.jsiiGet("authorizerCredentialsArn", java.lang.String.class);
            this.authorizerResultTtlInSeconds = this.jsiiGet("authorizerResultTtlInSeconds", java.lang.Number.class);
            this.identityValidationExpression = this.jsiiGet("identityValidationExpression", java.lang.String.class);
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        private Jsii$Proxy(java.lang.String apiId, java.lang.String authorizerType, java.lang.String authorizerUri, java.util.List<java.lang.String> identitySource, java.lang.String name, java.lang.String authorizerCredentialsArn, java.lang.Number authorizerResultTtlInSeconds, java.lang.String identityValidationExpression) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiId = java.util.Objects.requireNonNull(apiId, "apiId is required");
            this.authorizerType = java.util.Objects.requireNonNull(authorizerType, "authorizerType is required");
            this.authorizerUri = java.util.Objects.requireNonNull(authorizerUri, "authorizerUri is required");
            this.identitySource = java.util.Objects.requireNonNull(identitySource, "identitySource is required");
            this.name = java.util.Objects.requireNonNull(name, "name is required");
            this.authorizerCredentialsArn = authorizerCredentialsArn;
            this.authorizerResultTtlInSeconds = authorizerResultTtlInSeconds;
            this.identityValidationExpression = identityValidationExpression;
        }

        @Override
        public java.lang.String getApiId() {
            return this.apiId;
        }

        @Override
        public java.lang.String getAuthorizerType() {
            return this.authorizerType;
        }

        @Override
        public java.lang.String getAuthorizerUri() {
            return this.authorizerUri;
        }

        @Override
        public java.util.List<java.lang.String> getIdentitySource() {
            return this.identitySource;
        }

        @Override
        public java.lang.String getName() {
            return this.name;
        }

        @Override
        public java.lang.String getAuthorizerCredentialsArn() {
            return this.authorizerCredentialsArn;
        }

        @Override
        public java.lang.Number getAuthorizerResultTtlInSeconds() {
            return this.authorizerResultTtlInSeconds;
        }

        @Override
        public java.lang.String getIdentityValidationExpression() {
            return this.identityValidationExpression;
        }

        @Override
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("apiId", om.valueToTree(this.getApiId()));
            obj.set("authorizerType", om.valueToTree(this.getAuthorizerType()));
            obj.set("authorizerUri", om.valueToTree(this.getAuthorizerUri()));
            obj.set("identitySource", om.valueToTree(this.getIdentitySource()));
            obj.set("name", om.valueToTree(this.getName()));
            if (this.getAuthorizerCredentialsArn() != null) {
                obj.set("authorizerCredentialsArn", om.valueToTree(this.getAuthorizerCredentialsArn()));
            }
            if (this.getAuthorizerResultTtlInSeconds() != null) {
                obj.set("authorizerResultTtlInSeconds", om.valueToTree(this.getAuthorizerResultTtlInSeconds()));
            }
            if (this.getIdentityValidationExpression() != null) {
                obj.set("identityValidationExpression", om.valueToTree(this.getIdentityValidationExpression()));
            }
            return obj;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAuthorizerV2Props.Jsii$Proxy that = (CfnAuthorizerV2Props.Jsii$Proxy) o;

            if (!apiId.equals(that.apiId)) return false;
            if (!authorizerType.equals(that.authorizerType)) return false;
            if (!authorizerUri.equals(that.authorizerUri)) return false;
            if (!identitySource.equals(that.identitySource)) return false;
            if (!name.equals(that.name)) return false;
            if (this.authorizerCredentialsArn != null ? !this.authorizerCredentialsArn.equals(that.authorizerCredentialsArn) : that.authorizerCredentialsArn != null) return false;
            if (this.authorizerResultTtlInSeconds != null ? !this.authorizerResultTtlInSeconds.equals(that.authorizerResultTtlInSeconds) : that.authorizerResultTtlInSeconds != null) return false;
            return this.identityValidationExpression != null ? this.identityValidationExpression.equals(that.identityValidationExpression) : that.identityValidationExpression == null;
        }

        @Override
        public int hashCode() {
            int result = this.apiId.hashCode();
            result = 31 * result + (this.authorizerType.hashCode());
            result = 31 * result + (this.authorizerUri.hashCode());
            result = 31 * result + (this.identitySource.hashCode());
            result = 31 * result + (this.name.hashCode());
            result = 31 * result + (this.authorizerCredentialsArn != null ? this.authorizerCredentialsArn.hashCode() : 0);
            result = 31 * result + (this.authorizerResultTtlInSeconds != null ? this.authorizerResultTtlInSeconds.hashCode() : 0);
            result = 31 * result + (this.identityValidationExpression != null ? this.identityValidationExpression.hashCode() : 0);
            return result;
        }
    }
}
